/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.quickfix;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension2;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.xtext.ui.MarkerUtil;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IssueUtil;
import org.eclipse.xtext.ui.editor.quickfix.AbstractIssueResolutionProviderAdapter;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolution;
import org.eclipse.xtext.ui.editor.quickfix.QuickAssistCompletionProposal;
import org.eclipse.xtext.ui.editor.validation.XtextAnnotation;
import org.eclipse.xtext.validation.Issue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtextQuickAssistProcessor
extends AbstractIssueResolutionProviderAdapter
implements IQuickAssistProcessor {
    @Inject
    private IssueUtil issueUtil;
    @Inject
    private MarkerUtil markerUtil;
    private String errorMessage;

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean canFix(Annotation annotation) {
        if (annotation.isMarkedDeleted()) {
            return false;
        }
        if (annotation instanceof XtextAnnotation) {
            XtextAnnotation a = (XtextAnnotation)annotation;
            return this.getResolutionProvider().hasResolutionFor(a.getIssueCode());
        }
        if (annotation instanceof MarkerAnnotation) {
            MarkerAnnotation markerAnnotation = (MarkerAnnotation)annotation;
            if (!markerAnnotation.isQuickFixableStateSet()) {
                markerAnnotation.setQuickFixable(this.getResolutionProvider().hasResolutionFor(this.markerUtil.getCode((Annotation)markerAnnotation)));
            }
            return markerAnnotation.isQuickFixable();
        }
        return false;
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        return false;
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        ISourceViewer sourceViewer = invocationContext.getSourceViewer();
        if (sourceViewer == null) {
            return new ICompletionProposal[0];
        }
        IDocument document = sourceViewer.getDocument();
        if (!(document instanceof IXtextDocument)) {
            return new ICompletionProposal[0];
        }
        IXtextDocument xtextDocument = (IXtextDocument)document;
        IAnnotationModel annotationModel = sourceViewer.getAnnotationModel();
        ArrayList result = Lists.newArrayList();
        try {
            int offset = invocationContext.getOffset();
            Set<Annotation> applicableAnnotations = this.getApplicableAnnotations(xtextDocument, annotationModel, offset);
            for (Annotation annotation : applicableAnnotations) {
                Iterable<IssueResolution> resolutions;
                Issue issue = this.issueUtil.getIssueFromAnnotation(annotation);
                if (issue == null || !(resolutions = this.getResolutions(issue, xtextDocument)).iterator().hasNext()) continue;
                Position pos = annotationModel.getPosition(annotation);
                for (IssueResolution resolution : resolutions) {
                    result.add(this.create(pos, resolution));
                }
            }
            Iterator<Annotation> iterator = applicableAnnotations.iterator();
            if (iterator.hasNext() && !result.isEmpty()) {
                Position pos = annotationModel.getPosition(iterator.next());
                sourceViewer.setSelectedRange(pos.getOffset(), pos.getLength());
                sourceViewer.revealRange(pos.getOffset(), pos.getLength());
            }
        }
        catch (BadLocationException e) {
            this.errorMessage = e.getMessage();
        }
        this.sortQuickfixes(result);
        return result.toArray(new ICompletionProposal[result.size()]);
    }

    protected ICompletionProposal create(Position posisition, IssueResolution resolution) {
        return new QuickAssistCompletionProposal(posisition, resolution, this.getImage(resolution));
    }

    protected void sortQuickfixes(List<ICompletionProposal> quickFixes) {
        Collections.sort(quickFixes, new Comparator<ICompletionProposal>(){

            @Override
            public int compare(ICompletionProposal o1, ICompletionProposal o2) {
                return o1.getDisplayString().compareTo(o2.getDisplayString());
            }
        });
    }

    protected Set<Annotation> getApplicableAnnotations(IXtextDocument document, IAnnotationModel annotationModel, int offset) throws BadLocationException {
        int line = document.getLineOfOffset(offset);
        String delim = document.getLineDelimiter(line);
        int delimLength = delim != null ? delim.length() : 0;
        int lineLength = document.getLineLength(line) - delimLength;
        int lineOffset = document.getLineOffset(line);
        Iterator iterator = annotationModel instanceof IAnnotationModelExtension2 ? ((IAnnotationModelExtension2)annotationModel).getAnnotationIterator(lineOffset, lineLength, true, true) : annotationModel.getAnnotationIterator();
        HashSet possibleAnnotations = Sets.newHashSet();
        Annotation actualAnnotation = null;
        int nearestAnnotationOffset = Integer.MAX_VALUE;
        Annotation firstAnnotation = null;
        int offsetOfFirstAnnotation = Integer.MAX_VALUE;
        while (iterator.hasNext()) {
            int distanceToOffset;
            Position pos;
            Annotation annotationTemp;
            Object key = iterator.next();
            if (!(key instanceof Annotation) || !this.canFix(annotationTemp = (Annotation)key) || (pos = annotationModel.getPosition(annotationTemp)) == null || !pos.overlapsWith(lineOffset, lineLength)) continue;
            possibleAnnotations.add(annotationTemp);
            if (pos.getOffset() < offsetOfFirstAnnotation) {
                offsetOfFirstAnnotation = pos.getOffset();
                firstAnnotation = annotationTemp;
            }
            if ((distanceToOffset = offset - pos.getOffset()) < 0 || distanceToOffset >= nearestAnnotationOffset) continue;
            actualAnnotation = annotationTemp;
            nearestAnnotationOffset = distanceToOffset;
        }
        if (actualAnnotation == null) {
            actualAnnotation = firstAnnotation;
        }
        HashSet actualAnnotations = Sets.newHashSet();
        for (Annotation possibleAnnotation : possibleAnnotations) {
            Position actualAnnotationPosition;
            Position possibleAnnotationPosition = annotationModel.getPosition(possibleAnnotation);
            if (!possibleAnnotationPosition.equals((Object)(actualAnnotationPosition = annotationModel.getPosition(actualAnnotation)))) continue;
            actualAnnotations.add(possibleAnnotation);
        }
        return actualAnnotations;
    }

    public IssueUtil getIssueUtil() {
        return this.issueUtil;
    }

    public MarkerUtil getMarkerUtil() {
        return this.markerUtil;
    }
}

