/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.AbstractResourceDescriptionChangeEventSource;
import org.eclipse.xtext.resource.impl.ResourceDescriptionChangeEvent;
import org.eclipse.xtext.ui.editor.IDirtyResource;
import org.eclipse.xtext.ui.editor.IDirtyStateManager;

public class DirtyStateManager
extends AbstractResourceDescriptionChangeEventSource
implements IDirtyStateManager {
    private ConcurrentMap<URI, IDirtyResource> managedResources = Maps.newConcurrentHashMap();

    public void announceDirtyStateChanged(IDirtyResource dirtyResource) {
        this.managedResources.put(dirtyResource.getURI(), dirtyResource);
        this.notifyListeners(dirtyResource, true);
    }

    public void discardDirtyState(IDirtyResource dirtyResource) {
        if (this.managedResources.remove(dirtyResource.getURI(), dirtyResource)) {
            this.notifyListeners(dirtyResource, false);
        }
    }

    protected void notifyListeners(final IDirtyResource dirtyResource, boolean managed) {
        if (managed) {
            IResourceDescription.Delta delta = new IResourceDescription.Delta(){

                public boolean haveEObjectDescriptionsChanged() {
                    return true;
                }

                public IResourceDescription getOld() {
                    return null;
                }

                public IResourceDescription getNew() {
                    return dirtyResource.getDescription();
                }

                public URI getUri() {
                    return dirtyResource.getURI();
                }
            };
            this.notifyListeners((IResourceDescription.Event)new Event(Collections.singletonList(delta), this));
        } else {
            IResourceDescription.Delta delta = new IResourceDescription.Delta(){

                public boolean haveEObjectDescriptionsChanged() {
                    return true;
                }

                public IResourceDescription getOld() {
                    return dirtyResource.getDescription();
                }

                public IResourceDescription getNew() {
                    return null;
                }

                public URI getUri() {
                    return dirtyResource.getURI();
                }
            };
            this.notifyListeners((IResourceDescription.Event)new Event(Collections.singletonList(delta), this));
        }
    }

    public boolean manageDirtyState(IDirtyResource dirtyResource) {
        IDirtyResource prevValue = this.managedResources.putIfAbsent(dirtyResource.getURI(), dirtyResource);
        return prevValue == null || prevValue == dirtyResource;
    }

    public IDirtyResource getDirtyResource(URI uri) {
        return (IDirtyResource)this.managedResources.get(uri);
    }

    public IResourceDescription getDirtyResourceDescription(URI uri) {
        IDirtyResource dirtyResource = this.getDirtyResource(uri);
        if (dirtyResource != null) {
            return dirtyResource.getDescription();
        }
        return null;
    }

    public String getContent(URI uri) {
        IDirtyResource dirtyResource = (IDirtyResource)this.managedResources.get(uri);
        if (dirtyResource != null) {
            return dirtyResource.getContents();
        }
        return null;
    }

    public boolean hasContent(URI uri) {
        return this.managedResources.containsKey(uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Event
    extends ResourceDescriptionChangeEvent {
        public Event(Collection<IResourceDescription.Delta> delta, IResourceDescription.Event.Source sender) {
            super(delta, sender);
        }

        public IDirtyStateManager getSender() {
            return (IDirtyStateManager)super.getSender();
        }
    }
}

