/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.findrefs;

import com.google.inject.Inject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.OpenAndLinkWithEditorHelper;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.ui.editor.IURIEditorOpener;
import org.eclipse.xtext.ui.editor.findrefs.ReferenceSearchResultContentProvider;
import org.eclipse.xtext.ui.editor.findrefs.ReferenceSearchResultLabelProvider;
import org.eclipse.xtext.ui.editor.findrefs.ReferenceSearchViewPageActions;
import org.eclipse.xtext.ui.editor.findrefs.ReferenceSearchViewTreeNode;

public class ReferenceSearchViewPage
extends Page
implements ISearchResultPage {
    private String id;
    private ISearchResult searchResult;
    private Composite control;
    private TreeViewer viewer;
    private ISearchResultViewPart part;
    private IAction showNextAction;
    private IAction showPreviousAction = new ReferenceSearchViewPageActions.ShowPrevious(this);
    private IAction expandAllAction;
    private IAction collapseAllAction;
    @Inject
    private ReferenceSearchResultContentProvider contentProvider;
    @Inject
    private ReferenceSearchResultLabelProvider labelProvider;
    @Inject
    private IURIEditorOpener uriEditorOpener;

    public ReferenceSearchViewPage() {
        this.showNextAction = new ReferenceSearchViewPageActions.ShowNext(this);
        this.expandAllAction = new ReferenceSearchViewPageActions.ExpandAll(this);
        this.collapseAllAction = new ReferenceSearchViewPageActions.CollapseAll(this);
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getLabel() {
        return this.searchResult == null ? "" : this.searchResult.getLabel();
    }

    public Object getUIState() {
        return this.viewer.getSelection();
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInput(ISearchResult newSearchResult, Object uiState) {
        TreeViewer treeViewer = this.viewer;
        synchronized (treeViewer) {
            this.searchResult = newSearchResult;
            if (this.searchResult != null) {
                this.viewer.setInput((Object)newSearchResult);
                if (uiState instanceof ISelection) {
                    this.viewer.setSelection((ISelection)uiState);
                }
            }
            this.part.updateLabel();
        }
    }

    public void setViewPart(ISearchResultViewPart part) {
        this.part = part;
    }

    public void createControl(Composite parent) {
        this.control = new Composite(parent, 0);
        this.control.setLayoutData((Object)new GridData(1808));
        this.control.setSize(100, 100);
        this.control.setLayout((Layout)new FillLayout());
        this.viewer = new TreeViewer(this.control, 770);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        new OpenAndLinkWithEditorHelper((StructuredViewer)this.viewer){

            protected void activate(ISelection selection) {
                int currentMode = OpenStrategy.getOpenMethod();
                try {
                    OpenStrategy.setOpenMethod((int)0);
                    ReferenceSearchViewPage.this.handleOpen(new OpenEvent((Viewer)ReferenceSearchViewPage.this.viewer, selection));
                }
                finally {
                    OpenStrategy.setOpenMethod((int)currentMode);
                }
            }

            protected void linkToEditor(ISelection selection) {
            }

            protected void open(ISelection selection, boolean activate) {
                ReferenceSearchViewPage.this.handleOpen(new OpenEvent((Viewer)ReferenceSearchViewPage.this.viewer, selection));
            }
        };
        IToolBarManager tbm = this.getSite().getActionBars().getToolBarManager();
        this.fillToolbar(tbm);
        tbm.update(true);
    }

    protected void fillToolbar(IToolBarManager tbm) {
        tbm.appendToGroup("group.show", this.showNextAction);
        tbm.appendToGroup("group.show", this.showPreviousAction);
        IActionBars actionBars = this.getSite().getActionBars();
        if (actionBars != null) {
            actionBars.setGlobalActionHandler(ActionFactory.NEXT.getId(), this.showNextAction);
            actionBars.setGlobalActionHandler(ActionFactory.PREVIOUS.getId(), this.showPreviousAction);
        }
        tbm.appendToGroup("group.viewerSetup", this.expandAllAction);
        tbm.appendToGroup("group.viewerSetup", this.collapseAllAction);
    }

    protected void handleOpen(OpenEvent openEvent) {
        ISelection selection = openEvent.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object selectedObject : structuredSelection) {
                if (!(selectedObject instanceof ReferenceSearchViewTreeNode)) continue;
                ReferenceSearchViewTreeNode treeNode = (ReferenceSearchViewTreeNode)selectedObject;
                Object description = treeNode.getDescription();
                if (description instanceof IReferenceDescription) {
                    IReferenceDescription referenceDescription = (IReferenceDescription)description;
                    this.uriEditorOpener.open(referenceDescription.getSourceEObjectUri(), referenceDescription.getEReference(), referenceDescription.getIndexInList(), true);
                    continue;
                }
                if (!(description instanceof IResourceDescription)) continue;
                this.uriEditorOpener.open(((IResourceDescription)description).getURI(), true);
            }
        }
    }

    public Control getControl() {
        return this.control;
    }

    public void setFocus() {
        Control control = this.viewer.getControl();
        if (control != null && !control.isDisposed()) {
            control.setFocus();
        }
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }
}

