/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.outline.linking;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.xtext.ui.editor.outline.IContentOutlineNode;
import org.eclipse.xtext.ui.editor.outline.XtextContentOutlinePage;
import org.eclipse.xtext.ui.editor.outline.linking.AbstractSelectionChangedListener;

public final class OutlineSelectionChangedListener
extends AbstractSelectionChangedListener
implements IDoubleClickListener {
    public OutlineSelectionChangedListener(XtextContentOutlinePage outlinePage) {
        super(outlinePage);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.outlinePage.getControl().isFocusControl() && this.outlinePage.isLinkingEnabled()) {
            this.selectTextRegion(event.getSelection());
        }
    }

    protected void selectTextRegion(ISelection sel) {
        IContentOutlineNode outlineNode;
        IStructuredSelection structuredSelection;
        Object firstElement;
        if (sel instanceof IStructuredSelection && (firstElement = (structuredSelection = (IStructuredSelection)sel).getFirstElement()) instanceof IContentOutlineNode && (outlineNode = (IContentOutlineNode)firstElement).getRegion() != null) {
            this.getSourceViewer().setRangeIndication(outlineNode.getSelectionOffset(), outlineNode.getSelectionLength(), true);
            this.getSourceViewer().revealRange(outlineNode.getSelectionOffset(), outlineNode.getSelectionLength());
            this.getSourceViewer().setSelectedRange(outlineNode.getSelectionOffset(), outlineNode.getSelectionLength());
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        this.selectTextRegion(event.getSelection());
    }
}

