/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.quickfix;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.parsetree.AbstractNode;
import org.eclipse.xtext.parsetree.CompositeNode;
import org.eclipse.xtext.parsetree.NodeUtil;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.IssueModificationContext;
import org.eclipse.xtext.ui.editor.quickfix.AbstractDeclarativeQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.ISimilarityMatcher;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolution;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.ui.editor.quickfix.Messages;
import org.eclipse.xtext.ui.editor.quickfix.ReplaceModification;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.Issue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultQuickfixProvider
extends AbstractDeclarativeQuickfixProvider {
    @Inject
    private ISimilarityMatcher similarityMatcher;
    @Inject
    private IssueModificationContext.Factory modificationContextFactory;
    @Inject
    private Provider<IssueResolutionAcceptor> issueResolutionAcceptorProvider;
    @Inject
    private IScopeProvider scopeProvider;

    private CrossReference findCrossReference(EObject context, AbstractNode node) {
        if (node == null || context.equals(node.getElement())) {
            return null;
        }
        EObject grammarElement = node.getGrammarElement();
        if (grammarElement instanceof CrossReference) {
            return (CrossReference)grammarElement;
        }
        return this.findCrossReference(context, (AbstractNode)node.eContainer());
    }

    public List<IssueResolution> getResolutionsForLinkingIssue(Issue issue) {
        IssueResolutionAcceptor issueResolutionAcceptor = (IssueResolutionAcceptor)this.issueResolutionAcceptorProvider.get();
        this.createLinkingIssueResolutions(issue, issueResolutionAcceptor);
        return issueResolutionAcceptor.getIssueResolutions();
    }

    public void createLinkingIssueResolutions(final Issue issue, final IssueResolutionAcceptor issueResolutionAcceptor) {
        IModificationContext modificationContext = this.modificationContextFactory.createModificationContext(issue);
        final IXtextDocument xtextDocument = modificationContext.getXtextDocument();
        xtextDocument.readOnly((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

            public void process(XtextResource state) throws Exception {
                EObject target = state.getEObject(issue.getUriToProblem().fragment());
                EReference reference = DefaultQuickfixProvider.this.getUnresolvedEReference(issue, target);
                if (reference == null) {
                    return;
                }
                String issueString = xtextDocument.get(issue.getOffset(), issue.getLength());
                IScope scope = DefaultQuickfixProvider.this.scopeProvider.getScope(target, reference);
                ArrayList discardedDescriptions = Lists.newArrayList();
                HashSet qualifiedNames = Sets.newHashSet();
                int addedDescriptions = 0;
                for (IEObjectDescription referableElement : scope.getAllContents()) {
                    if (DefaultQuickfixProvider.this.similarityMatcher.isSimilar(issueString, referableElement.getName())) {
                        ++addedDescriptions;
                        this.createResolution(issueString, referableElement);
                        qualifiedNames.add(referableElement.getQualifiedName());
                        continue;
                    }
                    if (!qualifiedNames.add(referableElement.getQualifiedName())) continue;
                    discardedDescriptions.add(referableElement);
                }
                if (discardedDescriptions.size() + addedDescriptions <= 5) {
                    for (IEObjectDescription referableElement : discardedDescriptions) {
                        this.createResolution(issueString, referableElement);
                    }
                }
            }

            public void createResolution(String issueString, IEObjectDescription solution) {
                String replacement = solution.getName();
                String replaceLabel = DefaultQuickfixProvider.this.fixCrossReferenceLabel(issueString, replacement);
                issueResolutionAcceptor.accept(issue, replaceLabel, replaceLabel, DefaultQuickfixProvider.this.fixCrossReferenceImage(issueString, replacement), new ReplaceModification(issue, replacement));
            }
        });
    }

    protected EReference getUnresolvedEReference(Issue issue, EObject target) {
        CompositeNode rootNode = NodeUtil.getRootNode((EObject)target);
        AbstractNode leaf = NodeUtil.findLeafNodeAtOffset((CompositeNode)rootNode, (int)(issue.getOffset() + 1));
        CrossReference crossReference = this.findCrossReference(target, leaf);
        if (crossReference != null) {
            return GrammarUtil.getReference((CrossReference)crossReference);
        }
        return null;
    }

    protected String fixCrossReferenceLabel(String issueString, String replacement) {
        return String.valueOf(Messages.DefaultQuickfixProvider_changeTo) + replacement + Messages.DefaultQuickfixProvider_1;
    }

    protected String fixCrossReferenceImage(String issueString, String replacement) {
        return "";
    }

    @Override
    public List<IssueResolution> getResolutions(Issue issue) {
        if ("org.eclipse.xtext.diagnostics.Diagnostic.Linking".equals(issue.getCode())) {
            ArrayList<IssueResolution> result = new ArrayList<IssueResolution>();
            result.addAll(this.getResolutionsForLinkingIssue(issue));
            result.addAll(super.getResolutions(issue));
            return result;
        }
        return super.getResolutions(issue);
    }

    @Override
    public boolean hasResolutionFor(String issueCode) {
        return "org.eclipse.xtext.diagnostics.Diagnostic.Linking".equals(issueCode) || super.hasResolutionFor(issueCode);
    }
}

