/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.junit.editor.contentassist;

import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.xtext.ISetup;
import org.eclipse.xtext.junit.AbstractXtextTests;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.junit.editor.contentassist.MockableSelectionProvider;
import org.eclipse.xtext.ui.junit.editor.contentassist.MockableTextViewer;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentAssistProcessorTestBuilder {
    private final IContentAssistProcessor contentAssistProcessor;
    private String model;
    private int cursorPosition;
    private final ISetup setupClazz;
    private final AbstractXtextTests tests;

    public ContentAssistProcessorTestBuilder(ISetup setupClazz, AbstractXtextTests tests) throws Exception {
        this.setupClazz = setupClazz;
        this.tests = tests;
        tests.with(setupClazz);
        this.contentAssistProcessor = (IContentAssistProcessor)tests.get(IContentAssistProcessor.class);
    }

    public ContentAssistProcessorTestBuilder reset() throws Exception {
        return this.clone("", 0);
    }

    public ContentAssistProcessorTestBuilder append(String model) throws Exception {
        return this.clone(String.valueOf(this.getModel()) + model, this.cursorPosition + model.length());
    }

    public ContentAssistProcessorTestBuilder appendNl(String model) throws Exception {
        return this.append(model).append(Strings.newLine());
    }

    public ContentAssistProcessorTestBuilder insert(String model, int cursorPosition) throws Exception {
        StringBuilder builder = new StringBuilder(this.getModel()).insert(cursorPosition, model);
        return this.clone(builder.toString(), cursorPosition + model.length());
    }

    public ContentAssistProcessorTestBuilder cursorBack(int times) throws Exception {
        return this.clone(this.model, this.cursorPosition -= times);
    }

    public ContentAssistProcessorTestBuilder applyText() throws Exception {
        return this.applyText(0, true);
    }

    public ContentAssistProcessorTestBuilder applyText(boolean appendSpace) throws Exception {
        return this.applyText(0, appendSpace);
    }

    public ContentAssistProcessorTestBuilder applyText(int index, boolean appendSpace) throws Exception {
        ICompletionProposal proposal = this.computeCompletionProposals(this.getModel(), this.cursorPosition)[index];
        String text = proposal.getDisplayString();
        if (proposal instanceof ConfigurableCompletionProposal) {
            text = ((ConfigurableCompletionProposal)proposal).getReplacementString();
        }
        ContentAssistProcessorTestBuilder ret = this.append(text);
        if (appendSpace) {
            return ret.append(" ");
        }
        return ret;
    }

    public ContentAssistProcessorTestBuilder assertCount(int completionProposalCount) throws Exception {
        return this.assertCountAtCursorPosition(completionProposalCount, this.cursorPosition);
    }

    public ContentAssistProcessorTestBuilder assertText(String ... expectedText) throws Exception {
        return this.assertTextAtCursorPosition(this.cursorPosition, expectedText);
    }

    public ContentAssistProcessorTestBuilder assertTextAtCursorPosition(String cursorPosition, String ... expectedText) throws Exception {
        return this.assertTextAtCursorPosition(this.getModel().indexOf(cursorPosition), expectedText);
    }

    public ContentAssistProcessorTestBuilder assertTextAtCursorPosition(String cursorPosition, int offset, String ... expectedText) throws Exception {
        return this.assertTextAtCursorPosition(this.getModel().indexOf(cursorPosition) + offset, expectedText);
    }

    public ContentAssistProcessorTestBuilder assertTextAtCursorPosition(int cursorPosition, String ... expectedText) throws Exception {
        String currentModelToParse = this.getModel();
        ICompletionProposal[] computeCompletionProposals = this.computeCompletionProposals(currentModelToParse, cursorPosition);
        if (computeCompletionProposals == null) {
            computeCompletionProposals = new ICompletionProposal[]{};
        }
        Arrays.sort(expectedText);
        String expectation = Strings.concat((String)", ", Arrays.asList(expectedText));
        Assert.assertEquals((String)("expect " + expectedText.length + " CompletionProposal item for model '" + currentModelToParse + "': expectation was:\n" + expectation + "\nbut actual was:\n" + Strings.concat((String)", ", this.toString(computeCompletionProposals))), (int)expectedText.length, (int)computeCompletionProposals.length);
        int i = 0;
        while (i < computeCompletionProposals.length) {
            ICompletionProposal completionProposal = computeCompletionProposals[i];
            String proposedText = completionProposal.getDisplayString();
            if (completionProposal instanceof ConfigurableCompletionProposal) {
                ConfigurableCompletionProposal configurableProposal = (ConfigurableCompletionProposal)completionProposal;
                proposedText = configurableProposal.getReplacementString();
                if (configurableProposal.getTextApplier() != null) {
                    proposedText = configurableProposal.getTextApplier().getActualReplacementString(configurableProposal);
                }
            }
            Assert.assertTrue((String)("expect completionProposal text '" + expectation + "', but got " + Strings.concat((String)", ", this.toString(computeCompletionProposals))), (boolean)Arrays.asList(expectedText).contains(proposedText));
            ++i;
        }
        return this;
    }

    public ContentAssistProcessorTestBuilder assertMatchString(String matchString) throws Exception {
        ContentAssistContext[] contexts;
        String currentModelToParse = this.getModel();
        XtextResource xtextResource = this.tests.getResourceAndExpect((InputStream)new StringInputStream(currentModelToParse), Integer.MIN_VALUE);
        IXtextDocument xtextDocument = this.getDocument(xtextResource, currentModelToParse);
        ITextViewer textViewer = this.getTextViewer(currentModelToParse, xtextDocument);
        ContentAssistContext.Factory factory = (ContentAssistContext.Factory)this.tests.get(ContentAssistContext.Factory.class);
        ContentAssistContext[] contentAssistContextArray = contexts = factory.create(textViewer, currentModelToParse.length(), xtextResource);
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            ContentAssistContext context = contentAssistContextArray[n2];
            Assert.assertTrue((String)("matchString = '" + matchString + "', actual: '" + context.getPrefix() + "'"), ("".equals(context.getPrefix()) || matchString.equals(context.getPrefix()) ? 1 : 0) != 0);
            ++n2;
        }
        return this;
    }

    protected String getModel() {
        return this.model == null ? "" : this.model;
    }

    private List<String> toString(ICompletionProposal[] proposals) {
        if (proposals == null) {
            return Collections.emptyList();
        }
        ArrayList<String> res = new ArrayList<String>(proposals.length);
        ICompletionProposal[] iCompletionProposalArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionProposal proposal = iCompletionProposalArray[n2];
            String proposedText = proposal.getDisplayString();
            if (proposal instanceof ConfigurableCompletionProposal) {
                ConfigurableCompletionProposal configurableProposal = (ConfigurableCompletionProposal)proposal;
                proposedText = configurableProposal.getReplacementString();
                if (configurableProposal.getTextApplier() != null) {
                    proposedText = configurableProposal.getTextApplier().getActualReplacementString(configurableProposal);
                }
            }
            res.add(proposedText);
            ++n2;
        }
        Collections.sort(res);
        return res;
    }

    public ContentAssistProcessorTestBuilder assertCountAtCursorPosition(int completionProposalCount, int cursorPosition) throws Exception {
        String currentModelToParse = this.getModel();
        ICompletionProposal[] computeCompletionProposals = this.computeCompletionProposals(currentModelToParse, cursorPosition);
        StringBuffer computedProposals = new StringBuffer();
        int i = 0;
        while (i < computeCompletionProposals.length) {
            computedProposals.append(computeCompletionProposals[i].getDisplayString());
            if (i < computeCompletionProposals.length - 1) {
                computedProposals.append(",");
            }
            ++i;
        }
        Assert.assertEquals((String)("expect only " + completionProposalCount + " CompletionProposal item for model '" + currentModelToParse + "' but got '" + computedProposals + "'"), (int)completionProposalCount, (int)computeCompletionProposals.length);
        return this;
    }

    public ICompletionProposal[] computeCompletionProposals(String currentModelToParse, int cursorPosition) throws Exception {
        XtextResource xtextResource = this.tests.getResourceAndExpect((InputStream)new StringInputStream(currentModelToParse), Integer.MIN_VALUE);
        IXtextDocument xtextDocument = this.getDocument(xtextResource, currentModelToParse);
        return this.contentAssistProcessor.computeCompletionProposals(this.getTextViewer(currentModelToParse, xtextDocument), cursorPosition);
    }

    public ICompletionProposal[] computeCompletionProposals(int cursorPosition) throws Exception {
        return this.computeCompletionProposals(this.getModel(), cursorPosition);
    }

    public ICompletionProposal[] computeCompletionProposals(String cursorPosition) throws Exception {
        return this.computeCompletionProposals(this.getModel(), this.getModel().indexOf(cursorPosition));
    }

    public ICompletionProposal[] computeCompletionProposals() throws Exception {
        return this.computeCompletionProposals(this.getModel(), this.cursorPosition);
    }

    public String toString() {
        return String.valueOf(this.getModel()) + "\n length: " + this.getModel().length() + "\n cursor at: " + this.cursorPosition;
    }

    public IXtextDocument getDocument(final XtextResource xtextResource, final String model) {
        IXtextDocument xtextDocument = (IXtextDocument)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{IXtextDocument.class}, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (args != null && args[0] instanceof IUnitOfWork) {
                    return ((IUnitOfWork)args[0]).exec((Object)xtextResource);
                }
                if (method.getName().equals("get")) {
                    if (args != null && args.length == 2) {
                        int from = (Integer)args[0];
                        int length = (Integer)args[1];
                        return model.substring(from, length - from);
                    }
                    return model;
                }
                if (method.getName().equals("getLength")) {
                    return Integer.MAX_VALUE;
                }
                throw new UnsupportedOperationException("The test mock IXtextDocument does not support the operation " + method);
            }
        });
        return xtextDocument;
    }

    public ITextViewer getTextViewer(String currentModelToParse, final IXtextDocument xtextDocument) {
        MockableTextViewer result = new MockableTextViewer(){

            public IDocument getDocument() {
                return xtextDocument;
            }

            public ISelectionProvider getSelectionProvider() {
                return new MockableSelectionProvider(){

                    public ISelection getSelection() {
                        return TextSelection.emptySelection();
                    }
                };
            }
        };
        return result;
    }

    private ContentAssistProcessorTestBuilder clone(String model, int offset) throws Exception {
        ContentAssistProcessorTestBuilder builder = new ContentAssistProcessorTestBuilder(this.setupClazz, this.tests);
        builder.model = model;
        builder.cursorPosition = offset;
        return builder;
    }

    public <T> T get(Class<T> clazz) {
        return (T)this.tests.get(clazz);
    }
}

