/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.ui.editor;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.text.IRegion;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.folding.DefaultFoldingRegionAcceptor;
import org.eclipse.xtext.ui.editor.folding.DefaultFoldingRegionProvider;
import org.eclipse.xtext.ui.editor.folding.FoldedPosition;
import org.eclipse.xtext.ui.editor.folding.IFoldingRegionAcceptor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xtend2.ui.editor.InitiallyCollapsableFoldedPosition;
import org.eclipse.xtext.xtend2.xtend2.Xtend2Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xtend2FoldingRegionProvider
extends DefaultFoldingRegionProvider {
    protected boolean isHandled(EObject object) {
        EClass clazz = object.eClass();
        return clazz == Xtend2Package.Literals.XTEND_CLASS || clazz == Xtend2Package.Literals.XTEND_FUNCTION || clazz == Xtend2Package.Literals.XTEND_CONSTRUCTOR;
    }

    protected boolean shouldProcessContent(EObject object) {
        EClass clazz = object.eClass();
        return clazz == Xtend2Package.Literals.XTEND_CLASS || clazz == Xtend2Package.Literals.XTEND_FILE;
    }

    protected Collection<FoldedPosition> doGetFoldingRegions(IXtextDocument xtextDocument, XtextResource xtextResource) {
        Collection result = super.doGetFoldingRegions(xtextDocument, xtextResource);
        IFoldingRegionAcceptor<ITextRegion> foldingRegionAcceptor = this.createAcceptor(xtextDocument, result, true);
        this.computeImportFolding(xtextResource, foldingRegionAcceptor);
        return result;
    }

    protected void computeImportFolding(XtextResource xtextResource, IFoldingRegionAcceptor<ITextRegion> foldingRegionAcceptor) {
        ITextRegion textRegion;
        EObject rootASTElement;
        IParseResult parseResult = xtextResource.getParseResult();
        if (parseResult != null && (rootASTElement = parseResult.getRootASTElement()) != null && (textRegion = this.getFullTextRegionForFeature(rootASTElement, (EStructuralFeature)Xtend2Package.Literals.XTEND_FILE__IMPORTS)) != null) {
            foldingRegionAcceptor.accept(textRegion.getOffset(), textRegion.getLength());
        }
    }

    protected ITextRegion getFullTextRegionForFeature(EObject owner, EStructuralFeature feature) {
        List childs = NodeModelUtils.findNodesForFeature((EObject)owner, (EStructuralFeature)feature);
        if (childs.size() > 1) {
            INode firstChild = (INode)childs.get(0);
            INode lastChild = (INode)childs.get(childs.size() - 1);
            int offset = firstChild.getOffset();
            int length = lastChild.getOffset() + lastChild.getLength() - offset;
            return new TextRegion(offset, length);
        }
        return null;
    }

    protected IFoldingRegionAcceptor<ITextRegion> createAcceptor(IXtextDocument xtextDocument, Collection<FoldedPosition> foldedPositions, final boolean initiallyCollapsed) {
        return new DefaultFoldingRegionAcceptor(xtextDocument, foldedPositions){

            protected FoldedPosition newFoldedPosition(IRegion region, ITextRegion significantRegion) {
                if (region == null) {
                    return null;
                }
                if (significantRegion != null) {
                    return new InitiallyCollapsableFoldedPosition(region.getOffset(), region.getLength(), significantRegion.getOffset() - region.getOffset(), significantRegion.getLength(), initiallyCollapsed);
                }
                return new InitiallyCollapsableFoldedPosition(region.getOffset(), region.getLength(), -1, -1, initiallyCollapsed);
            }
        };
    }
}

