/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.ui.highlighting;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.List;
import java.util.Queue;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.util.DeprecationUtil;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.ui.highlighting.XbaseHighlightingCalculator;
import org.eclipse.xtext.xtend2.richstring.AbstractRichStringPartAcceptor;
import org.eclipse.xtext.xtend2.richstring.DefaultIndentationHandler;
import org.eclipse.xtext.xtend2.richstring.IRichStringIndentationHandler;
import org.eclipse.xtext.xtend2.richstring.IRichStringPartAcceptor;
import org.eclipse.xtext.xtend2.richstring.RichStringProcessor;
import org.eclipse.xtext.xtend2.services.Xtend2GrammarAccess;
import org.eclipse.xtext.xtend2.xtend2.RichString;
import org.eclipse.xtext.xtend2.xtend2.RichStringLiteral;
import org.eclipse.xtext.xtend2.xtend2.Xtend2Package;
import org.eclipse.xtext.xtend2.xtend2.XtendAnnotationTarget;
import org.eclipse.xtext.xtend2.xtend2.XtendClass;
import org.eclipse.xtext.xtend2.xtend2.XtendField;
import org.eclipse.xtext.xtend2.xtend2.XtendFile;
import org.eclipse.xtext.xtend2.xtend2.XtendFunction;
import org.eclipse.xtext.xtend2.xtend2.XtendMember;

public class XtendHighlightingCalculator
extends XbaseHighlightingCalculator {
    @Inject
    private RichStringProcessor processor;
    @Inject
    private Provider<DefaultIndentationHandler> indentationHandlerProvider;
    private Keyword createKeyword;

    @Inject
    protected void setXtendGrammarAccess(Xtend2GrammarAccess grammarAccess) {
        this.createKeyword = grammarAccess.getValidIDAccess().getCreateKeyword_1();
    }

    protected void doProvideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor) {
        XtendFile file = (XtendFile)resource.getContents().get(0);
        XtendClass xtendClass = file.getXtendClass();
        this.highlightDeprectedXtendAnnotationTarget(acceptor, (EObject)xtendClass);
        if (xtendClass != null) {
            for (XtendMember member : xtendClass.getMembers()) {
                if (member.eClass() == Xtend2Package.Literals.XTEND_FUNCTION) {
                    XtendFunction function = (XtendFunction)member;
                    XExpression rootExpression = function.getExpression();
                    this.highlightRichStrings(rootExpression, acceptor);
                }
                if (member.eClass() == Xtend2Package.Literals.XTEND_FIELD) {
                    XtendField field = (XtendField)member;
                    this.highlightXtendField(field, acceptor);
                }
                this.highlightDeprectedXtendAnnotationTarget(acceptor, (EObject)member);
            }
        }
        super.doProvideHighlightingFor(resource, acceptor);
    }

    protected void highlightReferenceJvmType(IHighlightedPositionAcceptor acceptor, EObject referencer, EReference reference, EObject resolvedReferencedObject) {
        super.highlightReferenceJvmType(acceptor, referencer, reference, resolvedReferencedObject);
        if (referencer.eContainer() != null && referencer.eContainer().eClass() == Xtend2Package.Literals.XTEND_CLASS && resolvedReferencedObject instanceof JvmAnnotationTarget && DeprecationUtil.isDeprecated((JvmAnnotationTarget)((JvmAnnotationTarget)resolvedReferencedObject))) {
            this.highlightObjectAtFeature(acceptor, referencer, (EStructuralFeature)reference, "xbase.deprecated.members");
        }
    }

    protected void highlightDeprectedXtendAnnotationTarget(IHighlightedPositionAcceptor acceptor, EObject object) {
        if (object != null && object instanceof XtendAnnotationTarget) {
            for (XAnnotation annotation : ((XtendAnnotationTarget)object).getAnnotations()) {
                JvmAnnotationType annotationType = annotation.getAnnotationType();
                if (annotationType == null || annotationType.eIsProxy() || !DeprecationUtil.isDeprecated((JvmAnnotationType)annotationType)) continue;
                EStructuralFeature nameFeature = object.eClass().getEStructuralFeature("name");
                this.highlightObjectAtFeature(acceptor, object, nameFeature, "xbase.deprecated.members");
            }
        }
    }

    protected void highlightRichStrings(XExpression expression, IHighlightedPositionAcceptor acceptor) {
        if (expression != null) {
            TreeIterator iterator = EcoreUtil2.eAll((EObject)expression);
            while (iterator.hasNext()) {
                EObject object = (EObject)iterator.next();
                if (!(object instanceof RichString)) continue;
                RichStringHighlighter highlighter = this.createRichStringHighlighter(acceptor);
                this.processor.process((RichString)object, (IRichStringPartAcceptor)highlighter, (IRichStringIndentationHandler)this.indentationHandlerProvider.get());
                iterator.prune();
            }
        }
    }

    protected RichStringHighlighter createRichStringHighlighter(IHighlightedPositionAcceptor acceptor) {
        return new RichStringHighlighter(acceptor);
    }

    protected void highlightSpecialIdentifiers(ILeafNode leafNode, IHighlightedPositionAcceptor acceptor, TerminalRule idRule) {
        super.highlightSpecialIdentifiers(leafNode, acceptor, idRule);
        if (leafNode.getGrammarElement() == this.createKeyword) {
            acceptor.addPosition(leafNode.getOffset(), leafNode.getLength(), new String[]{"default"});
        }
    }

    protected void highlightXtendField(XtendField field, IHighlightedPositionAcceptor acceptor) {
        List nodes;
        if (field.getName() != null && field.getName().length() > 0 && (nodes = NodeModelUtils.findNodesForFeature((EObject)field, (EStructuralFeature)Xtend2Package.Literals.XTEND_FIELD__NAME)).size() > 0) {
            INode node = (INode)nodes.get(0);
            this.highlightNode(node, "xbase.field", acceptor);
            if (field.isStatic()) {
                this.highlightNode(node, "xbase.static.field", acceptor);
            }
        }
    }

    protected class RichStringHighlighter
    extends AbstractRichStringPartAcceptor.ForLoopOnce {
        private int currentOffset = -1;
        private RichStringLiteral recent = null;
        private final IHighlightedPositionAcceptor acceptor;
        private Queue<IRegion> pendingRegions = Lists.newLinkedList();

        public RichStringHighlighter(IHighlightedPositionAcceptor acceptor) {
            this.acceptor = acceptor;
        }

        public void announceNextLiteral(RichStringLiteral object) {
            this.resetCurrentOffset(object);
        }

        public void acceptSemanticText(CharSequence text, RichStringLiteral origin) {
            this.resetCurrentOffset(origin);
            this.currentOffset += text.length();
        }

        protected void resetCurrentOffset(RichStringLiteral origin) {
            if (origin != null && origin != this.recent) {
                List featureNodes;
                INode recentNode = null;
                if (this.recent != null && this.currentOffset != -1 && (featureNodes = NodeModelUtils.findNodesForFeature((EObject)this.recent, (EStructuralFeature)XbasePackage.Literals.XSTRING_LITERAL__VALUE)).size() == 1) {
                    recentNode = (INode)featureNodes.get(0);
                    int closingQuoteLength = 0;
                    if (recentNode.getText().endsWith("'''")) {
                        closingQuoteLength = 3;
                    } else if (recentNode.getText().endsWith("''")) {
                        closingQuoteLength = 2;
                    } else if (recentNode.getText().endsWith("'") || recentNode.getText().endsWith("\u00ab")) {
                        closingQuoteLength = 1;
                    }
                    int expectedOffset = recentNode.getTotalEndOffset() - closingQuoteLength;
                    if (expectedOffset != this.currentOffset) {
                        this.pendingRegions.add((IRegion)new Region(this.currentOffset, expectedOffset - this.currentOffset));
                    }
                }
                if ((featureNodes = NodeModelUtils.findNodesForFeature((EObject)origin, (EStructuralFeature)XbasePackage.Literals.XSTRING_LITERAL__VALUE)).size() == 1) {
                    INode node = (INode)featureNodes.get(0);
                    this.currentOffset = node.getOffset();
                    if (node.getText().charAt(0) == '\'') {
                        this.acceptor.addPosition(this.currentOffset, 3, new String[]{"xtend2.insignificant.template.text"});
                        this.highlightClosingQuotes(node);
                        this.currentOffset += 3;
                    } else if (node.getText().startsWith("\u00ab\u00ab")) {
                        String nodeText = node.getText();
                        int length = nodeText.indexOf(10);
                        int start = node.getTotalOffset();
                        if (length == -1) {
                            length = node.getTotalLength();
                        }
                        if (recentNode != null && recentNode.getTotalEndOffset() == start) {
                            this.acceptor.addPosition(start - 1, 1, new String[]{"comment"});
                        }
                        this.acceptor.addPosition(start, length, new String[]{"comment"});
                        this.highlightClosingQuotes(node);
                        this.currentOffset = start + length + 1;
                    } else {
                        this.highlightClosingQuotes(node);
                        ++this.currentOffset;
                    }
                }
                this.recent = origin;
            }
        }

        protected void highlightClosingQuotes(INode node) {
            int length = 0;
            if (node.getText().endsWith("'''")) {
                length = 3;
            } else if (node.getText().endsWith("''")) {
                length = 2;
            } else if (node.getText().endsWith("'")) {
                length = 1;
            }
            if (length != 0) {
                this.acceptor.addPosition(this.currentOffset + node.getLength() - length, length, new String[]{"xtend2.insignificant.template.text"});
            }
        }

        public void acceptTemplateText(CharSequence text, RichStringLiteral origin) {
            this.resetCurrentOffset(origin);
            if (text.length() > 0) {
                int length = text.length();
                while (!this.pendingRegions.isEmpty()) {
                    IRegion pending = this.pendingRegions.poll();
                    length -= pending.getLength();
                    this.acceptor.addPosition(pending.getOffset(), pending.getLength(), new String[]{"xtend2.insignificant.template.text"});
                }
                if (length != 0) {
                    this.acceptor.addPosition(this.currentOffset, length, new String[]{"xtend2.insignificant.template.text"});
                    this.currentOffset += length;
                }
            }
        }

        public void acceptSemanticLineBreak(int charCount, RichStringLiteral origin, boolean controlStructureSeen) {
            this.resetCurrentOffset(origin);
            if (controlStructureSeen) {
                this.acceptor.addPosition(this.currentOffset, charCount, new String[]{"xtend2.potential.line.break"});
            } else {
                this.acceptor.addPosition(this.currentOffset, charCount, new String[]{"xtend2.template.line.break"});
            }
            this.currentOffset += charCount;
        }

        public void acceptTemplateLineBreak(int charCount, RichStringLiteral origin) {
            this.resetCurrentOffset(origin);
            this.currentOffset += charCount;
        }

        public void acceptIfCondition(XExpression condition) {
            XtendHighlightingCalculator.this.highlightRichStrings(condition, this.acceptor);
        }

        public void acceptElseIfCondition(XExpression condition) {
            XtendHighlightingCalculator.this.highlightRichStrings(condition, this.acceptor);
        }

        public void acceptForLoop(JvmFormalParameter parameter, XExpression expression) {
            XtendHighlightingCalculator.this.highlightRichStrings(expression, this.acceptor);
            super.acceptForLoop(parameter, expression);
        }

        public void acceptExpression(XExpression expression, CharSequence indentation) {
            XtendHighlightingCalculator.this.highlightRichStrings(expression, this.acceptor);
        }
    }
}

