/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.ui.launching;

import com.google.inject.Inject;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.builder.DerivedResourceMarkers;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parsetree.reconstr.impl.NodeIterator;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xtend2.xtend2.XtendFunction;

public class JavaElementDelegate
implements IAdaptable {
    private static final Logger log = Logger.getLogger(JavaElementDelegate.class);
    private IEditorPart editor;
    private IResource resource;
    private IFileEditorInput editorInput;
    @Inject
    private DerivedResourceMarkers derivedResourceMarkers;
    @Inject
    private FileExtensionProvider fileExtensionProvider;

    public void initializeWith(IEditorPart editorInput) {
        this.editor = editorInput;
    }

    public void initializeWith(IFileEditorInput editorInput) {
        this.editorInput = editorInput;
    }

    public void initializeWith(IResource resource) {
        this.resource = resource;
    }

    public Object getAdapter(Class adapter) {
        if (IJavaElement.class.equals((Object)adapter)) {
            if (this.editorInput != null) {
                IFile file = this.editorInput.getFile();
                if (this.fileExtensionProvider.isValid(file.getFileExtension())) {
                    return this.getJavaElementForResource((IResource)file);
                }
            } else if (this.editor != null) {
                IJavaElement javaFile = this.getJavaElementForEditor(this.editor);
                if (javaFile != null) {
                    IJavaElement javaMethod = this.getJavaElementForXtextEditor(javaFile, this.editor);
                    if (javaMethod != null) {
                        return javaMethod;
                    }
                    return javaFile;
                }
            } else if (this.resource != null && this.fileExtensionProvider.isValid(this.resource.getFileExtension())) {
                return this.getJavaElementForResource(this.resource);
            }
        }
        return null;
    }

    protected XtendFunction findFunction(XtextResource resource, int offset) {
        if (resource.getParseResult() == null) {
            return null;
        }
        ICompositeNode root = resource.getParseResult().getRootNode();
        ILeafNode node = NodeModelUtils.findLeafNodeAtOffset((INode)root, (int)offset);
        if (node == null) {
            return null;
        }
        INode previousSementic = null;
        INode nextSemantic = null;
        NodeIterator backwards = new NodeIterator((INode)node);
        while (backwards.hasPrevious()) {
            INode n = backwards.previous();
            if (!(n instanceof ILeafNode) || ((ILeafNode)n).isHidden()) continue;
            previousSementic = n;
            break;
        }
        NodeIterator forward = new NodeIterator((INode)node);
        while (forward.hasNext()) {
            INode n = forward.next();
            if (!(n instanceof ILeafNode) || ((ILeafNode)n).isHidden()) continue;
            nextSemantic = n;
            break;
        }
        if (previousSementic == null || nextSemantic == null) {
            return null;
        }
        EObject prevObj = NodeModelUtils.findActualSemanticObjectFor((INode)previousSementic);
        EObject nextObj = NodeModelUtils.findActualSemanticObjectFor(nextSemantic);
        if (prevObj == null || nextObj == null) {
            return null;
        }
        XtendFunction prev = (XtendFunction)EcoreUtil2.getContainerOfType((EObject)prevObj, XtendFunction.class);
        XtendFunction next = (XtendFunction)EcoreUtil2.getContainerOfType((EObject)nextObj, XtendFunction.class);
        if (prev != null && prev == next) {
            return prev;
        }
        return null;
    }

    protected IJavaElement getJavaElementForXtextEditor(IJavaElement javaFile, IEditorPart editor) {
        block8: {
            if (!(editor instanceof XtextEditor)) {
                return null;
            }
            XtextEditor xtextEditor = (XtextEditor)editor;
            ISelection selection = xtextEditor.getSelectionProvider().getSelection();
            if (!(selection instanceof ITextSelection)) {
                return null;
            }
            final int offset = ((ITextSelection)selection).getOffset();
            XtendFunction func = (XtendFunction)xtextEditor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<XtendFunction, XtextResource>(){

                public XtendFunction exec(XtextResource state) throws Exception {
                    return JavaElementDelegate.this.findFunction(state, offset);
                }
            });
            if (func == null || Strings.isEmpty((String)func.getName())) {
                return null;
            }
            if (!(javaFile instanceof IParent)) {
                return null;
            }
            try {
                IJavaElement[] iJavaElementArray = ((IParent)javaFile).getChildren();
                int n = iJavaElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IType type;
                    IMethod method;
                    IJavaElement child = iJavaElementArray[n2];
                    if (child instanceof IType && (method = (type = (IType)child).getMethod(func.getName(), new String[0])) != null) {
                        return method;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                if (!log.isDebugEnabled()) break block8;
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    protected IJavaElement getJavaElementForEditor(IEditorPart editor) {
        IFile file;
        if (editor.getEditorInput() instanceof IFileEditorInput && this.fileExtensionProvider.isValid((file = ((IFileEditorInput)editor.getEditorInput()).getFile()).getFileExtension())) {
            return this.getJavaElementForResource((IResource)file);
        }
        return null;
    }

    protected IJavaElement getJavaElementForResource(IResource resource) {
        block3: {
            try {
                String getSourcePath = URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true).toString();
                List resources = this.derivedResourceMarkers.findDerivedResources((IContainer)resource.getProject(), getSourcePath);
                if (resources.size() >= 1) {
                    return JavaCore.create((IFile)((IFile)resources.get(0)));
                }
            }
            catch (CoreException e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }
}

