/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.editor.syntaxcoloring;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ui.editor.syntaxcoloring.ISemanticHighlightingCalculator;
import org.eclipse.xtext.xtext.UsedRulesFinder;

public class SemanticHighlightingCalculator
implements ISemanticHighlightingCalculator {
    public void provideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor) {
        if (resource == null) {
            return;
        }
        TreeIterator iter = EcoreUtil.getAllContents((Resource)resource, (boolean)true);
        HashSet calledRules = Sets.newHashSet();
        while (iter.hasNext()) {
            ParserRule container;
            RuleCall call;
            INode node;
            EObject current = (EObject)iter.next();
            if (current instanceof Grammar) {
                Grammar grammar = (Grammar)current;
                if (grammar.getRules().isEmpty()) continue;
                UsedRulesFinder usedRulesFinder = new UsedRulesFinder((Collection)calledRules);
                usedRulesFinder.compute(grammar);
                continue;
            }
            if (current instanceof AbstractRule) {
                node = this.getFirstFeatureNode(current, (EStructuralFeature)XtextPackage.Literals.ABSTRACT_RULE__NAME);
                this.highlightNode(node, "RuleDeclaration", acceptor);
                if (current instanceof ParserRule && GrammarUtil.isDatatypeRule((ParserRule)((ParserRule)current))) {
                    this.highlightNode(node, "DataTypeIndicator", acceptor);
                }
                if (calledRules.isEmpty() || calledRules.contains(current)) continue;
                this.highlightNode(node, "NeverCalledRule", acceptor);
                continue;
            }
            if (current instanceof TypeRef) {
                node = this.getFirstFeatureNode(current, null);
                this.highlightNode(node, "TypeReference", acceptor);
                continue;
            }
            if (!(current instanceof RuleCall) || !((call = (RuleCall)current).getRule() instanceof TerminalRule) && (!(call.getRule() instanceof ParserRule) || !GrammarUtil.isDatatypeRule((ParserRule)((ParserRule)call.getRule()))) || EcoreUtil2.getContainerOfType((EObject)call, Assignment.class) != null || (container = GrammarUtil.containingParserRule((EObject)call)) == null || GrammarUtil.isDatatypeRule((ParserRule)container)) continue;
            INode node2 = this.getFirstFeatureNode((EObject)call, (EStructuralFeature)XtextPackage.Literals.RULE_CALL__RULE);
            this.highlightNode(node2, "UnusedValue", acceptor);
        }
    }

    private void highlightNode(INode node, String id, IHighlightedPositionAcceptor acceptor) {
        if (node == null) {
            return;
        }
        if (node instanceof ILeafNode) {
            acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{id});
        } else {
            for (ILeafNode leaf : node.getLeafNodes()) {
                if (leaf.isHidden()) continue;
                acceptor.addPosition(leaf.getOffset(), leaf.getLength(), new String[]{id});
            }
        }
    }

    public INode getFirstFeatureNode(EObject semantic, EStructuralFeature feature) {
        if (feature == null) {
            return NodeModelUtils.findActualNodeFor((EObject)semantic);
        }
        List nodes = NodeModelUtils.findNodesForFeature((EObject)semantic, (EStructuralFeature)feature);
        if (!nodes.isEmpty()) {
            return (INode)nodes.get(0);
        }
        return null;
    }
}

