/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.annotations.validation;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.TypeConformanceComputer;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.annotations.typing.XAnnotationUtil;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationElementValuePair;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsPackage;
import org.eclipse.xtext.xbase.typing.ITypeProvider;
import org.eclipse.xtext.xbase.validation.XbaseJavaValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XbaseWithAnnotationsJavaValidator
extends XbaseJavaValidator {
    @Inject
    private ITypeProvider typeProvider;
    @Inject
    private TypeConformanceComputer conformanceComputer;
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private XAnnotationUtil annotationUtil;

    @Override
    protected List<EPackage> getEPackages() {
        ArrayList ePackages = Lists.newArrayList(super.getEPackages());
        ePackages.add(XAnnotationsPackage.eINSTANCE);
        return ePackages;
    }

    @Check
    public void checkTypeConformance(XAnnotationElementValuePair annotation) throws Exception {
        JvmTypeReference type = this.typeProvider.getType(annotation.getValue());
        JvmTypeReference returnType = annotation.getElement().getReturnType();
        this.checkAnnotationValueConformance(annotation.getValue(), returnType, type);
    }

    protected void checkAnnotationValueConformance(XExpression expression, JvmTypeReference expectedType, JvmTypeReference actualType) {
        JvmTypeReference componentType;
        if (this.conformanceComputer.isConformant(expectedType, actualType)) {
            return;
        }
        if (this.typeReferences.isArray(expectedType) && !this.typeReferences.isArray(actualType) && (expectedType instanceof JvmGenericArrayTypeReference ? this.conformanceComputer.isConformant(componentType = ((JvmGenericArrayTypeReference)expectedType).getComponentType(), actualType) : this.conformanceComputer.isConformant((JvmTypeReference)this.typeReferences.createTypeRef((JvmType)(componentType = ((JvmArrayType)expectedType.getType()).getComponentType()), new JvmTypeReference[0]), actualType))) {
            return;
        }
        this.error("Incompatible types. Expected " + this.getNameOfTypes(expectedType) + " but was " + this.canonicalName(actualType), expression, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_types", new String[0]);
    }

    @Check
    public void checkTypeConformance(XAnnotation annotation) throws Exception {
        if (annotation.getValue() == null) {
            return;
        }
        JvmAnnotationType type = annotation.getAnnotationType();
        JvmOperation value = this.annotationUtil.findSingleValueAttribute(type);
        if (value == null) {
            this.error("The attribute 'value' is undefined for the annotation '" + type.getIdentifier() + "'", annotation.getValue(), null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.no_attribute_value", new String[0]);
        } else {
            JvmTypeReference actualType = this.typeProvider.getType(annotation.getValue());
            this.checkAnnotationValueConformance(annotation.getValue(), value.getReturnType(), actualType);
        }
    }

    @Check
    public void checkAllAttributesConfigured(XAnnotation annotation) {
        JvmAnnotationType annotationType = annotation.getAnnotationType();
        Iterable attributes = annotationType.getDeclaredOperations();
        for (JvmOperation jvmOperation : attributes) {
            XExpression value = this.annotationUtil.findValue(annotation, jvmOperation);
            if (value != null || jvmOperation.getDefaultValue() != null) continue;
            this.error("The annotation must define the attribute '" + jvmOperation.getSimpleName() + "'.", annotation, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.missing_attribute_definition", new String[0]);
        }
    }
}

