/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.containers;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.containers.IAllContainersState;
import org.eclipse.xtext.resource.containers.ResourceSetBasedAllContainersState;
import org.eclipse.xtext.resource.impl.ResourceSetBasedResourceDescriptions;

public class ResourceSetBasedAllContainersStateProvider
implements IAllContainersState.Provider {
    private static final Logger log = Logger.getLogger(ResourceSetBasedAllContainersStateProvider.class);

    public IAllContainersState get(IResourceDescriptions context) {
        if (context instanceof ResourceSetBasedResourceDescriptions) {
            ResourceSetBasedResourceDescriptions resourceDescs = (ResourceSetBasedResourceDescriptions)context;
            ResourceSet resourceSet = resourceDescs.getResourceSet();
            IAllContainersState adapter = (IAllContainersState)EcoreUtil.getAdapter((List)resourceSet.eAdapters(), IAllContainersState.class);
            if (adapter == null) {
                return this.handleAdapterNotFound(resourceSet);
            }
            return adapter;
        }
        throw new IllegalStateException("Passed " + IResourceDescriptions.class.getName() + " not of type " + ResourceSetBasedResourceDescriptions.class.getName());
    }

    protected IAllContainersState handleAdapterNotFound(final ResourceSet resourceSet) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"No explicit container state set. Falling back to default.");
        }
        ResourceSetBasedAllContainersState containersState = new ResourceSetBasedAllContainersState();
        String containerName = "all";
        HashMultimap newHashMultimap = HashMultimap.create();
        newHashMultimap.putAll((Object)containerName, Iterables.transform((Iterable)resourceSet.getResources(), (Function)new Function<Resource, URI>(){

            public URI apply(Resource from) {
                return resourceSet.getURIConverter().normalize(from.getURI());
            }
        }));
        containersState.configure(Collections.singletonList(containerName), (Multimap<String, URI>)newHashMultimap);
        return containersState;
    }
}

