/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.typesystem.IExpressionScope;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionScope;
import org.eclipse.xtext.xbase.typesystem.internal.IFeatureScopeTracker;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedTypes;

public class FeatureScopeTracker
implements IFeatureScopeTracker {
    private final Map<EObject, EnumMap<IExpressionScope.Anchor, ExpressionScope>> featureScopeSessions = Maps.newHashMapWithExpectedSize((int)256);

    @Override
    public IExpressionScope getExpressionScope(EObject context, IExpressionScope.Anchor anchor) {
        EnumMap<IExpressionScope.Anchor, ExpressionScope> recordedScopes = this.featureScopeSessions.get(context);
        if (recordedScopes == null) {
            return IExpressionScope.NULL;
        }
        ExpressionScope result = recordedScopes.get((Object)anchor);
        if (result == null && anchor == IExpressionScope.Anchor.RECEIVER) {
            result = recordedScopes.get((Object)IExpressionScope.Anchor.AFTER);
        }
        if (result == null) {
            return IExpressionScope.NULL;
        }
        return result.withAnchor(anchor);
    }

    @Override
    public boolean hasExpressionScope(EObject context, IExpressionScope.Anchor anchor) {
        Map recordedScopes = this.featureScopeSessions.get(context);
        return recordedScopes != null && recordedScopes.containsKey((Object)anchor);
    }

    @Override
    public void addExpressionScope(ResolvedTypes current, EObject context, IFeatureScopeSession session, IExpressionScope.Anchor anchor) {
        ExpressionScope scope;
        EnumMap recordedScopes = this.featureScopeSessions.get(context);
        if (recordedScopes == null) {
            recordedScopes = Maps.newEnumMap(IExpressionScope.Anchor.class);
            this.featureScopeSessions.put(context, recordedScopes);
        }
        if ((scope = (ExpressionScope)recordedScopes.get((Object)anchor)) == null) {
            scope = new ExpressionScope(current.getResolver().getFeatureScopes(), context, anchor, current.getReferenceOwner());
            recordedScopes.put(anchor, scope);
        }
        scope.addData(session, current.withFlattenedReassignedTypes());
    }

    @Override
    public void replacePreviousExpressionScope(EObject context, IFeatureScopeSession session, IExpressionScope.Anchor anchor) {
        EnumMap<IExpressionScope.Anchor, ExpressionScope> recordedScopes = this.featureScopeSessions.get(context);
        if (recordedScopes == null) {
            throw new IllegalStateException("Cannot replace scope that was never recorded");
        }
        ExpressionScope scope = recordedScopes.get((Object)anchor);
        if (scope == null) {
            throw new IllegalStateException("Cannot replace scope that was never recorded");
        }
        scope.replacePreviousData(session);
    }
}

