/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.symbol;

import com.google.common.annotations.Beta;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.SymbolTag;
import org.eclipse.xtext.ide.server.DocumentExtensions;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;

@Singleton
@Beta
public class DocumentSymbolMapper {
    @Inject
    private DocumentSymbolNameProvider nameProvider;
    @Inject
    private DocumentSymbolKindProvider kindProvider;
    @Inject
    private DocumentSymbolRangeProvider rangeProvider;
    @Inject
    private DocumentSymbolDetailsProvider detailsProvider;
    @Inject
    private DocumentSymbolDeprecationInfoProvider deprecationInfoProvider;

    public DocumentSymbol toDocumentSymbol(EObject object) {
        Range objectSelectionRange;
        Range objectRange;
        SymbolKind objectKind;
        DocumentSymbol documentSymbol = new DocumentSymbol();
        String objectName = this.nameProvider.getName(object);
        if (objectName != null) {
            documentSymbol.setName(objectName);
        }
        if ((objectKind = this.kindProvider.getSymbolKind(object)) != null) {
            documentSymbol.setKind(objectKind);
        }
        if ((objectRange = this.rangeProvider.getRange(object)) != null) {
            documentSymbol.setRange(objectRange);
        }
        if ((objectSelectionRange = this.rangeProvider.getSelectionRange(object)) != null) {
            documentSymbol.setSelectionRange(objectSelectionRange);
        }
        documentSymbol.setDetail(this.detailsProvider.getDetails(object));
        if (this.deprecationInfoProvider.isDeprecated(object)) {
            documentSymbol.setTags(List.of(SymbolTag.Deprecated));
        }
        documentSymbol.setDeprecated(Boolean.valueOf(this.deprecationInfoProvider.isDeprecated(object)));
        documentSymbol.setChildren(new ArrayList());
        return documentSymbol;
    }

    @Singleton
    @Beta
    public static class DocumentSymbolDeprecationInfoProvider {
        public boolean isDeprecated(EObject object) {
            return false;
        }

        public boolean isDeprecated(IEObjectDescription description) {
            return false;
        }
    }

    @Singleton
    @Beta
    public static class DocumentSymbolDetailsProvider {
        public String getDetails(EObject object) {
            return "";
        }
    }

    @Singleton
    @Beta
    public static class DocumentSymbolKindProvider {
        public SymbolKind getSymbolKind(EObject object) {
            return this.getSymbolKind(object != null ? object.eClass() : null);
        }

        public SymbolKind getSymbolKind(IEObjectDescription description) {
            return this.getSymbolKind(description != null ? description.getEClass() : null);
        }

        protected SymbolKind getSymbolKind(EClass clazz) {
            return SymbolKind.Property;
        }
    }

    @Singleton
    @Beta
    public static class DocumentSymbolNameProvider {
        @Inject
        private IQualifiedNameProvider qualifiedNameProvider;

        public String getName(EObject object) {
            return this.getName(object != null ? this.qualifiedNameProvider.getFullyQualifiedName(object) : null);
        }

        public String getName(IEObjectDescription description) {
            return this.getName(description != null ? description.getName() : null);
        }

        protected String getName(QualifiedName qualifiedName) {
            if (qualifiedName != null) {
                return qualifiedName.toString();
            }
            return null;
        }
    }

    @Singleton
    @Beta
    public static class DocumentSymbolRangeProvider {
        @Inject
        private DocumentExtensions documentExtensions;

        public Range getRange(EObject object) {
            Location newFullLocation = this.documentExtensions.newFullLocation(object);
            if (newFullLocation != null) {
                return newFullLocation.getRange();
            }
            return null;
        }

        public Range getSelectionRange(EObject object) {
            Location newLocation = this.documentExtensions.newLocation(object);
            if (newLocation != null) {
                return newLocation.getRange();
            }
            return null;
        }
    }
}

