/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.validation;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.Arrays;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.junit.Assert;

@Deprecated(forRemoval=true)
public class ValidationTestHelper {
    public List<Issue> validate(EObject model) {
        return this.validate(model.eResource());
    }

    public void assertNoIssues(EObject model) {
        this.assertNoIssues(model.eResource());
    }

    public void assertNoErrors(EObject model) {
        this.assertNoErrors(model.eResource());
    }

    public void assertNoError(EObject model, String issueCode) {
        this.assertNoError(model.eResource(), issueCode, null);
    }

    public void assertNoError(EObject model, String issueCode, String userData) {
        this.assertNoError(model.eResource(), issueCode, userData);
    }

    public void assertNoErrors(EObject model, EClass objectType, String code, String ... messageParts) {
        this.assertNoIssues(model, objectType, code, Severity.ERROR, messageParts);
    }

    public void assertNoErrors(EObject model, String code) {
        this.assertNoIssues(model, EcorePackage.Literals.EOBJECT, code, Severity.ERROR, new String[0]);
    }

    public void assertNoIssues(EObject model, EClass objectType) {
        this.assertNoIssues(model.eResource(), objectType);
    }

    public void assertNoIssue(EObject model, EClass objectType, String issueCode) {
        this.assertNoIssue(model.eResource(), objectType, issueCode);
    }

    public void assertError(EObject model, EClass objectType, String code, int offset, int length, String ... messageParts) {
        this.assertIssue(model, objectType, code, offset, length, Severity.ERROR, messageParts);
    }

    public void assertError(EObject model, EClass objectType, String code, String ... messageParts) {
        this.assertIssue(model, objectType, code, Severity.ERROR, messageParts);
    }

    public void assertIssue(EObject model, EClass objectType, String code, Severity severity, String ... messageParts) {
        this.assertIssue(model, objectType, code, -1, -1, severity, messageParts);
    }

    public void assertIssue(EObject model, EClass objectType, String issueCode, int offset, int length, Severity severity, String ... messageParts) {
        this.assertIssue(model.eResource(), objectType, issueCode, offset, length, severity, messageParts);
    }

    public void assertNoIssues(EObject model, EClass objectType, String code, Severity severity, String ... messageParts) {
        this.assertNoIssues(model, objectType, code, -1, -1, severity, messageParts);
    }

    public void assertNoIssues(EObject model, EClass objectType, String issueCode, int offset, int length, Severity severity, String ... messageParts) {
        this.assertNoIssues(model.eResource(), objectType, issueCode, offset, length, severity, messageParts);
    }

    public void assertWarning(EObject model, EClass objectType, String code, String ... messageParts) {
        this.assertIssue(model, objectType, code, Severity.WARNING, messageParts);
    }

    public void assertNoWarnings(EObject model, EClass objectType, String code, String ... messageParts) {
        this.assertNoIssues(model, objectType, code, Severity.WARNING, messageParts);
    }

    public void assertWarning(EObject model, EClass objectType, String code, int offset, int length, String ... messageParts) {
        this.assertIssue(model, objectType, code, offset, length, Severity.WARNING, messageParts);
    }

    public List<Issue> validate(Resource resource) {
        IResourceValidator validator = ((XtextResource)resource).getResourceServiceProvider().getResourceValidator();
        return validator.validate(resource, CheckMode.ALL, CancelIndicator.NullImpl);
    }

    public void assertNoIssues(Resource resource) {
        List<Issue> validate = this.validate(resource);
        if (!Iterables.isEmpty(validate)) {
            Assert.fail((String)("Expected no issues, but got :" + String.valueOf(this.getIssuesAsString(resource, validate, new StringBuilder()))));
        }
    }

    public void assertNoErrors(Resource resource) {
        List<Issue> validate = this.validate(resource);
        Iterable issues = Iterables.filter(validate, (Predicate)new Predicate<Issue>(){

            public boolean apply(Issue input) {
                return Severity.ERROR == input.getSeverity();
            }
        });
        if (!Iterables.isEmpty((Iterable)issues)) {
            Assert.fail((String)("Expected no errors, but got :" + String.valueOf(this.getIssuesAsString(resource, (Iterable<Issue>)issues, new StringBuilder()))));
        }
    }

    public void assertNoError(Resource resource, String issuecode) {
        this.assertNoError(resource, issuecode, null);
    }

    public void assertNoError(Resource resource, final String issuecode, final String userData) {
        List<Issue> validate = this.validate(resource);
        Iterable issues = Iterables.filter(validate, (Predicate)new Predicate<Issue>(){

            public boolean apply(Issue input) {
                if (issuecode.equals(input.getCode())) {
                    return userData == null || Arrays.contains((Object[])input.getData(), (Object)userData);
                }
                return false;
            }
        });
        if (!Iterables.isEmpty((Iterable)issues)) {
            Assert.fail((String)("Expected no error '" + issuecode + "' but got " + String.valueOf(this.getIssuesAsString(resource, (Iterable<Issue>)issues, new StringBuilder()))));
        }
    }

    public void assertNoErrors(Resource resource, EClass objectType, String code, String ... messageParts) {
        this.assertNoIssues(resource, objectType, code, Severity.ERROR, messageParts);
    }

    public void assertNoErrors(Resource resource, String code) {
        this.assertNoIssues(resource, EcorePackage.Literals.EOBJECT, code, Severity.ERROR, new String[0]);
    }

    public void assertNoIssues(final Resource resource, final EClass objectType) {
        List<Issue> validate = this.validate(resource);
        Iterable issues = Iterables.filter(validate, (Predicate)new Predicate<Issue>(){

            public boolean apply(Issue input) {
                EObject object = resource.getEObject(input.getUriToProblem().fragment());
                return objectType.isInstance((Object)object);
            }
        });
        if (!Iterables.isEmpty((Iterable)issues)) {
            Assert.fail((String)("Expected no error on instances of  '" + objectType.getName() + "' but got " + String.valueOf(this.getIssuesAsString(resource, (Iterable<Issue>)issues, new StringBuilder()))));
        }
    }

    public void assertNoIssue(final Resource resource, final EClass objectType, final String issuecode) {
        List<Issue> validate = this.validate(resource);
        Iterable issues = Iterables.filter(validate, (Predicate)new Predicate<Issue>(){

            public boolean apply(Issue input) {
                EObject object;
                return issuecode.equals(input.getCode()) && objectType.isInstance((Object)(object = resource.getEObject(input.getUriToProblem().fragment())));
            }
        });
        if (!Iterables.isEmpty((Iterable)issues)) {
            Assert.fail((String)("Expected no error '" + issuecode + "' but got " + String.valueOf(this.getIssuesAsString(resource, (Iterable<Issue>)issues, new StringBuilder()))));
        }
    }

    public void assertError(Resource resource, EClass objectType, String code, int offset, int length, String ... messageParts) {
        this.assertIssue(resource, objectType, code, offset, length, Severity.ERROR, messageParts);
    }

    public void assertError(Resource resource, EClass objectType, String code, String ... messageParts) {
        this.assertIssue(resource, objectType, code, Severity.ERROR, messageParts);
    }

    public void assertIssue(Resource resource, EClass objectType, String code, Severity severity, String ... messageParts) {
        this.assertIssue(resource, objectType, code, -1, -1, severity, messageParts);
    }

    public void assertIssue(Resource resource, EClass objectType, String code, int offset, int length, Severity severity, String ... messageParts) {
        List<Issue> allIssues = this.validate(resource);
        Iterable<Issue> validate = this.matchIssues(resource, objectType, code, offset, length, severity, allIssues, messageParts);
        if (Iterables.isEmpty(validate)) {
            StringBuilder message = new StringBuilder("Expected ").append(severity).append(" '").append(code).append("' on ").append(objectType.getName()).append(" at [").append(offset).append(":").append(length).append("] but got\n");
            this.getIssuesAsString(resource, allIssues, message);
            Assert.assertEquals((Object)Joiner.on((char)'\n').join((Object[])messageParts), (Object)message.toString());
            Assert.fail((String)message.toString());
        }
    }

    public void assertNoIssues(Resource resource, EClass objectType, String code, Severity severity, String ... messageParts) {
        this.assertNoIssues(resource, objectType, code, -1, -1, severity, messageParts);
    }

    public void assertNoIssues(Resource resource, EClass objectType, String code, int offset, int length, Severity severity, String ... messageParts) {
        List<Issue> allIssues = this.validate(resource);
        Iterable<Issue> validate = this.matchIssues(resource, objectType, code, offset, length, severity, allIssues, messageParts);
        if (!Iterables.isEmpty(validate)) {
            StringBuilder message = new StringBuilder("Expected no ").append(severity).append(" '").append(code).append("' on ").append(objectType.getName()).append(" but got\n");
            this.getIssuesAsString(resource, allIssues, message);
            Assert.assertEquals((Object)Joiner.on((char)'\n').join((Object[])messageParts), (Object)message.toString());
            Assert.fail((String)message.toString());
        }
    }

    public void assertWarning(Resource resource, EClass objectType, String code, String ... messageParts) {
        this.assertIssue(resource, objectType, code, Severity.WARNING, messageParts);
    }

    public void assertNoWarnings(Resource resource, EClass objectType, String code, String ... messageParts) {
        this.assertNoIssues(resource, objectType, code, Severity.WARNING, messageParts);
    }

    public void assertWarning(Resource resource, EClass objectType, String code, int offset, int length, String ... messageParts) {
        this.assertIssue(resource, objectType, code, offset, length, Severity.WARNING, messageParts);
    }

    protected Iterable<Issue> matchIssues(EObject model, EClass objectType, String code, int offset, int length, Severity severity, List<Issue> validate, String ... messageParts) {
        return this.doMatchIssues(model.eResource(), objectType, code, offset, length, severity, validate, messageParts);
    }

    protected Iterable<Issue> matchIssues(Resource resource, EClass objectType, String code, int offset, int length, Severity severity, List<Issue> validate, String ... messageParts) {
        EList contents = resource.getContents();
        if (contents.size() > 1) {
            return this.matchIssues((EObject)contents.get(0), objectType, code, offset, length, severity, validate, messageParts);
        }
        return this.doMatchIssues(resource, objectType, code, offset, length, severity, validate, messageParts);
    }

    protected Iterable<Issue> doMatchIssues(final Resource resource, final EClass objectType, final String code, final int offset, final int length, final Severity severity, List<Issue> validate, final String ... messageParts) {
        return Iterables.filter(validate, (Predicate)new Predicate<Issue>(){

            public boolean apply(Issue input) {
                EObject object;
                if (Strings.equal((String)input.getCode(), (String)code) && input.getSeverity() == severity && (offset < 0 || offset == input.getOffset()) && (length < 0 || length == input.getLength()) && objectType.isInstance((Object)(object = resource.getResourceSet().getEObject(input.getUriToProblem(), true)))) {
                    String[] stringArray = messageParts;
                    int n = messageParts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String messagePart = stringArray[n2];
                        if (!input.getMessage().toLowerCase().contains(messagePart.toLowerCase())) {
                            return false;
                        }
                        ++n2;
                    }
                    return true;
                }
                return false;
            }
        });
    }

    protected StringBuilder getIssuesAsString(EObject model, Iterable<Issue> issues, StringBuilder result) {
        return this.doGetIssuesAsString(model.eResource(), issues, result);
    }

    protected StringBuilder getIssuesAsString(Resource resource, Iterable<Issue> issues, StringBuilder result) {
        EList contents = resource.getContents();
        if (contents.size() > 1) {
            return this.getIssuesAsString((EObject)contents.get(0), issues, result);
        }
        return this.doGetIssuesAsString(resource, issues, result);
    }

    protected StringBuilder doGetIssuesAsString(Resource resource, Iterable<Issue> issues, StringBuilder result) {
        for (Issue issue : issues) {
            URI uri = issue.getUriToProblem();
            result.append(issue.getSeverity());
            result.append(" (");
            result.append(issue.getCode());
            result.append(") '");
            result.append(issue.getMessage());
            result.append("'");
            if (uri != null) {
                EObject eObject = resource.getResourceSet().getEObject(uri, true);
                result.append(" on ");
                result.append(eObject.eClass().getName());
            }
            result.append(", offset " + String.valueOf(issue.getOffset()) + ", length " + String.valueOf(issue.getLength()));
            result.append("\n");
        }
        return result;
    }
}

