/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.util;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Set;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.util.SuperTypeCollector;
import org.eclipse.xtext.util.Strings;

@Singleton
@Deprecated
public class VisibilityService {
    @Inject
    private SuperTypeCollector superTypeCollector;
    @Inject
    private TypesFactory typesFactory;

    public void setSuperTypeCollector(SuperTypeCollector superTypeCollector) {
        this.superTypeCollector = superTypeCollector;
    }

    public void setTypesFactory(TypesFactory typesFactory) {
        this.typesFactory = typesFactory;
    }

    public boolean isVisible(JvmMember jvmMember, JvmDeclaredType contextType) {
        if (jvmMember.getVisibility() == JvmVisibility.PUBLIC) {
            return true;
        }
        if (contextType == null) {
            return false;
        }
        if (jvmMember.getVisibility() == JvmVisibility.DEFAULT) {
            if (jvmMember instanceof JvmDeclaredType) {
                return Strings.equal((String)((JvmDeclaredType)jvmMember).getPackageName(), (String)contextType.getPackageName());
            }
            JvmDeclaredType declaringType = jvmMember.getDeclaringType();
            if (declaringType != null) {
                return Strings.equal((String)declaringType.getPackageName(), (String)contextType.getPackageName());
            }
            return true;
        }
        if (contextType.equals(jvmMember.getDeclaringType())) {
            return true;
        }
        JvmParameterizedTypeReference typeReference = this.typesFactory.createJvmParameterizedTypeReference();
        typeReference.setType(contextType);
        Set<JvmType> rawTypes = this.superTypeCollector.collectSuperTypesAsRawTypes(typeReference);
        if (rawTypes.contains(jvmMember.getDeclaringType())) {
            return jvmMember.getVisibility() == JvmVisibility.PROTECTED;
        }
        return false;
    }
}

