/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.compiler;

import java.io.CharArrayWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.generator.IFilePostProcessorExtension;
import org.eclipse.xtext.xbase.compiler.output.TraceAwarePostProcessor;
import org.eclipse.xtext.xbase.compiler.output.TreeAppendable;

public class UnicodeAwarePostProcessor
extends TraceAwarePostProcessor
implements IFilePostProcessorExtension {
    public CharSequence postProcess(URI fileURI, CharSequence content, @Nullable Charset targetCharset) {
        if (targetCharset != null && "java".equalsIgnoreCase(fileURI.fileExtension())) {
            final String lineSeparator = this.getWhitespaceInformationProvider().getLineSeparatorInformation(fileURI).getLineSeparator();
            final CharsetEncoder encoder = targetCharset.newEncoder();
            if (content instanceof TreeAppendable) {
                return ((TreeAppendable)content).acceptVisitor(new TreeAppendable.Visitor(){

                    @NonNull
                    protected String visit(@NonNull String string) {
                        return UnicodeAwarePostProcessor.this.replaceLineSeparatorsAndEscapeChars(string, lineSeparator, encoder);
                    }
                });
            }
            String result = this.replaceLineSeparatorsAndEscapeChars(content, lineSeparator, encoder);
            return result;
        }
        return this.postProcess(fileURI, content);
    }

    protected String replaceLineSeparatorsAndEscapeChars(CharSequence content, String newLineSeparator, CharsetEncoder encoder) {
        CharArrayWriter writer = new CharArrayWriter(content.length());
        boolean isLookahead = false;
        boolean changed = false;
        int ignoreNext = 0;
        int i = 0;
        while (i < content.length()) {
            block12: {
                int c;
                block11: {
                    c = content.charAt(i);
                    if (!isLookahead) break block11;
                    isLookahead = false;
                    if (c == ignoreNext) break block12;
                }
                switch (c) {
                    case 10: {
                        changed = true;
                        writer.append(newLineSeparator);
                        isLookahead = true;
                        ignoreNext = 13;
                        break;
                    }
                    case 13: {
                        changed = true;
                        writer.append(newLineSeparator);
                        isLookahead = true;
                        ignoreNext = 10;
                        break;
                    }
                    default: {
                        if (encoder.canEncode((char)c)) {
                            writer.append((char)c);
                            break;
                        }
                        changed = true;
                        writer.append("\\u");
                        String hexString = Integer.toHexString(c);
                        int j = hexString.length();
                        while (j < 4) {
                            writer.append('0');
                            ++j;
                        }
                        writer.append(hexString);
                    }
                }
            }
            ++i;
        }
        if (changed) {
            return writer.toString();
        }
        return content.toString();
    }
}

