/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTraversalData;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.OwnedConverter;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithParameterAndResult;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class DeclaratorTypeArgumentCollector
extends TypeReferenceVisitorWithParameterAndResult<LightweightTraversalData, Boolean> {
    @Override
    protected Boolean doVisitTypeReference(LightweightTypeReference reference, LightweightTraversalData data) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean doVisitCompoundTypeReference(CompoundTypeReference reference, LightweightTraversalData data) {
        boolean result = true;
        for (LightweightTypeReference component : reference.getMultiTypeComponents()) {
            Boolean componentsDone = component.accept(this, data);
            result &= componentsDone != null && componentsDone != false;
        }
        return result;
    }

    @Override
    public Boolean doVisitArrayTypeReference(ArrayTypeReference reference, LightweightTraversalData data) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean doVisitWildcardTypeReference(WildcardTypeReference reference, LightweightTraversalData data) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean doVisitParameterizedTypeReference(ParameterizedTypeReference reference, LightweightTraversalData data) {
        JvmType type = reference.getType();
        if (!type.eIsProxy() && data.getVisited().add(type)) {
            return this.doVisitParameterizedTypeReference(reference, type, data);
        }
        return Boolean.FALSE;
    }

    protected Boolean doVisitParameterizedTypeReference(ParameterizedTypeReference reference, JvmType type, LightweightTraversalData data) {
        block7: {
            OwnedConverter converter;
            ITypeReferenceOwner owner;
            block6: {
                if (reference.isRawType()) {
                    return Boolean.FALSE;
                }
                if (type instanceof JvmTypeParameterDeclarator) {
                    EList typeParameters = ((JvmTypeParameterDeclarator)type).getTypeParameters();
                    List<LightweightTypeReference> typeArguments = reference.getTypeArguments();
                    int size = Math.min(typeArguments.size(), typeParameters.size());
                    int i = 0;
                    while (i < size) {
                        JvmTypeParameter param = (JvmTypeParameter)typeParameters.get(i);
                        LightweightTypeReference argument = typeArguments.get(i);
                        if (param != null && argument != null) {
                            data.getTypeParameterMapping().put(param, new LightweightMergedBoundTypeArgument(argument, VarianceInfo.INVARIANT));
                        }
                        ++i;
                    }
                }
                if (!(type instanceof JvmDeclaredType)) break block6;
                owner = reference.getOwner();
                converter = new OwnedConverter(owner);
                EList superTypes = ((JvmDeclaredType)type).getSuperTypes();
                for (JvmTypeReference superType : superTypes) {
                    LightweightTypeReference lightweightSuperType = converter.toLightweightReference(superType);
                    Boolean recursion = lightweightSuperType.accept(this, data);
                    if (recursion == null || !recursion.booleanValue()) continue;
                    return Boolean.TRUE;
                }
                break block7;
            }
            if (!(type instanceof JvmTypeParameter)) break block7;
            owner = reference.getOwner();
            converter = new OwnedConverter(owner);
            EList constraints = ((JvmTypeParameter)type).getConstraints();
            for (JvmTypeConstraint constraint : constraints) {
                LightweightTypeReference lightweightSuperType;
                Boolean recursion;
                JvmTypeReference constraintReference = constraint.getTypeReference();
                if (constraintReference == null || (recursion = (lightweightSuperType = converter.toLightweightReference(constraintReference)).accept(this, data)) == null || !recursion.booleanValue()) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> getTypeParameterMapping(LightweightTypeReference reference) {
        LightweightTraversalData data = new LightweightTraversalData();
        reference.accept(this, data);
        return data.getTypeParameterMapping();
    }
}

