/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.impl;

import com.google.common.collect.AbstractIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.common.types.access.IMirror;
import org.eclipse.xtext.common.types.access.TypeResource;
import org.eclipse.xtext.common.types.access.impl.IndexedJvmTypeAccess;
import org.eclipse.xtext.common.types.access.impl.PrimitiveMirror;
import org.eclipse.xtext.common.types.access.impl.PrimitiveTypeFactory;

public abstract class AbstractJvmTypeProvider
implements IJvmTypeProvider,
Resource.Factory {
    private final ResourceSet resourceSet;
    private final PrimitiveTypeFactory primitiveTypeFactory;
    private final IndexedJvmTypeAccess indexedJvmTypeAccess;

    protected AbstractJvmTypeProvider(ResourceSet resourceSet, IndexedJvmTypeAccess indexedJvmTypeAccess) {
        if (resourceSet == null) {
            throw new IllegalArgumentException("resourceSet may not be null");
        }
        this.indexedJvmTypeAccess = indexedJvmTypeAccess;
        this.resourceSet = resourceSet;
        this.registerProtocol(resourceSet);
        this.primitiveTypeFactory = new PrimitiveTypeFactory();
    }

    protected void registerProtocol(ResourceSet resourceSet) {
        resourceSet.getResourceFactoryRegistry().getProtocolToFactoryMap().put("java", this);
    }

    public abstract JvmType findTypeByName(String var1);

    protected boolean isBinaryNestedTypeDelimiter(String name, boolean binaryNestedTypeDelimiter) {
        return binaryNestedTypeDelimiter || name.indexOf(36) >= 0 || name.indexOf(46) < 0;
    }

    public abstract JvmType findTypeByName(String var1, boolean var2);

    public TypeResource createResource(URI uri) {
        TypeResource result = this.doCreateResource(uri);
        IMirror createMirror = this.createMirror(uri);
        if (createMirror != null) {
            result.setMirror(createMirror);
        }
        return result;
    }

    protected TypeResource doCreateResource(URI uri) {
        TypeResource result = new TypeResource(uri);
        result.setIndexedJvmTypeAccess(this.indexedJvmTypeAccess);
        return result;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public IMirror createMirror(URI resourceURI) {
        if (resourceURI.hasFragment()) {
            throw new IllegalArgumentException("Cannot create mirror for uri '" + resourceURI.toString() + "'");
        }
        String name = resourceURI.path();
        if ("/Primitives".equals(name)) {
            return new PrimitiveMirror(this.primitiveTypeFactory);
        }
        if (!name.startsWith("/Objects/")) {
            throw new IllegalArgumentException("Invalid resource uri '" + resourceURI.toString() + "'");
        }
        name = name.substring("/Objects/".length());
        return this.createMirrorForFQN(name);
    }

    protected abstract IMirror createMirrorForFQN(String var1);

    protected IndexedJvmTypeAccess getIndexedJvmTypeAccess() {
        return this.indexedJvmTypeAccess;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ClassNameVariants
    extends AbstractIterator<String> {
        private StringBuilder buffer;
        private int index;

        public ClassNameVariants(String initial) {
            this.buffer = new StringBuilder(initial);
            this.index = this.buffer.length();
        }

        protected String computeNext() {
            int newIndex = this.buffer.lastIndexOf(".", this.index);
            if (newIndex == -1) {
                return (String)this.endOfData();
            }
            this.index = newIndex - 1;
            this.buffer.setCharAt(newIndex, '$');
            return this.buffer.toString();
        }
    }
}

