/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.util;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmCompoundTypeReference;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.util.AbstractTypeReferenceVisitorWithParameter;
import org.eclipse.xtext.common.types.util.ITypeArgumentContext;
import org.eclipse.xtext.common.types.util.TypeArgumentContextProvider;

@Deprecated
public class LazyTypeArgumentContext
implements TypeArgumentContextProvider.IInitializableTypeArgumentContext {
    private TypeArgumentContextProvider.Request request;
    private TypeArgumentContextProvider contextProvider;
    private int nextLevel = 0;
    private final List<ITypeArgumentContext> delegates = Lists.newArrayListWithCapacity((int)3);

    public void initialize(TypeArgumentContextProvider.Request request, TypeArgumentContextProvider contextProvider) {
        this.request = request;
        this.contextProvider = contextProvider;
    }

    public boolean isRawTypeContext() {
        for (ITypeArgumentContext delegate : this.delegates) {
            if (!delegate.isRawTypeContext()) continue;
            return true;
        }
        while (this.hasNextLevel()) {
            ITypeArgumentContext delegate;
            delegate = this.computeNext();
            if (delegate == null || !delegate.isRawTypeContext()) continue;
            return true;
        }
        return this.delegates.isEmpty();
    }

    public JvmTypeReference getBoundArgument(JvmTypeParameter parameter) {
        if (parameter == null) {
            return null;
        }
        JvmTypeReference firstCandidate = null;
        for (ITypeArgumentContext delegate : this.delegates) {
            JvmTypeReference candidate = delegate.getBoundArgument(parameter);
            if (this.isResolved(candidate, delegate.isRawTypeContext(), false)) {
                return candidate;
            }
            if (firstCandidate != null || candidate == null) continue;
            firstCandidate = candidate;
        }
        while (this.hasNextLevel()) {
            ITypeArgumentContext delegate;
            delegate = this.computeNext();
            if (delegate == null) continue;
            JvmTypeReference candidate = delegate.getBoundArgument(parameter);
            if (this.isResolved(candidate, delegate.isRawTypeContext(), false) || !this.hasNextLevel()) {
                return candidate;
            }
            if (firstCandidate != null || candidate == null || candidate instanceof JvmParameterizedTypeReference && candidate.getType() == parameter) continue;
            firstCandidate = candidate;
        }
        return firstCandidate;
    }

    public JvmTypeReference getLowerBound(JvmTypeReference reference) {
        JvmTypeReference result = reference;
        if (this.isResolved(result, false)) {
            return result;
        }
        for (ITypeArgumentContext delegate : this.delegates) {
            result = delegate.getLowerBound(result);
            if (!this.isResolved(result, delegate.isRawTypeContext())) continue;
            return result;
        }
        while (this.hasNextLevel()) {
            ITypeArgumentContext delegate;
            delegate = this.computeNext();
            if (delegate == null || !this.isResolved(result = delegate.getLowerBound(result), delegate.isRawTypeContext())) continue;
            return result;
        }
        return result;
    }

    public JvmTypeReference getUpperBound(JvmTypeReference reference, Notifier context) {
        JvmTypeReference result = reference;
        if (this.isResolved(result, false)) {
            return result;
        }
        for (ITypeArgumentContext delegate : this.delegates) {
            result = delegate.getUpperBound(result, context);
            if (!this.isResolved(result, delegate.isRawTypeContext())) continue;
            return result;
        }
        while (this.hasNextLevel()) {
            ITypeArgumentContext delegate;
            delegate = this.computeNext();
            if (delegate == null || !this.isResolved(result = delegate.getUpperBound(result, context), delegate.isRawTypeContext())) continue;
            return result;
        }
        return result;
    }

    public JvmTypeReference resolve(JvmTypeReference reference) {
        JvmTypeReference result = reference;
        if (this.isResolved(result, false)) {
            return result;
        }
        for (ITypeArgumentContext delegate : this.delegates) {
            result = delegate.resolve(result);
            if (!this.isResolved(result, delegate.isRawTypeContext())) continue;
            return result;
        }
        while (this.hasNextLevel()) {
            ITypeArgumentContext delegate;
            delegate = this.computeNext();
            if (delegate == null || !this.isResolved(result = delegate.resolve(result), delegate.isRawTypeContext())) continue;
            return result;
        }
        return result;
    }

    protected boolean hasNextLevel() {
        return this.nextLevel >= 0;
    }

    protected ITypeArgumentContext computeNext() {
        ITypeArgumentContext result = this.doComputeNext();
        if (result != null) {
            this.delegates.add(result);
        }
        return result;
    }

    protected ITypeArgumentContext doComputeNext() {
        JvmFeature feature = null;
        switch (this.nextLevel) {
            case 0: {
                JvmTypeReference receiverType = this.request.getReceiverType();
                if (receiverType != null) {
                    this.nextLevel = 1;
                    return this.contextProvider.getReceiverContext(receiverType);
                }
            }
            case 1: {
                List<JvmTypeReference> explicitTypeArguments;
                feature = this.request.getFeature();
                if (feature instanceof JvmExecutable && (explicitTypeArguments = this.request.getExplicitTypeArgument()) != null && !explicitTypeArguments.isEmpty()) {
                    this.nextLevel = 2;
                    return this.contextProvider.getExplicitArgumentContext((JvmExecutable)feature, explicitTypeArguments);
                }
            }
            case 2: {
                List<JvmTypeReference> argumentTypes;
                if (feature == null) {
                    feature = this.request.getFeature();
                }
                if (feature instanceof JvmExecutable && (argumentTypes = this.request.getArgumentTypes()) != null && !argumentTypes.isEmpty()) {
                    this.nextLevel = 3;
                    return this.contextProvider.getParameterContext((JvmExecutable)feature, argumentTypes);
                }
            }
            case 3: {
                JvmTypeReference expectedType;
                JvmTypeReference declaredType = this.request.getDeclaredType();
                if (declaredType != null && (expectedType = this.request.getExpectedType()) != null) {
                    this.nextLevel = 4;
                    return this.contextProvider.getExpectedTypeContext(declaredType, expectedType);
                }
            }
            case 4: {
                if (feature == null) {
                    feature = this.request.getFeature();
                }
                if (!(feature instanceof JvmExecutable) || !((JvmExecutable)feature).isVarArgs()) break;
                this.nextLevel = -1;
                return this.contextProvider.getDeclaredBoundsContext((JvmExecutable)feature);
            }
        }
        this.nextLevel = -1;
        return null;
    }

    protected boolean isResolved(JvmTypeReference reference, boolean rawType) {
        return this.isResolved(reference, rawType, true);
    }

    protected boolean isResolved(JvmTypeReference reference, boolean rawType, boolean firstWildcardUnresolved) {
        if (reference == null) {
            return true;
        }
        Boolean result = (Boolean)new IsResolvedVisitor(rawType).visit(reference, firstWildcardUnresolved);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class IsResolvedVisitor
    extends AbstractTypeReferenceVisitorWithParameter.InheritanceAware<Boolean, Boolean> {
        private final boolean rawType;

        protected IsResolvedVisitor(boolean rawType) {
            this.rawType = rawType;
        }

        @Override
        public Boolean doVisitTypeReference(JvmTypeReference reference, Boolean wildcardIsUnresolved) {
            return Boolean.TRUE;
        }

        @Override
        protected Boolean handleNullReference(Boolean wildcardIsUnresolved) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean doVisitCompoundTypeReference(JvmCompoundTypeReference reference, Boolean wildcardIsUnresolved) {
            for (JvmTypeReference component : reference.getReferences()) {
                if (((Boolean)this.visit(component, wildcardIsUnresolved)).booleanValue()) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        @Override
        public Boolean doVisitParameterizedTypeReference(JvmParameterizedTypeReference reference, Boolean wildcardIsUnresolved) {
            JvmType type = reference.getType();
            if (type instanceof JvmTypeParameter) {
                JvmTypeParameterDeclarator declarator = ((JvmTypeParameter)type).getDeclarator();
                JvmTypeParameterDeclarator nearestDeclarator = LazyTypeArgumentContext.this.request.getNearestDeclarator();
                if (nearestDeclarator == null) {
                    return Boolean.FALSE;
                }
                if (!EcoreUtil.isAncestor((EObject)nearestDeclarator, (EObject)declarator)) {
                    return Boolean.FALSE;
                }
            }
            if (!this.rawType) {
                if (type instanceof JvmTypeParameterDeclarator) {
                    EList<JvmTypeParameter> typeParameters = ((JvmTypeParameterDeclarator)((Object)type)).getTypeParameters();
                    EList<JvmTypeReference> typeArguments = reference.getArguments();
                    if (typeParameters.size() != typeArguments.size()) {
                        return Boolean.FALSE;
                    }
                }
                for (JvmTypeReference typeArgument : reference.getArguments()) {
                    if (((Boolean)this.visit(typeArgument, Boolean.FALSE)).booleanValue()) continue;
                    return Boolean.FALSE;
                }
            }
            return Boolean.TRUE;
        }

        @Override
        public Boolean doVisitWildcardTypeReference(JvmWildcardTypeReference reference, Boolean wildcardIsUnresolved) {
            if (wildcardIsUnresolved.booleanValue()) {
                return Boolean.FALSE;
            }
            for (JvmTypeConstraint constraint : reference.getConstraints()) {
                if (((Boolean)this.visit(constraint.getTypeReference(), Boolean.FALSE)).booleanValue()) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        @Override
        public Boolean doVisitGenericArrayTypeReference(JvmGenericArrayTypeReference reference, Boolean wildcardIsUnresolved) {
            return (Boolean)this.visit(reference.getComponentType(), wildcardIsUnresolved);
        }
    }
}

