/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.impl;

import com.google.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.GenericSignatureFormatError;
import java.lang.reflect.MalformedParameterizedTypeException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmAnnotationValue;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmLowerBound;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.access.impl.ClassURIHelper;
import org.eclipse.xtext.common.types.access.impl.ITypeFactory;
import org.eclipse.xtext.common.types.impl.JvmTypeConstraintImplCustom;
import org.eclipse.xtext.util.internal.Stopwatches;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeclaredTypeFactory
implements ITypeFactory<Class<?>> {
    private static final Logger log = Logger.getLogger(DeclaredTypeFactory.class);
    private final ClassURIHelper uriHelper;
    private final Stopwatches.StoppedTask createTypeTask = Stopwatches.forTask((String)"DeclaredTypeFactory.createType");
    private final Map<Type, JvmType> typeProxies = new HashMap<Type, JvmType>();
    private final Map<Method, JvmOperation> operationProxies = new HashMap<Method, JvmOperation>();
    private final Map<Class<? extends Annotation>, JvmAnnotationType> annotationProxies = new HashMap<Class<? extends Annotation>, JvmAnnotationType>();
    private static final Object[] EMPTY_ARRAY = new Object[0];

    @Inject
    public DeclaredTypeFactory(ClassURIHelper uriHelper) {
        this.uriHelper = uriHelper;
    }

    public JvmDeclaredType createType(Class<?> clazz) {
        try {
            this.createTypeTask.start();
            if (clazz.isAnonymousClass() || clazz.isSynthetic()) {
                throw new IllegalStateException("Cannot create type for anonymous or synthetic classes");
            }
            if (clazz.isAnnotation()) {
                JvmAnnotationType jvmAnnotationType = this.createAnnotationType(clazz);
                return jvmAnnotationType;
            }
            if (clazz.isEnum()) {
                JvmEnumerationType jvmEnumerationType = this.createEnumerationType(clazz);
                return jvmEnumerationType;
            }
            JvmGenericType result = TypesFactory.eINSTANCE.createJvmGenericType();
            result.setInterface(clazz.isInterface());
            result.setStrictFloatingPoint(Modifier.isStrict(clazz.getModifiers()));
            this.setTypeModifiers(clazz, result);
            this.setVisibility(clazz, result);
            result.internalSetIdentifier(clazz.getName());
            result.setSimpleName(clazz.getSimpleName());
            if (clazz.getDeclaringClass() == null && clazz.getPackage() != null) {
                result.setPackageName(clazz.getPackage().getName());
            }
            this.createNestedTypes(clazz, result);
            this.createMethods(clazz, result);
            this.createConstructors(clazz, result);
            this.createFields(clazz, result);
            this.setSuperTypes(clazz, result);
            try {
                TypeVariable<Class<?>>[] typeParameters = clazz.getTypeParameters();
                if (typeParameters.length != 0) {
                    InternalEList jvmTypeParameters = (InternalEList)result.getTypeParameters();
                    TypeVariable<Class<?>>[] typeVariableArray = typeParameters;
                    int n = typeParameters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TypeVariable<Class<?>> variable = typeVariableArray[n2];
                        jvmTypeParameters.addUnique((Object)this.createTypeParameter(variable, result));
                        ++n2;
                    }
                }
            }
            catch (GenericSignatureFormatError error) {
                this.logSignatureFormatError(clazz);
            }
            catch (MalformedParameterizedTypeException error) {
                this.logSignatureFormatError(clazz);
            }
            this.createAnnotationValues(clazz, result);
            JvmGenericType jvmGenericType = result;
            return jvmGenericType;
        }
        finally {
            this.createTypeTask.stop();
        }
    }

    protected void logSignatureFormatError(Class<?> clazz) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Invalid class file for: " + clazz.getCanonicalName()));
        }
    }

    private void logNoClassDefFoundError(NoClassDefFoundError error, Class<?> clazz, String description) {
        log.error((Object)("Incomplete " + description + " for " + clazz.getCanonicalName() + ": " + error));
        if (log.isDebugEnabled()) {
            log.debug((Object)error.getMessage(), (Throwable)error);
        }
    }

    protected void createAnnotationValues(AnnotatedElement annotated, JvmAnnotationTarget result) {
        Annotation[] declaredAnnotations = annotated.getDeclaredAnnotations();
        if (declaredAnnotations.length != 0) {
            InternalEList annotations = (InternalEList)result.getAnnotations();
            Annotation[] annotationArray = declaredAnnotations;
            int n = declaredAnnotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                annotations.addUnique((Object)this.createAnnotationReference(annotation));
                ++n2;
            }
        }
    }

    protected JvmAnnotationReference createAnnotationReference(Annotation annotation) {
        JvmAnnotationReference annotationReference = TypesFactory.eINSTANCE.createJvmAnnotationReference();
        Class<? extends Annotation> type = annotation.annotationType();
        annotationReference.setAnnotation(this.createAnnotationProxy(type));
        Method[] declaredMethods = type.getDeclaredMethods();
        if (declaredMethods.length > 0) {
            InternalEList values = (InternalEList)annotationReference.getValues();
            Method[] methodArray = declaredMethods;
            int n = declaredMethods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                try {
                    JvmAnnotationValue annotationValue;
                    Object value = method.invoke((Object)annotation, EMPTY_ARRAY);
                    Class<?> returnType = method.getReturnType();
                    if (returnType.isArray()) {
                        annotationValue = this.createArrayAnnotationValue(value, returnType);
                        values.addUnique((Object)annotationValue);
                        annotationValue.setOperation(this.createMethodProxy(method));
                    } else {
                        annotationValue = this.createAnnotationValue(value, returnType);
                        values.addUnique((Object)annotationValue);
                        annotationValue.setOperation(this.createMethodProxy(method));
                    }
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                ++n2;
            }
        }
        return annotationReference;
    }

    protected JvmEnumerationLiteral createEnumLiteralProxy(Enum<?> e) {
        JvmEnumerationLiteral enumLiteralProxy = TypesFactory.eINSTANCE.createJvmEnumerationLiteral();
        InternalEObject internalEObject = (InternalEObject)enumLiteralProxy;
        Class<?> type = e.getDeclaringClass();
        try {
            Field field = type.getDeclaredField(e.name());
            internalEObject.eSetProxyURI(this.uriHelper.getFullURI(field));
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            return null;
        }
        return enumLiteralProxy;
    }

    protected JvmAnnotationValue createArrayAnnotationValue(Object value, Class<?> type) {
        EStructuralFeature.Setting result;
        block5: {
            InternalEList values;
            int length;
            Class<?> componentType;
            block8: {
                block7: {
                    block6: {
                        if (!type.isArray()) {
                            throw new IllegalArgumentException("type is not an array type: " + type.getCanonicalName());
                        }
                        componentType = type.getComponentType();
                        result = this.createAnnotationValue(componentType);
                        length = Array.getLength(value);
                        if (length <= 0) break block5;
                        values = (InternalEList)result;
                        if (!componentType.isPrimitive() && String.class != componentType) break block6;
                        int i = 0;
                        while (i < length) {
                            values.addUnique(Array.get(value, i));
                            ++i;
                        }
                        break block5;
                    }
                    if (componentType != Class.class) break block7;
                    int i = 0;
                    while (i < length) {
                        Class referencedClass = (Class)Array.get(value, i);
                        values.addUnique((Object)this.createTypeReference(referencedClass));
                        ++i;
                    }
                    break block5;
                }
                if (!componentType.isAnnotation()) break block8;
                int i = 0;
                while (i < length) {
                    Annotation nestedAnnotation = (Annotation)Array.get(value, i);
                    values.addUnique((Object)this.createAnnotationReference(nestedAnnotation));
                    ++i;
                }
                break block5;
            }
            if (!componentType.isEnum()) break block5;
            int i = 0;
            while (i < length) {
                Enum e = (Enum)Array.get(value, i);
                values.addUnique((Object)this.createEnumLiteralProxy(e));
                ++i;
            }
        }
        return (JvmAnnotationValue)result.getEObject();
    }

    protected JvmAnnotationValue createAnnotationValue(Object value, Class<?> type) {
        EStructuralFeature.Setting result = this.createAnnotationValue(type);
        InternalEList values = (InternalEList)result;
        if (type.isPrimitive() || String.class == type) {
            values.addUnique(value);
        } else if (type == Class.class) {
            Class referencedClass = (Class)value;
            JvmTypeReference reference = this.createTypeReference(referencedClass);
            values.addUnique((Object)reference);
        } else if (type.isAnnotation()) {
            Annotation nestedAnnotation = (Annotation)value;
            values.addUnique((Object)this.createAnnotationReference(nestedAnnotation));
        } else if (type.isEnum()) {
            Enum e = (Enum)value;
            JvmEnumerationLiteral proxy = this.createEnumLiteralProxy(e);
            values.addUnique((Object)proxy);
        }
        return (JvmAnnotationValue)result.getEObject();
    }

    protected EStructuralFeature.Setting createAnnotationValue(Class<?> type) {
        if (String.class == type) {
            return (EStructuralFeature.Setting)TypesFactory.eINSTANCE.createJvmStringAnnotationValue().getValues();
        }
        if (Class.class == type) {
            return (EStructuralFeature.Setting)TypesFactory.eINSTANCE.createJvmTypeAnnotationValue().getValues();
        }
        if (Boolean.TYPE == type) {
            return (EStructuralFeature.Setting)TypesFactory.eINSTANCE.createJvmBooleanAnnotationValue().getValues();
        }
        if (Integer.TYPE == type) {
            return (EStructuralFeature.Setting)TypesFactory.eINSTANCE.createJvmIntAnnotationValue().getValues();
        }
        if (type.isAnnotation()) {
            return (EStructuralFeature.Setting)TypesFactory.eINSTANCE.createJvmAnnotationAnnotationValue().getValues();
        }
        if (type.isEnum()) {
            return (EStructuralFeature.Setting)TypesFactory.eINSTANCE.createJvmEnumAnnotationValue().getValues();
        }
        if (Long.TYPE == type) {
            return (EStructuralFeature.Setting)TypesFactory.eINSTANCE.createJvmLongAnnotationValue().getValues();
        }
        if (Short.TYPE == type) {
            return (EStructuralFeature.Setting)TypesFactory.eINSTANCE.createJvmShortAnnotationValue().getValues();
        }
        if (Float.TYPE == type) {
            return (EStructuralFeature.Setting)TypesFactory.eINSTANCE.createJvmFloatAnnotationValue().getValues();
        }
        if (Double.TYPE == type) {
            return (EStructuralFeature.Setting)TypesFactory.eINSTANCE.createJvmDoubleAnnotationValue().getValues();
        }
        if (Character.TYPE == type) {
            return (EStructuralFeature.Setting)TypesFactory.eINSTANCE.createJvmCharAnnotationValue().getValues();
        }
        if (Byte.TYPE == type) {
            return (EStructuralFeature.Setting)TypesFactory.eINSTANCE.createJvmByteAnnotationValue().getValues();
        }
        throw new IllegalArgumentException("Unexpected type: " + type.getCanonicalName());
    }

    protected JvmAnnotationType createAnnotationProxy(Class<? extends Annotation> type) {
        JvmAnnotationType proxy = this.annotationProxies.get(type);
        if (proxy == null) {
            proxy = TypesFactory.eINSTANCE.createJvmAnnotationType();
            URI uri = this.uriHelper.getFullURI(type);
            ((InternalEObject)proxy).eSetProxyURI(uri);
            this.annotationProxies.put(type, proxy);
        }
        return proxy;
    }

    protected JvmOperation createMethodProxy(Method method) {
        JvmOperation proxy = this.operationProxies.get(method);
        if (proxy == null) {
            proxy = TypesFactory.eINSTANCE.createJvmOperation();
            URI uri = this.uriHelper.getFullURI(method);
            ((InternalEObject)proxy).eSetProxyURI(uri);
            this.operationProxies.put(method, proxy);
        }
        return proxy;
    }

    protected void setTypeModifiers(Class<?> clazz, JvmDeclaredType result) {
        int modifiers = clazz.getModifiers();
        result.setAbstract(Modifier.isAbstract(modifiers));
        result.setStatic(Modifier.isStatic(modifiers));
        if (!(result instanceof JvmEnumerationType)) {
            result.setFinal(Modifier.isFinal(modifiers));
        }
    }

    protected void createNestedTypes(Class<?> clazz, JvmDeclaredType result) {
        try {
            Class<?>[] declaredClasses = clazz.getDeclaredClasses();
            if (declaredClasses.length != 0) {
                InternalEList members = (InternalEList)result.getMembers();
                Class<?>[] classArray = declaredClasses;
                int n = declaredClasses.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> declaredClass = classArray[n2];
                    if (!declaredClass.isAnonymousClass() && !declaredClass.isSynthetic()) {
                        members.addUnique((Object)this.createType(declaredClass));
                    }
                    ++n2;
                }
            }
        }
        catch (NoClassDefFoundError e) {
            this.logNoClassDefFoundError(e, clazz, "nested types");
        }
    }

    protected JvmAnnotationType createAnnotationType(Class<?> clazz) {
        JvmAnnotationType result = TypesFactory.eINSTANCE.createJvmAnnotationType();
        result.internalSetIdentifier(clazz.getName());
        result.setSimpleName(clazz.getSimpleName());
        if (clazz.getDeclaringClass() == null && clazz.getPackage() != null) {
            result.setPackageName(clazz.getPackage().getName());
        }
        this.setVisibility(clazz, result);
        this.setTypeModifiers(clazz, result);
        this.createNestedTypes(clazz, result);
        this.createMethods(clazz, result);
        this.setSuperTypes(clazz, result);
        this.createAnnotationValues(clazz, result);
        return result;
    }

    protected void setSuperTypes(Class<?> clazz, JvmDeclaredType result) {
        InternalEList superTypes = (InternalEList)result.getSuperTypes();
        Class<?> superclass = null;
        try {
            superclass = clazz.getGenericSuperclass();
        }
        catch (GenericSignatureFormatError error) {
            this.logSignatureFormatError(clazz);
            superclass = clazz.getSuperclass();
        }
        catch (MalformedParameterizedTypeException error) {
            this.logSignatureFormatError(clazz);
            superclass = clazz.getSuperclass();
        }
        if (superclass != null) {
            superTypes.addUnique((Object)this.createTypeReference(superclass));
        }
        Type[] interfaces = null;
        try {
            interfaces = clazz.getGenericInterfaces();
        }
        catch (GenericSignatureFormatError error) {
            this.logSignatureFormatError(clazz);
            interfaces = clazz.getInterfaces();
        }
        catch (MalformedParameterizedTypeException error) {
            this.logSignatureFormatError(clazz);
            interfaces = clazz.getInterfaces();
        }
        Type[] typeArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            superTypes.addUnique((Object)this.createTypeReference(type));
            ++n2;
        }
        if (superTypes.isEmpty() && Object.class != clazz) {
            superTypes.addUnique((Object)this.createTypeReference((Type)((Object)Object.class)));
        }
    }

    protected void createFields(Class<?> clazz, JvmDeclaredType result) {
        try {
            Field[] declaredFields = clazz.getDeclaredFields();
            if (declaredFields.length != 0) {
                InternalEList members = (InternalEList)result.getMembers();
                Field[] fieldArray = declaredFields;
                int n = declaredFields.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray[n2];
                    if (!field.isSynthetic()) {
                        members.addUnique((Object)this.createField(field));
                    }
                    ++n2;
                }
            }
        }
        catch (NoClassDefFoundError e) {
            this.logNoClassDefFoundError(e, clazz, "fields");
        }
    }

    protected void createConstructors(Class<?> clazz, JvmDeclaredType result) {
        try {
            Constructor<?>[] declaredConstructors = clazz.getDeclaredConstructors();
            if (declaredConstructors.length != 0) {
                InternalEList members = (InternalEList)result.getMembers();
                Constructor<?>[] constructorArray = declaredConstructors;
                int n = declaredConstructors.length;
                int n2 = 0;
                while (n2 < n) {
                    Constructor<?> constructor = constructorArray[n2];
                    if (!constructor.isSynthetic()) {
                        members.addUnique((Object)this.createConstructor(constructor));
                    }
                    ++n2;
                }
            }
        }
        catch (NoClassDefFoundError e) {
            this.logNoClassDefFoundError(e, clazz, "constructors");
        }
    }

    protected void createMethods(Class<?> clazz, JvmDeclaredType result) {
        try {
            Method[] declaredMethods = clazz.getDeclaredMethods();
            if (declaredMethods.length != 0) {
                InternalEList members = (InternalEList)result.getMembers();
                Method[] methodArray = declaredMethods;
                int n = declaredMethods.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    if (!method.isSynthetic()) {
                        JvmOperation operation = this.createOperation(method);
                        if (clazz.isAnnotation()) {
                            this.setDefaultValue(operation, method);
                        }
                        members.addUnique((Object)operation);
                    }
                    ++n2;
                }
            }
        }
        catch (NoClassDefFoundError e) {
            this.logNoClassDefFoundError(e, clazz, "methods");
        }
    }

    private void setDefaultValue(JvmOperation operation, Method method) {
        Object defaultValue = method.getDefaultValue();
        if (defaultValue != null) {
            Class<?> returnType = method.getReturnType();
            if (returnType.isArray()) {
                JvmAnnotationValue annotationValue = this.createArrayAnnotationValue(defaultValue, returnType);
                operation.setDefaultValue(annotationValue);
                annotationValue.setOperation(operation);
            } else {
                JvmAnnotationValue annotationValue = this.createAnnotationValue(defaultValue, returnType);
                operation.setDefaultValue(annotationValue);
                annotationValue.setOperation(operation);
            }
        }
    }

    protected JvmEnumerationType createEnumerationType(Class<?> clazz) {
        JvmEnumerationType result = TypesFactory.eINSTANCE.createJvmEnumerationType();
        result.internalSetIdentifier(clazz.getName());
        result.setSimpleName(clazz.getSimpleName());
        if (clazz.getDeclaringClass() == null && clazz.getPackage() != null) {
            result.setPackageName(clazz.getPackage().getName());
        }
        this.setVisibility(clazz, result);
        this.setTypeModifiers(clazz, result);
        this.createNestedTypes(clazz, result);
        this.createMethods(clazz, result);
        this.createFields(clazz, result);
        this.createConstructors(clazz, result);
        this.setSuperTypes(clazz, result);
        this.createAnnotationValues(clazz, result);
        return result;
    }

    protected void setVisibility(Class<?> clazz, JvmMember result) {
        if (Modifier.isPrivate(clazz.getModifiers())) {
            result.setVisibility(JvmVisibility.PRIVATE);
        } else if (Modifier.isProtected(clazz.getModifiers())) {
            result.setVisibility(JvmVisibility.PROTECTED);
        } else if (Modifier.isPublic(clazz.getModifiers())) {
            result.setVisibility(JvmVisibility.PUBLIC);
        }
    }

    protected JvmTypeParameter createTypeParameter(TypeVariable<?> variable, JvmMember container) {
        JvmTypeParameter result = TypesFactory.eINSTANCE.createJvmTypeParameter();
        result.setName(variable.getName());
        Type[] bounds = variable.getBounds();
        if (bounds.length != 0) {
            InternalEList constraints = (InternalEList)result.getConstraints();
            Type[] typeArray = variable.getBounds();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type bound = typeArray[n2];
                JvmUpperBound upperBound = TypesFactory.eINSTANCE.createJvmUpperBound();
                ((JvmTypeConstraintImplCustom)((Object)upperBound)).internalSetTypeReference(this.createTypeReference(bound));
                constraints.addUnique((Object)upperBound);
                ++n2;
            }
        }
        return result;
    }

    protected JvmTypeReference createTypeReference(Type type) {
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            Type componentType = arrayType.getGenericComponentType();
            return this.createArrayTypeReference(componentType);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            JvmParameterizedTypeReference result = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
            result.setType(this.createProxy(parameterizedType.getRawType()));
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            if (actualTypeArguments.length != 0) {
                InternalEList arguments = (InternalEList)result.getArguments();
                Type[] typeArray = actualTypeArguments;
                int n = actualTypeArguments.length;
                int n2 = 0;
                while (n2 < n) {
                    Type actualTypeArgument = typeArray[n2];
                    JvmTypeReference argument = this.createTypeArgument(actualTypeArgument);
                    arguments.addUnique((Object)argument);
                    ++n2;
                }
            }
            return result;
        }
        if (type instanceof Class && ((Class)type).isArray()) {
            Class arrayType = (Class)type;
            Class<?> componentType = arrayType.getComponentType();
            return this.createArrayTypeReference(componentType);
        }
        JvmParameterizedTypeReference result = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
        result.setType(this.createProxy(type));
        return result;
    }

    protected JvmTypeReference createArrayTypeReference(Type componentType) {
        JvmTypeReference componentTypeReference = this.createTypeReference(componentType);
        JvmGenericArrayTypeReference result = TypesFactory.eINSTANCE.createJvmGenericArrayTypeReference();
        result.setComponentType(componentTypeReference);
        return result;
    }

    protected JvmTypeReference createTypeArgument(Type actualTypeArgument) {
        if (actualTypeArgument instanceof WildcardType) {
            Type[] lowerBounds;
            int n;
            WildcardType wildcardType = (WildcardType)actualTypeArgument;
            JvmWildcardTypeReference result = TypesFactory.eINSTANCE.createJvmWildcardTypeReference();
            InternalEList constraints = (InternalEList)result.getConstraints();
            Type[] upperBounds = wildcardType.getUpperBounds();
            if (upperBounds.length != 0) {
                Type[] typeArray = upperBounds;
                n = upperBounds.length;
                int n2 = 0;
                while (n2 < n) {
                    Type boundType = typeArray[n2];
                    JvmUpperBound upperBound = TypesFactory.eINSTANCE.createJvmUpperBound();
                    JvmTypeReference upperBoundType = this.createTypeReference(boundType);
                    ((JvmTypeConstraintImplCustom)((Object)upperBound)).internalSetTypeReference(upperBoundType);
                    constraints.addUnique((Object)upperBound);
                    ++n2;
                }
            }
            if ((lowerBounds = wildcardType.getLowerBounds()).length != 0) {
                Type[] typeArray = lowerBounds;
                int n3 = lowerBounds.length;
                n = 0;
                while (n < n3) {
                    Type boundType = typeArray[n];
                    JvmLowerBound lowerBound = TypesFactory.eINSTANCE.createJvmLowerBound();
                    JvmTypeReference lowerBoundType = this.createTypeReference(boundType);
                    ((JvmTypeConstraintImplCustom)((Object)lowerBound)).internalSetTypeReference(lowerBoundType);
                    constraints.addUnique((Object)lowerBound);
                    ++n;
                }
            }
            return result;
        }
        JvmTypeReference result = this.createTypeReference(actualTypeArgument);
        return result;
    }

    protected JvmType createProxy(Type type) {
        JvmType proxy = this.typeProxies.get(type);
        if (proxy == null) {
            proxy = TypesFactory.eINSTANCE.createJvmVoid();
            URI uri = this.uriHelper.getFullURI(type);
            ((InternalEObject)proxy).eSetProxyURI(uri);
            this.typeProxies.put(type, proxy);
        }
        return proxy;
    }

    protected JvmField createField(Field field) {
        JvmField result = !field.isEnumConstant() ? TypesFactory.eINSTANCE.createJvmField() : TypesFactory.eINSTANCE.createJvmEnumerationLiteral();
        String fieldName = field.getName();
        result.internalSetIdentifier(String.valueOf(field.getDeclaringClass().getName()) + "." + fieldName);
        result.setSimpleName(fieldName);
        int modifiers = field.getModifiers();
        result.setFinal(Modifier.isFinal(modifiers));
        result.setStatic(Modifier.isStatic(modifiers));
        result.setTransient(Modifier.isTransient(modifiers));
        result.setVolatile(Modifier.isVolatile(modifiers));
        this.setVisibility(result, modifiers);
        Class<?> fieldType = null;
        try {
            fieldType = field.getGenericType();
        }
        catch (GenericSignatureFormatError error) {
            this.logSignatureFormatError(field.getDeclaringClass());
            fieldType = field.getType();
        }
        catch (MalformedParameterizedTypeException error) {
            this.logSignatureFormatError(field.getDeclaringClass());
            fieldType = field.getType();
        }
        result.setType(this.createTypeReference(fieldType));
        this.createAnnotationValues(field, result);
        return result;
    }

    protected JvmConstructor createConstructor(Constructor<?> constructor) {
        Type[] exceptionTypes;
        JvmConstructor result = TypesFactory.eINSTANCE.createJvmConstructor();
        Class<?> declaringClass = constructor.getDeclaringClass();
        int offset = 0;
        if (declaringClass.isEnum()) {
            offset = 2;
        } else if (declaringClass.isMemberClass() && !Modifier.isStatic(declaringClass.getModifiers())) {
            offset = 1;
        }
        Type[] genericParameterTypes = null;
        try {
            genericParameterTypes = constructor.getGenericParameterTypes();
        }
        catch (GenericSignatureFormatError error) {
            this.logSignatureFormatError(declaringClass);
            genericParameterTypes = constructor.getParameterTypes();
        }
        catch (MalformedParameterizedTypeException error) {
            this.logSignatureFormatError(declaringClass);
            genericParameterTypes = constructor.getParameterTypes();
        }
        if (offset != 0 && constructor.getParameterTypes().length != genericParameterTypes.length) {
            offset = 0;
        }
        this.enhanceGenericDeclaration(result, constructor);
        this.enhanceExecutable(result, (Member & GenericDeclaration)constructor, declaringClass.getSimpleName(), genericParameterTypes, constructor.getParameterAnnotations(), offset);
        result.setVarArgs(constructor.isVarArgs());
        try {
            exceptionTypes = constructor.getGenericExceptionTypes();
        }
        catch (GenericSignatureFormatError error) {
            this.logSignatureFormatError(declaringClass);
            exceptionTypes = constructor.getExceptionTypes();
        }
        catch (MalformedParameterizedTypeException error) {
            this.logSignatureFormatError(declaringClass);
            exceptionTypes = constructor.getExceptionTypes();
        }
        if (exceptionTypes.length != 0) {
            InternalEList exceptions = (InternalEList)result.getExceptions();
            Type[] typeArray = exceptionTypes;
            int n = exceptionTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Type exceptionType = typeArray[n2];
                exceptions.addUnique((Object)this.createTypeReference(exceptionType));
                ++n2;
            }
        }
        this.createAnnotationValues(constructor, result);
        return result;
    }

    protected void setVisibility(JvmMember result, int modifiers) {
        if (Modifier.isPrivate(modifiers)) {
            result.setVisibility(JvmVisibility.PRIVATE);
        } else if (Modifier.isProtected(modifiers)) {
            result.setVisibility(JvmVisibility.PROTECTED);
        } else if (Modifier.isPublic(modifiers)) {
            result.setVisibility(JvmVisibility.PUBLIC);
        } else {
            result.setVisibility(JvmVisibility.DEFAULT);
        }
    }

    protected <T extends Member & GenericDeclaration> void enhanceExecutable(JvmExecutable result, T member, String simpleName, Type[] parameterTypes, Annotation[][] annotations, int offset) {
        StringBuilder fqName = new StringBuilder(48);
        fqName.append(member.getDeclaringClass().getName());
        fqName.append('.');
        fqName.append(simpleName);
        fqName.append('(');
        InternalEList parameters = (InternalEList)result.getParameters();
        int typeIdx = offset;
        int annotationIdx = annotations.length - parameterTypes.length + offset;
        while (typeIdx < parameterTypes.length) {
            if (typeIdx != offset) {
                fqName.append(',');
            }
            Type parameterType = parameterTypes[typeIdx];
            this.uriHelper.computeTypeName(parameterType, fqName);
            parameters.addUnique((Object)this.createFormalParameter(parameterType, "arg" + (typeIdx - offset), result, member, annotations[annotationIdx]));
            ++typeIdx;
            ++annotationIdx;
        }
        fqName.append(')');
        result.internalSetIdentifier(fqName.toString());
        result.setSimpleName(simpleName);
        this.setVisibility(result, member.getModifiers());
    }

    protected void enhanceGenericDeclaration(JvmExecutable result, GenericDeclaration declaration) {
        TypeVariable<?>[] typeParameters = declaration.getTypeParameters();
        if (typeParameters.length != 0) {
            InternalEList jvmTypeParameters = (InternalEList)result.getTypeParameters();
            TypeVariable<?>[] typeVariableArray = typeParameters;
            int n = typeParameters.length;
            int n2 = 0;
            while (n2 < n) {
                TypeVariable<?> variable = typeVariableArray[n2];
                jvmTypeParameters.addUnique((Object)this.createTypeParameter(variable, result));
                ++n2;
            }
        }
    }

    protected JvmOperation createOperation(Method method) {
        Type[] exceptionTypes;
        JvmOperation result = TypesFactory.eINSTANCE.createJvmOperation();
        Type[] genericParameterTypes = null;
        try {
            genericParameterTypes = method.getGenericParameterTypes();
        }
        catch (GenericSignatureFormatError error) {
            this.logSignatureFormatError(method.getDeclaringClass());
            genericParameterTypes = method.getParameterTypes();
        }
        catch (MalformedParameterizedTypeException error) {
            this.logSignatureFormatError(method.getDeclaringClass());
            genericParameterTypes = method.getParameterTypes();
        }
        this.enhanceGenericDeclaration(result, method);
        this.enhanceExecutable(result, method, method.getName(), genericParameterTypes, method.getParameterAnnotations(), 0);
        result.setVarArgs(method.isVarArgs());
        int modifiers = method.getModifiers();
        result.setAbstract(Modifier.isAbstract(modifiers));
        result.setFinal(Modifier.isFinal(modifiers));
        result.setStatic(Modifier.isStatic(modifiers));
        result.setSynchronized(Modifier.isSynchronized(modifiers));
        result.setStrictFloatingPoint(Modifier.isStrict(modifiers));
        result.setNative(Modifier.isNative(modifiers));
        Class<?> returnType = null;
        try {
            returnType = method.getGenericReturnType();
        }
        catch (GenericSignatureFormatError error) {
            this.logSignatureFormatError(method.getDeclaringClass());
            returnType = method.getReturnType();
        }
        catch (MalformedParameterizedTypeException error) {
            this.logSignatureFormatError(method.getDeclaringClass());
            returnType = method.getReturnType();
        }
        result.setReturnType(this.createTypeReference(returnType));
        try {
            exceptionTypes = method.getGenericExceptionTypes();
        }
        catch (GenericSignatureFormatError error) {
            this.logSignatureFormatError(method.getDeclaringClass());
            exceptionTypes = method.getExceptionTypes();
        }
        catch (MalformedParameterizedTypeException error) {
            this.logSignatureFormatError(method.getDeclaringClass());
            exceptionTypes = method.getExceptionTypes();
        }
        if (exceptionTypes.length != 0) {
            InternalEList exceptions = (InternalEList)result.getExceptions();
            Type[] typeArray = exceptionTypes;
            int n = exceptionTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Type exceptionType = typeArray[n2];
                exceptions.addUnique((Object)this.createTypeReference(exceptionType));
                ++n2;
            }
        }
        this.createAnnotationValues(method, result);
        return result;
    }

    protected JvmFormalParameter createFormalParameter(Type parameterType, String paramName, JvmMember container, GenericDeclaration member, Annotation[] annotations) {
        JvmFormalParameter result = TypesFactory.eINSTANCE.createJvmFormalParameter();
        result.setName(paramName);
        if (this.isLocal(parameterType, member)) {
            result.setParameterType(this.createLocalTypeReference(parameterType, (JvmTypeParameterDeclarator)((Object)container), member));
        } else {
            result.setParameterType(this.createTypeReference(parameterType));
        }
        if (annotations.length != 0) {
            InternalEList annotationsReferences = (InternalEList)result.getAnnotations();
            Annotation[] annotationArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                annotationsReferences.addUnique((Object)this.createAnnotationReference(annotation));
                ++n2;
            }
        }
        return result;
    }

    protected JvmTypeReference createLocalTypeReference(Type type, JvmTypeParameterDeclarator container, GenericDeclaration member) {
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            Type componentType = arrayType.getGenericComponentType();
            return this.createLocalArrayTypeReference(componentType, container, member);
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            JvmParameterizedTypeReference result = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
            int idx = Arrays.asList(member.getTypeParameters()).indexOf(typeVariable);
            result.setType((JvmType)container.getTypeParameters().get(idx));
            return result;
        }
        throw new IllegalArgumentException(type.toString());
    }

    protected JvmTypeReference createLocalArrayTypeReference(Type componentType, JvmTypeParameterDeclarator container, GenericDeclaration member) {
        JvmTypeReference componentTypeReference = this.createLocalTypeReference(componentType, container, member);
        JvmGenericArrayTypeReference result = TypesFactory.eINSTANCE.createJvmGenericArrayTypeReference();
        result.setComponentType(componentTypeReference);
        return result;
    }

    protected boolean isLocal(Type parameterType, GenericDeclaration member) {
        if (parameterType instanceof TypeVariable) {
            return member.equals(((TypeVariable)parameterType).getGenericDeclaration());
        }
        if (parameterType instanceof GenericArrayType) {
            return this.isLocal(((GenericArrayType)parameterType).getGenericComponentType(), member);
        }
        return false;
    }

    protected ClassURIHelper getUriHelper() {
        return this.uriHelper;
    }
}

