/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBasicForLoopExpression;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XCatchClause;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XCollectionLiteral;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XDoWhileExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XForLoopExpression;
import org.eclipse.xtext.xbase.XIfExpression;
import org.eclipse.xtext.xbase.XInstanceOfExpression;
import org.eclipse.xtext.xbase.XListLiteral;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XNullLiteral;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XSetLiteral;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XSynchronizedExpression;
import org.eclipse.xtext.xbase.XThrowExpression;
import org.eclipse.xtext.xbase.XTryCatchFinallyExpression;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XWhileExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationElementValuePair;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsPackage;
import org.eclipse.xtext.xbase.compiler.FeatureCallCompiler;
import org.eclipse.xtext.xbase.compiler.GeneratorConfig;
import org.eclipse.xtext.xbase.compiler.JavaVersion;
import org.eclipse.xtext.xbase.compiler.Later;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.featurecalls.IdentifiableSimpleNameProvider;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.FeatureLinkHelper;
import org.eclipse.xtext.xbase.typesystem.override.BottomResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.OverrideTester;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.DeclaratorTypeArgumentCollector;
import org.eclipse.xtext.xbase.typesystem.util.StandardTypeParameterSubstitutor;
import org.eclipse.xtext.xbase.util.XSwitchExpressions;

public class XbaseCompiler
extends FeatureCallCompiler {
    @Inject
    private XSwitchExpressions switchExpressions;
    @Inject
    private FeatureLinkHelper featureLinkHelper;
    @Inject
    private OverrideTester overrideTester;

    protected void _toJavaStatement(XListLiteral literal, ITreeAppendable b, boolean isReferenced) {
        for (XExpression element : literal.getElements()) {
            this.internalToJavaStatement(element, b, true);
        }
    }

    protected void _toJavaStatement(XSetLiteral literal, ITreeAppendable b, boolean isReferenced) {
        for (XExpression element : literal.getElements()) {
            this.internalToJavaStatement(element, b, true);
        }
    }

    protected boolean isType(XExpression element, Class<?> clazz) {
        return this.resolveType(element, clazz) != null;
    }

    protected LightweightTypeReference resolveType(XExpression element, Class<?> clazz) {
        LightweightTypeReference elementType = this.batchTypeResolver.resolveTypes(element).getActualType(element);
        return elementType != null && elementType.isType(clazz) ? elementType : null;
    }

    protected LightweightTypeReference getCollectionElementType(XCollectionLiteral literal) {
        LightweightTypeReference type = this.getLightweightType(literal);
        if (type == null) {
            throw new IllegalStateException();
        }
        if (type.isArray()) {
            LightweightTypeReference result = type.getComponentType();
            if (result == null) {
                throw new IllegalStateException();
            }
            return result;
        }
        if (type.isSubtypeOf(Collection.class) && type.hasTypeArguments()) {
            return type.getTypeArguments().get(0).getInvariantBoundSubstitute();
        }
        JvmType objectType = this.findKnownTopLevelType(Object.class, (Notifier)literal);
        if (objectType == null) {
            return type.getOwner().newUnknownTypeReference("Object");
        }
        return type.getOwner().newParameterizedTypeReference(objectType);
    }

    protected void _toJavaExpression(XListLiteral literal, ITreeAppendable b) {
        LightweightTypeReference literalType = this.batchTypeResolver.resolveTypes(literal).getActualType(literal);
        if (literalType == null) {
            b.append("error - couldn't compute type for literal : " + literal);
            return;
        }
        if (literalType.isArray()) {
            LightweightTypeReference expectedType = this.batchTypeResolver.resolveTypes(literal).getExpectedType(literal);
            boolean skipTypeName = false;
            if (expectedType != null && expectedType.isArray() && this.canUseArrayInitializer(literal, b)) {
                skipTypeName = true;
            }
            if (!skipTypeName) {
                b.append("new ").append(literalType.getType()).append(" ");
            }
            if (literal.getElements().isEmpty()) {
                b.append("{}");
            } else {
                b.append("{ ");
                boolean isFirst = true;
                for (XExpression element : literal.getElements()) {
                    if (!isFirst) {
                        b.append(", ");
                    }
                    isFirst = false;
                    this.internalToJavaExpression(element, b);
                }
                b.append(" }");
            }
            return;
        }
        this.appendImmutableCollectionExpression(literal, b, "unmodifiableList", CollectionLiterals.class, "newArrayList");
    }

    protected void _toJavaExpression(XSetLiteral literal, ITreeAppendable b) {
        LightweightTypeReference literalType = this.batchTypeResolver.resolveTypes(literal).getActualType(literal);
        if (literalType == null) {
            b.append("error - couldn't compute type for literal : " + literal);
            return;
        }
        if (literalType.isType(Map.class)) {
            LightweightTypeReference keyType = literalType.getTypeArguments().get(0);
            LightweightTypeReference valueType = literalType.getTypeArguments().get(1);
            b.append(Collections.class).append(".<").append(keyType).append(", ").append(valueType).append(">unmodifiableMap(");
            b.append(CollectionLiterals.class).append(".<").append(keyType).append(", ").append(valueType).append(">newHashMap(");
            Iterator elements = literal.getElements().iterator();
            while (elements.hasNext()) {
                XExpression element = (XExpression)elements.next();
                this.internalToJavaExpression(element, b);
                if (!elements.hasNext()) continue;
                b.append(", ");
            }
            b.append("))");
        } else {
            this.appendImmutableCollectionExpression(literal, b, "unmodifiableSet", CollectionLiterals.class, "newHashSet");
        }
    }

    protected void appendImmutableCollectionExpression(XCollectionLiteral literal, ITreeAppendable b, String collectionsMethod, Class<?> guavaHelper, String guavaHelperMethod) {
        LightweightTypeReference collectionElementType = this.getCollectionElementType(literal);
        b.append(Collections.class);
        b.append(".<").append(collectionElementType).append(">").append(collectionsMethod).append("(");
        b.append(guavaHelper).append(".<").append(collectionElementType).append(">").append(guavaHelperMethod).append("(");
        boolean isFirst = true;
        for (XExpression element : literal.getElements()) {
            if (!isFirst) {
                b.append(", ");
            }
            isFirst = false;
            if (element instanceof XNullLiteral) {
                b.append("(").append(collectionElementType).append(")");
            }
            this.internalToJavaExpression(element, b);
        }
        b.append("))");
    }

    protected boolean canUseArrayInitializer(XListLiteral literal, ITreeAppendable appendable) {
        if (literal.eContainingFeature() == XbasePackage.Literals.XVARIABLE_DECLARATION__RIGHT || literal.eContainingFeature() == XAnnotationsPackage.Literals.XANNOTATION_ELEMENT_VALUE_PAIR__VALUE || literal.eContainingFeature() == XAnnotationsPackage.Literals.XANNOTATION__VALUE) {
            return this.canUseArrayInitializerImpl(literal, appendable);
        }
        return false;
    }

    protected boolean canUseArrayInitializerImpl(XListLiteral literal, ITreeAppendable appendable) {
        for (XExpression element : literal.getElements()) {
            if (!this.isVariableDeclarationRequired(element, appendable)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected List<XExpression> getActualArguments(XAbstractFeatureCall featureCall) {
        EList<XExpression> actualArguments = featureCall.getActualArguments();
        List<XExpression> normalizedArguments = this.normalizeBlockExpression((Collection<XExpression>)actualArguments);
        return normalizedArguments;
    }

    @Override
    protected ITreeAppendable appendTypeArguments(XAbstractFeatureCall call, ITreeAppendable original) {
        if (!call.getTypeArguments().isEmpty()) {
            return super.appendTypeArguments(call, original);
        }
        ILocationData completeLocationData = this.getLocationWithTypeArguments(call);
        ITreeAppendable completeFeatureCallAppendable = completeLocationData != null ? original.trace(completeLocationData) : original;
        IResolvedTypes resolvedTypes = this.batchTypeResolver.resolveTypes(call);
        List<LightweightTypeReference> typeArguments = resolvedTypes.getActualTypeArguments(call);
        if (!typeArguments.isEmpty()) {
            for (LightweightTypeReference typeArgument : typeArguments) {
                if (!typeArgument.isWildcard()) continue;
                return completeFeatureCallAppendable;
            }
            completeFeatureCallAppendable.append("<");
            int i = 0;
            while (i < typeArguments.size()) {
                if (i != 0) {
                    completeFeatureCallAppendable.append(", ");
                }
                completeFeatureCallAppendable.append(typeArguments.get(i));
                ++i;
            }
            completeFeatureCallAppendable.append(">");
        }
        return completeFeatureCallAppendable;
    }

    @Override
    protected void internalToConvertedExpression(XExpression obj, ITreeAppendable appendable) {
        if (obj instanceof XBlockExpression) {
            this._toJavaExpression((XBlockExpression)obj, appendable);
        } else if (obj instanceof XCastedExpression) {
            this._toJavaExpression((XCastedExpression)obj, appendable);
        } else if (obj instanceof XClosure) {
            this._toJavaExpression((XClosure)obj, appendable);
        } else if (obj instanceof XAnnotation) {
            this._toJavaExpression((XAnnotation)obj, appendable);
        } else if (obj instanceof XConstructorCall) {
            this._toJavaExpression((XConstructorCall)obj, appendable);
        } else if (obj instanceof XIfExpression) {
            this._toJavaExpression((XIfExpression)obj, appendable);
        } else if (obj instanceof XInstanceOfExpression) {
            this._toJavaExpression((XInstanceOfExpression)obj, appendable);
        } else if (obj instanceof XSwitchExpression) {
            this._toJavaExpression((XSwitchExpression)obj, appendable);
        } else if (obj instanceof XTryCatchFinallyExpression) {
            this._toJavaExpression((XTryCatchFinallyExpression)obj, appendable);
        } else if (obj instanceof XListLiteral) {
            this._toJavaExpression((XListLiteral)obj, appendable);
        } else if (obj instanceof XSetLiteral) {
            this._toJavaExpression((XSetLiteral)obj, appendable);
        } else if (obj instanceof XSynchronizedExpression) {
            this._toJavaExpression((XSynchronizedExpression)obj, appendable);
        } else {
            super.internalToConvertedExpression(obj, appendable);
        }
    }

    @Override
    protected void doInternalToJavaStatement(XExpression obj, ITreeAppendable appendable, boolean isReferenced) {
        if (obj instanceof XBlockExpression) {
            this._toJavaStatement((XBlockExpression)obj, appendable, isReferenced);
        } else if (obj instanceof XCastedExpression) {
            this._toJavaStatement((XCastedExpression)obj, appendable, isReferenced);
        } else if (obj instanceof XClosure) {
            this._toJavaStatement((XClosure)obj, appendable, isReferenced);
        } else if (obj instanceof XConstructorCall) {
            this._toJavaStatement((XConstructorCall)obj, appendable, isReferenced);
        } else if (obj instanceof XDoWhileExpression) {
            this._toJavaStatement((XDoWhileExpression)obj, appendable, isReferenced);
        } else if (obj instanceof XForLoopExpression) {
            this._toJavaStatement((XForLoopExpression)obj, appendable, isReferenced);
        } else if (obj instanceof XBasicForLoopExpression) {
            this._toJavaStatement((XBasicForLoopExpression)obj, appendable, isReferenced);
        } else if (obj instanceof XIfExpression) {
            this._toJavaStatement((XIfExpression)obj, appendable, isReferenced);
        } else if (obj instanceof XInstanceOfExpression) {
            this._toJavaStatement((XInstanceOfExpression)obj, appendable, isReferenced);
        } else if (obj instanceof XReturnExpression) {
            this._toJavaStatement((XReturnExpression)obj, appendable, isReferenced);
        } else if (obj instanceof XSwitchExpression) {
            this._toJavaStatement((XSwitchExpression)obj, appendable, isReferenced);
        } else if (obj instanceof XThrowExpression) {
            this._toJavaStatement((XThrowExpression)obj, appendable, isReferenced);
        } else if (obj instanceof XTryCatchFinallyExpression) {
            this._toJavaStatement((XTryCatchFinallyExpression)obj, appendable, isReferenced);
        } else if (obj instanceof XVariableDeclaration) {
            this._toJavaStatement((XVariableDeclaration)obj, appendable, isReferenced);
        } else if (obj instanceof XWhileExpression) {
            this._toJavaStatement((XWhileExpression)obj, appendable, isReferenced);
        } else if (obj instanceof XListLiteral) {
            this._toJavaStatement((XListLiteral)obj, appendable, isReferenced);
        } else if (obj instanceof XSetLiteral) {
            this._toJavaStatement((XSetLiteral)obj, appendable, isReferenced);
        } else if (obj instanceof XSynchronizedExpression) {
            this._toJavaStatement((XSynchronizedExpression)obj, appendable, isReferenced);
        } else {
            super.doInternalToJavaStatement(obj, appendable, isReferenced);
        }
    }

    protected void _toJavaStatement(XBlockExpression expr, ITreeAppendable b, boolean isReferenced) {
        boolean needsBraces;
        b = b.trace(expr, false);
        if (expr.getExpressions().isEmpty()) {
            return;
        }
        if (expr.getExpressions().size() == 1) {
            this.internalToJavaStatement((XExpression)expr.getExpressions().get(0), b, isReferenced);
            return;
        }
        if (isReferenced) {
            this.declareSyntheticVariable(expr, b);
        }
        boolean bl = needsBraces = isReferenced || !this.bracesAreAddedByOuterStructure(expr);
        if (needsBraces) {
            b.newLine().append("{").increaseIndentation();
            b.openPseudoScope();
        }
        EList<XExpression> expressions = expr.getExpressions();
        int i = 0;
        while (i < expressions.size()) {
            XExpression ex = (XExpression)expressions.get(i);
            if (i < expressions.size() - 1) {
                this.internalToJavaStatement(ex, b, false);
            } else {
                this.internalToJavaStatement(ex, b, isReferenced);
                if (isReferenced) {
                    b.newLine().append(this.getVarName(expr, b)).append(" = ");
                    this.internalToConvertedExpression(ex, b, this.getLightweightType(expr));
                    b.append(";");
                }
            }
            ++i;
        }
        if (needsBraces) {
            b.closeScope();
            b.decreaseIndentation().newLine().append("}");
        }
    }

    protected boolean bracesAreAddedByOuterStructure(XExpression expression) {
        XBlockExpression blockExpression;
        EList<XExpression> expressions;
        EObject container = expression.eContainer();
        if (container instanceof XTryCatchFinallyExpression || container instanceof XIfExpression || container instanceof XClosure || container instanceof XSynchronizedExpression) {
            return true;
        }
        if (container instanceof XBlockExpression && (expressions = (blockExpression = (XBlockExpression)container).getExpressions()).size() == 1 && expressions.get(0) == expression) {
            return this.bracesAreAddedByOuterStructure(blockExpression);
        }
        return !(container instanceof XExpression);
    }

    protected void _toJavaExpression(XBlockExpression expr, ITreeAppendable b) {
        if (expr.getExpressions().isEmpty()) {
            b.append("null");
            return;
        }
        if (expr.getExpressions().size() == 1) {
            this.internalToConvertedExpression((XExpression)expr.getExpressions().get(0), b, null);
            return;
        }
        b = b.trace(expr, false);
        b.append(this.getVarName(expr, b));
    }

    protected void _toJavaStatement(XTryCatchFinallyExpression expr, ITreeAppendable outerAppendable, boolean isReferenced) {
        ITreeAppendable b = outerAppendable.trace(expr, false);
        if (isReferenced && !this.isPrimitiveVoid(expr)) {
            this.declareSyntheticVariable(expr, b);
        }
        b.newLine().append("try {").increaseIndentation();
        boolean canBeReferenced = isReferenced && !this.isPrimitiveVoid(expr.getExpression());
        this.internalToJavaStatement(expr.getExpression(), b, canBeReferenced);
        if (canBeReferenced) {
            b.newLine().append(this.getVarName(expr, b)).append(" = ");
            this.internalToConvertedExpression(expr.getExpression(), b, this.getLightweightType(expr));
            b.append(";");
        }
        b.decreaseIndentation().newLine().append("}");
        this.appendCatchAndFinally(expr, b, isReferenced);
    }

    protected void appendCatchAndFinally(XTryCatchFinallyExpression expr, ITreeAppendable b, boolean isReferenced) {
        XExpression finallyExp;
        EList<XCatchClause> catchClauses = expr.getCatchClauses();
        if (!catchClauses.isEmpty()) {
            String variable = b.declareSyntheticVariable(Tuples.pair((Object)expr, (Object)"_catchedThrowable"), "_t");
            b.append(" catch (final Throwable ").append(variable).append(") ");
            b.append("{").increaseIndentation();
            b.newLine();
            Iterator iterator = catchClauses.iterator();
            while (iterator.hasNext()) {
                XCatchClause catchClause = (XCatchClause)iterator.next();
                ITreeAppendable catchClauseAppendable = b.trace(catchClause);
                this.appendCatchClause(catchClause, isReferenced, variable, catchClauseAppendable);
                if (!iterator.hasNext()) continue;
                b.append(" else ");
            }
            b.append(" else {");
            b.increaseIndentation();
            JvmType sneakyThrowType = this.findKnownTopLevelType(Exceptions.class, (Notifier)expr);
            if (sneakyThrowType == null) {
                b.append("COMPILE ERROR : '" + Exceptions.class.getCanonicalName() + "' could not be found on the classpath!");
            } else {
                b.newLine().append("throw ");
                b.append(sneakyThrowType);
                b.append(".sneakyThrow(");
                b.append(variable);
                b.append(");");
            }
            b.decreaseIndentation();
            b.newLine().append("}");
            b.decreaseIndentation();
            b.newLine().append("}");
        }
        if ((finallyExp = expr.getFinallyExpression()) != null) {
            b.append(" finally {").increaseIndentation();
            this.internalToJavaStatement(finallyExp, b, false);
            b.decreaseIndentation().newLine().append("}");
        }
    }

    protected void appendCatchClause(XCatchClause catchClause, boolean parentIsReferenced, String parentVariable, ITreeAppendable appendable) {
        JvmTypeReference type = catchClause.getDeclaredParam().getParameterType();
        String declaredParamName = this.makeJavaIdentifier(catchClause.getDeclaredParam().getName());
        String name = appendable.declareVariable(catchClause.getDeclaredParam(), declaredParamName);
        appendable.append("if (").append(parentVariable).append(" instanceof ");
        this.serialize(type, catchClause, appendable);
        appendable.append(") ").append("{");
        appendable.increaseIndentation();
        ITreeAppendable withDebugging = appendable.trace(catchClause, true);
        ITreeAppendable parameterAppendable = withDebugging.trace((EObject)catchClause.getDeclaredParam());
        this.appendCatchClauseParameter(catchClause, type, name, parameterAppendable.newLine());
        withDebugging.append(" = (");
        this.serialize(type, catchClause, withDebugging);
        withDebugging.append(")").append(parentVariable).append(";");
        boolean canBeReferenced = parentIsReferenced && !this.isPrimitiveVoid(catchClause.getExpression());
        this.internalToJavaStatement(catchClause.getExpression(), withDebugging, canBeReferenced);
        if (canBeReferenced) {
            appendable.newLine().append(this.getVarName(catchClause.eContainer(), appendable)).append(" = ");
            this.internalToConvertedExpression(catchClause.getExpression(), appendable, this.getLightweightType((XExpression)catchClause.eContainer()));
            appendable.append(";");
        }
        appendable.decreaseIndentation();
        appendable.newLine().append("}");
    }

    protected void appendCatchClauseParameter(XCatchClause catchClause, JvmTypeReference parameterType, String parameterName, ITreeAppendable appendable) {
        appendable.append("final ");
        this.serialize(parameterType, catchClause, appendable);
        appendable.append(" ");
        appendable.trace((EObject)catchClause.getDeclaredParam(), (EStructuralFeature)TypesPackage.Literals.JVM_FORMAL_PARAMETER__NAME, 0).append(parameterName);
    }

    protected void _toJavaExpression(XTryCatchFinallyExpression expr, ITreeAppendable b) {
        b.trace(expr, false).append(this.getVarName(expr, b));
    }

    protected void _toJavaStatement(XThrowExpression expr, ITreeAppendable b, boolean isReferenced) {
        this.internalToJavaStatement(expr.getExpression(), b, true);
        b.newLine().append("throw ");
        this.internalToJavaExpression(expr.getExpression(), b);
        b.append(";");
    }

    protected void _toJavaExpression(XInstanceOfExpression expr, ITreeAppendable b) {
        b.append("(");
        this.internalToJavaExpression(expr.getExpression(), b);
        b.append(" instanceof ");
        this.serialize(expr.getType(), expr, b);
        b.append(")");
    }

    protected void _toJavaStatement(XInstanceOfExpression expr, ITreeAppendable b, boolean isReferenced) {
        this.internalToJavaStatement(expr.getExpression(), b, true);
    }

    protected void _toJavaStatement(XVariableDeclaration varDeclaration, ITreeAppendable b, boolean isReferenced) {
        if (varDeclaration.getRight() != null) {
            this.internalToJavaStatement(varDeclaration.getRight(), b, true);
        }
        b.newLine();
        LightweightTypeReference type = this.appendVariableTypeAndName(varDeclaration, b);
        b.append(" = ");
        if (varDeclaration.getRight() != null) {
            this.internalToConvertedExpression(varDeclaration.getRight(), b, type);
        } else {
            this.appendDefaultLiteral(b, type);
        }
        b.append(";");
    }

    protected LightweightTypeReference appendVariableTypeAndName(XVariableDeclaration varDeclaration, ITreeAppendable appendable) {
        if (!varDeclaration.isWriteable()) {
            appendable.append("final ");
        }
        LightweightTypeReference type = null;
        if (varDeclaration.getType() != null) {
            this.serialize(varDeclaration.getType(), varDeclaration, appendable);
            type = this.getLightweightType(varDeclaration);
        } else {
            type = this.getLightweightType(varDeclaration.getRight());
            if (type.isAny()) {
                type = this.getTypeForVariableDeclaration(varDeclaration.getRight());
            }
            appendable.append(type);
        }
        appendable.append(" ");
        appendable.append(appendable.declareVariable(varDeclaration, this.makeJavaIdentifier(varDeclaration.getName())));
        return type;
    }

    protected void _toJavaStatement(XWhileExpression expr, ITreeAppendable b, boolean isReferenced) {
        boolean needsStatement = !this.canCompileToJavaExpression(expr.getPredicate(), b);
        String varName = null;
        if (needsStatement) {
            this.internalToJavaStatement(expr.getPredicate(), b, true);
            varName = b.declareSyntheticVariable(expr, "_while");
            b.newLine().append("boolean ").append(varName).append(" = ");
            this.internalToJavaExpression(expr.getPredicate(), b);
            b.append(";");
        }
        b.newLine().append("while (");
        if (needsStatement) {
            b.append(varName);
        } else {
            this.internalToJavaExpression(expr.getPredicate(), b);
        }
        b.append(") {").increaseIndentation();
        b.openPseudoScope();
        this.internalToJavaStatement(expr.getBody(), b, false);
        if (needsStatement && !this.isEarlyExit(expr.getBody())) {
            this.internalToJavaStatement(expr.getPredicate(), b, true);
            b.newLine();
            b.append(varName).append(" = ");
            this.internalToJavaExpression(expr.getPredicate(), b);
            b.append(";");
        }
        b.closeScope();
        b.decreaseIndentation().newLine().append("}");
    }

    protected void _toJavaStatement(XDoWhileExpression expr, ITreeAppendable b, boolean isReferenced) {
        boolean needsStatement = !this.canCompileToJavaExpression(expr.getPredicate(), b);
        String variable = null;
        if (needsStatement) {
            variable = b.declareSyntheticVariable(expr, "_dowhile");
            b.newLine().append("boolean ").append(variable).append(" = false;");
        }
        b.newLine().append("do {").increaseIndentation();
        this.internalToJavaStatement(expr.getBody(), b, false);
        if (needsStatement && !this.isEarlyExit(expr.getBody())) {
            this.internalToJavaStatement(expr.getPredicate(), b, true);
            b.newLine();
            b.append(variable).append(" = ");
            this.internalToJavaExpression(expr.getPredicate(), b);
            b.append(";");
        }
        b.decreaseIndentation().newLine().append("} while(");
        if (needsStatement) {
            b.append(variable);
        } else {
            this.internalToJavaExpression(expr.getPredicate(), b);
        }
        b.append(");");
    }

    protected void _toJavaStatement(XBasicForLoopExpression expr, ITreeAppendable b, boolean isReferenced) {
        if (this.canCompileToJavaBasicForStatement(expr, b)) {
            this.toJavaBasicForStatement(expr, b, isReferenced);
        } else {
            this.toJavaWhileStatement(expr, b, isReferenced);
        }
    }

    protected boolean canCompileToJavaBasicForStatement(XBasicForLoopExpression expr, ITreeAppendable b) {
        XExpression predicate;
        EList<XExpression> initExpressions = expr.getInitExpressions();
        XExpression firstInitExpression = (XExpression)IterableExtensions.head(initExpressions);
        if (initExpressions.size() == 1 && firstInitExpression instanceof XVariableDeclaration) {
            XVariableDeclaration variableDeclaration = (XVariableDeclaration)firstInitExpression;
            XExpression right = variableDeclaration.getRight();
            if (right != null && !this.canCompileToJavaExpression(right, b)) {
                return false;
            }
        } else {
            for (XExpression expression : initExpressions) {
                if (this.canCompileToJavaExpression(expression, b)) continue;
                return false;
            }
        }
        if ((predicate = expr.getExpression()) != null && !this.canCompileToJavaExpression(predicate, b)) {
            return false;
        }
        for (XExpression expression : expr.getUpdateExpressions()) {
            if (this.canCompileToJavaExpression(expression, b)) continue;
            return false;
        }
        return true;
    }

    protected void toJavaBasicForStatement(XBasicForLoopExpression expr, ITreeAppendable b, boolean isReferenced) {
        ITreeAppendable loopAppendable = b.trace(expr);
        loopAppendable.openPseudoScope();
        loopAppendable.newLine().append("for (");
        EList<XExpression> initExpressions = expr.getInitExpressions();
        XExpression firstInitExpression = (XExpression)IterableExtensions.head(initExpressions);
        if (firstInitExpression instanceof XVariableDeclaration) {
            XVariableDeclaration variableDeclaration = (XVariableDeclaration)firstInitExpression;
            LightweightTypeReference type = this.appendVariableTypeAndName(variableDeclaration, loopAppendable);
            loopAppendable.append(" = ");
            if (variableDeclaration.getRight() != null) {
                this.compileAsJavaExpression(variableDeclaration.getRight(), loopAppendable, type);
            } else {
                this.appendDefaultLiteral(loopAppendable, type);
            }
        } else {
            int i = 0;
            while (i < initExpressions.size()) {
                if (i != 0) {
                    loopAppendable.append(", ");
                }
                XExpression initExpression = (XExpression)initExpressions.get(i);
                this.compileAsJavaExpression(initExpression, loopAppendable, this.getLightweightType(initExpression));
                ++i;
            }
        }
        loopAppendable.append(";");
        XExpression expression = expr.getExpression();
        if (expression != null) {
            loopAppendable.append(" ");
            this.internalToJavaExpression(expression, loopAppendable);
        }
        loopAppendable.append(";");
        EList<XExpression> updateExpressions = expr.getUpdateExpressions();
        int i = 0;
        while (i < updateExpressions.size()) {
            if (i != 0) {
                loopAppendable.append(",");
            }
            loopAppendable.append(" ");
            XExpression updateExpression = (XExpression)updateExpressions.get(i);
            this.internalToJavaExpression(updateExpression, loopAppendable);
            ++i;
        }
        loopAppendable.append(") {").increaseIndentation();
        XExpression eachExpression = expr.getEachExpression();
        this.internalToJavaStatement(eachExpression, loopAppendable, false);
        loopAppendable.decreaseIndentation().newLine().append("}");
        loopAppendable.closeScope();
    }

    protected void toJavaWhileStatement(XBasicForLoopExpression expr, ITreeAppendable b, boolean isReferenced) {
        boolean needBraces;
        ITreeAppendable loopAppendable = b.trace(expr);
        boolean bl = needBraces = !this.bracesAreAddedByOuterStructure(expr);
        if (needBraces) {
            loopAppendable.newLine().increaseIndentation().append("{");
            loopAppendable.openPseudoScope();
        }
        EList<XExpression> initExpressions = expr.getInitExpressions();
        int i = 0;
        while (i < initExpressions.size()) {
            XExpression initExpression = (XExpression)initExpressions.get(i);
            if (i < initExpressions.size() - 1) {
                this.internalToJavaStatement(initExpression, loopAppendable, false);
            } else {
                this.internalToJavaStatement(initExpression, loopAppendable, isReferenced);
                if (isReferenced) {
                    loopAppendable.newLine().append(this.getVarName(expr, loopAppendable)).append(" = (");
                    this.internalToConvertedExpression(initExpression, loopAppendable, this.getLightweightType(expr));
                    loopAppendable.append(");");
                }
            }
            ++i;
        }
        String varName = loopAppendable.declareSyntheticVariable(expr, "_while");
        XExpression expression = expr.getExpression();
        if (expression != null) {
            this.internalToJavaStatement(expression, loopAppendable, true);
            loopAppendable.newLine().append("boolean ").append(varName).append(" = ");
            this.internalToJavaExpression(expression, loopAppendable);
            loopAppendable.append(";");
        } else {
            loopAppendable.newLine().append("boolean ").append(varName).append(" = true;");
        }
        loopAppendable.newLine();
        loopAppendable.append("while (");
        loopAppendable.append(varName);
        loopAppendable.append(") {").increaseIndentation();
        loopAppendable.openPseudoScope();
        XExpression eachExpression = expr.getEachExpression();
        this.internalToJavaStatement(eachExpression, loopAppendable, false);
        EList<XExpression> updateExpressions = expr.getUpdateExpressions();
        if (!updateExpressions.isEmpty()) {
            for (XExpression updateExpression : updateExpressions) {
                this.internalToJavaStatement(updateExpression, loopAppendable, false);
            }
        }
        if (!this.isEarlyExit(eachExpression)) {
            if (expression != null) {
                this.internalToJavaStatement(expression, loopAppendable, true);
                loopAppendable.newLine().append(varName).append(" = ");
                this.internalToJavaExpression(expression, loopAppendable);
                loopAppendable.append(";");
            } else {
                loopAppendable.newLine().append(varName).append(" = true;");
            }
        }
        loopAppendable.closeScope();
        loopAppendable.decreaseIndentation().newLine().append("}");
        if (needBraces) {
            loopAppendable.closeScope();
            loopAppendable.decreaseIndentation().newLine().append("}");
        }
    }

    protected void _toJavaStatement(XForLoopExpression expr, ITreeAppendable b, boolean isReferenced) {
        this.internalToJavaStatement(expr.getForExpression(), b, true);
        b.newLine();
        ITreeAppendable loopAppendable = b.trace(expr);
        loopAppendable.append("for (");
        ITreeAppendable parameterAppendable = loopAppendable.trace((EObject)expr.getDeclaredParam());
        this.appendForLoopParameter(expr, parameterAppendable);
        loopAppendable.append(" : ");
        this.internalToJavaExpression(expr.getForExpression(), loopAppendable);
        loopAppendable.append(") {").increaseIndentation();
        this.internalToJavaStatement(expr.getEachExpression(), loopAppendable, false);
        loopAppendable.decreaseIndentation().newLine().append("}");
    }

    protected void appendForLoopParameter(XForLoopExpression expr, ITreeAppendable appendable) {
        appendable.append("final ");
        JvmTypeReference paramType = this.getForLoopParameterType(expr);
        this.serialize(paramType, expr, appendable);
        appendable.append(" ");
        String name = this.makeJavaIdentifier(expr.getDeclaredParam().getName());
        String varName = appendable.declareVariable(expr.getDeclaredParam(), name);
        appendable.trace((EObject)expr.getDeclaredParam(), (EStructuralFeature)TypesPackage.Literals.JVM_FORMAL_PARAMETER__NAME, 0).append(varName);
    }

    protected JvmTypeReference getForLoopParameterType(XForLoopExpression expr) {
        JvmFormalParameter declaredParam = expr.getDeclaredParam();
        return this.getParameterType(declaredParam);
    }

    protected JvmTypeReference getParameterType(JvmFormalParameter declaredParam) {
        JvmTypeReference declaredType = declaredParam.getParameterType();
        if (declaredType != null) {
            return declaredType;
        }
        return this.getType((JvmIdentifiableElement)declaredParam);
    }

    protected void _toJavaStatement(final XConstructorCall expr, ITreeAppendable b, boolean isReferenced) {
        for (XExpression arg : expr.getArguments()) {
            this.prepareExpression(arg, b);
        }
        if (!isReferenced) {
            b.newLine();
            this.constructorCallToJavaExpression(expr, b);
            b.append(";");
        } else if (this.isVariableDeclarationRequired(expr, b)) {
            Later later = new Later(){

                @Override
                public void exec(ITreeAppendable appendable) {
                    XbaseCompiler.this.constructorCallToJavaExpression(expr, appendable);
                }
            };
            this.declareFreshLocalVariable(expr, b, later);
        }
    }

    protected void constructorCallToJavaExpression(XConstructorCall expr, ITreeAppendable b) {
        ILocationData locationWithNewKeyword = this.getLocationWithNewKeyword(expr);
        ITreeAppendable appendableWithNewKeyword = locationWithNewKeyword != null ? b.trace(locationWithNewKeyword) : b;
        appendableWithNewKeyword.append("new ");
        IResolvedTypes resolvedTypes = this.batchTypeResolver.resolveTypes(expr);
        List<LightweightTypeReference> typeArguments = resolvedTypes.getActualTypeArguments(expr);
        JvmConstructor constructor = expr.getConstructor();
        EList constructorTypeParameters = constructor.getTypeParameters();
        boolean hasTypeArguments = !typeArguments.isEmpty() && this.featureLinkHelper.getDeclaredTypeParameters(constructor).size() == typeArguments.size();
        EList<JvmTypeReference> explicitTypeArguments = expr.getTypeArguments();
        List<Object> constructorTypeArguments = Collections.emptyList();
        if (hasTypeArguments) {
            constructorTypeArguments = typeArguments.subList(0, constructorTypeParameters.size());
            hasTypeArguments = !(typeArguments = typeArguments.subList(constructorTypeParameters.size(), typeArguments.size())).isEmpty();
            for (LightweightTypeReference typeArgument : typeArguments) {
                if (!typeArgument.isWildcard()) continue;
                hasTypeArguments = false;
                break;
            }
            for (LightweightTypeReference typeArgument : constructorTypeArguments) {
                if (!typeArgument.isWildcard()) continue;
                constructorTypeArguments = Collections.emptyList();
                break;
            }
        }
        if (!constructorTypeArguments.isEmpty()) {
            appendableWithNewKeyword.append("<");
            int i = 0;
            while (i < constructorTypeArguments.size()) {
                if (i != 0) {
                    appendableWithNewKeyword.append(", ");
                }
                appendableWithNewKeyword.append((LightweightTypeReference)constructorTypeArguments.get(i));
                ++i;
            }
            appendableWithNewKeyword.append(">");
        }
        ITreeAppendable typeAppendable = appendableWithNewKeyword.trace(expr, (EStructuralFeature)XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR, 0);
        this.appendConstructedTypeName(expr, typeAppendable);
        if (hasTypeArguments || expr.isAnonymousClassConstructorCall() && !explicitTypeArguments.isEmpty() && ((JvmGenericType)constructor.getDeclaringType()).isAnonymous()) {
            if (typeArguments.isEmpty()) {
                LightweightTypeReference createdType = resolvedTypes.getActualType(expr);
                typeArguments = createdType.getNamedType().getTypeArguments();
            }
            if (!typeArguments.isEmpty()) {
                typeAppendable.append("<");
                int i = 0;
                while (i < typeArguments.size()) {
                    if (i != 0) {
                        typeAppendable.append(", ");
                    }
                    if (explicitTypeArguments.isEmpty()) {
                        typeAppendable.append(typeArguments.get(i));
                    } else {
                        typeAppendable.trace((EObject)explicitTypeArguments.get(i), false).append(typeArguments.get(i));
                    }
                    ++i;
                }
                typeAppendable.append(">");
            }
        }
        b.append("(");
        this.appendArguments((List<? extends XExpression>)expr.getArguments(), b);
        b.append(")");
    }

    protected void appendConstructedTypeName(XConstructorCall constructorCall, ITreeAppendable typeAppendable) {
        JvmDeclaredType type = constructorCall.getConstructor().getDeclaringType();
        if (type instanceof JvmGenericType && ((JvmGenericType)type).isAnonymous()) {
            typeAppendable.append(((JvmTypeReference)Iterables.getLast((Iterable)type.getSuperTypes())).getType());
        } else {
            typeAppendable.append((JvmType)constructorCall.getConstructor().getDeclaringType());
        }
    }

    protected ILocationData getLocationWithNewKeyword(XConstructorCall call) {
        ICompositeNode startNode = NodeModelUtils.getNode((EObject)call);
        if (startNode != null) {
            ArrayList resultNodes = Lists.newArrayList();
            for (INode child : startNode.getChildren()) {
                if (child.getGrammarElement() instanceof Keyword && "(".equals(child.getText())) break;
                resultNodes.add(child);
            }
            return this.toLocationData(resultNodes);
        }
        return null;
    }

    protected void _toJavaExpression(XConstructorCall expr, ITreeAppendable b) {
        String varName = this.getReferenceName(expr, b);
        if (varName != null) {
            b.trace(expr, false).append(varName);
        } else {
            this.constructorCallToJavaExpression(expr, b);
        }
    }

    protected void _toJavaStatement(XReturnExpression expr, ITreeAppendable b, boolean isReferenced) {
        if (expr.getExpression() != null) {
            this.internalToJavaStatement(expr.getExpression(), b, true);
            b.newLine().append("return ");
            LightweightTypeReference returnTypeToCompile = this.findRealReturnType(expr);
            this.internalToConvertedExpression(expr.getExpression(), b, returnTypeToCompile);
            b.append(";");
        } else {
            b.newLine().append("return;");
        }
    }

    private LightweightTypeReference findRealReturnType(XExpression expression) {
        if (expression == null) {
            return null;
        }
        JvmIdentifiableElement logicalContainer = this.getLogicalContainerProvider().getLogicalContainer(expression);
        if (logicalContainer instanceof JvmOperation) {
            return this.getLightweightType(logicalContainer);
        }
        if (expression instanceof XClosure) {
            IResolvedTypes resolvedTypes = this.batchTypeResolver.resolveTypes(expression);
            LightweightTypeReference type = resolvedTypes.getExpectedType(expression);
            if (type == null) {
                type = resolvedTypes.getActualType(expression);
            }
            if (type == null) {
                return null;
            }
            FunctionTypeReference functionType = type.tryConvertToFunctionTypeReference(false);
            if (functionType != null) {
                return functionType.getReturnType();
            }
            return null;
        }
        XExpression containerExpression = (XExpression)EcoreUtil2.getContainerOfType((EObject)expression.eContainer(), XExpression.class);
        if (containerExpression == null) {
            LightweightTypeReference returnType = this.getLightweightReturnType(expression);
            return returnType;
        }
        return this.findRealReturnType(containerExpression);
    }

    protected void _toJavaExpression(XCastedExpression expr, ITreeAppendable b) {
        b.append("((");
        this.serialize(expr.getType(), expr, b);
        b.append(") ");
        this.internalToConvertedExpression(expr.getTarget(), b, this.getLightweightType(expr));
        b.append(")");
    }

    protected void _toJavaStatement(XCastedExpression expr, ITreeAppendable b, boolean isReferenced) {
        this.internalToJavaStatement(expr.getTarget(), b, isReferenced);
    }

    protected void _toJavaStatement(XIfExpression expr, ITreeAppendable b, boolean isReferenced) {
        if (isReferenced) {
            this.declareSyntheticVariable(expr, b);
        }
        this.internalToJavaStatement(expr.getIf(), b, true);
        b.newLine().append("if (");
        this.internalToJavaExpression(expr.getIf(), b);
        b.append(") {").increaseIndentation();
        boolean canBeReferenced = isReferenced && !this.isPrimitiveVoid(expr.getThen());
        this.internalToJavaStatement(expr.getThen(), b, canBeReferenced);
        if (canBeReferenced) {
            b.newLine();
            b.append(this.getVarName(expr, b));
            b.append(" = ");
            this.internalToConvertedExpression(expr.getThen(), b, this.getLightweightType(expr));
            b.append(";");
        }
        b.decreaseIndentation().newLine().append("}");
        if (expr.getElse() != null) {
            b.append(" else {").increaseIndentation();
            boolean canElseBeReferenced = isReferenced && !this.isPrimitiveVoid(expr.getElse());
            this.internalToJavaStatement(expr.getElse(), b, canElseBeReferenced);
            if (canElseBeReferenced) {
                b.newLine();
                b.append(this.getVarName(expr, b));
                b.append(" = ");
                this.internalToConvertedExpression(expr.getElse(), b, this.getLightweightType(expr));
                b.append(";");
            }
            b.decreaseIndentation().newLine().append("}");
        }
    }

    protected void _toJavaExpression(XIfExpression expr, ITreeAppendable b) {
        b.trace(expr, false).append(this.getVarName(expr, b));
    }

    protected void _toJavaStatement(XSwitchExpression expr, ITreeAppendable b, boolean isReferenced) {
        GeneratorConfig config = b.getGeneratorConfig();
        boolean compileToSwitch = config != null && config.getJavaSourceVersion().isAtLeast(JavaVersion.JAVA7) ? this.isCompiledToJava7Switch(expr) : this.isCompiledToJavaSwitch(expr);
        if (compileToSwitch) {
            this._toJavaSwitchStatement(expr, b, isReferenced);
        } else {
            this._toJavaIfElseStatement(expr, b, isReferenced);
        }
    }

    protected void _toJavaSwitchStatement(XSwitchExpression expr, ITreeAppendable b, boolean isReferenced) {
        ITreeAppendable defaultAppendable;
        ILocationData location;
        LightweightTypeReference switchType = this.batchTypeResolver.resolveTypes(expr).getActualType(expr.getSwitch());
        boolean enumeration = switchType.isSubtypeOf(Enum.class);
        boolean needNullCheck = enumeration || switchType.isWrapper();
        String switchResultName = this.declareSwitchResultVariable(expr, b, isReferenced);
        this.internalToJavaStatement(expr.getSwitch(), b, true);
        String variableName = this.declareLocalVariable(expr, b);
        if (needNullCheck) {
            b.newLine().append("if (").append(variableName).append(" != null) {").increaseIndentation();
        }
        b.newLine().append("switch (").append(variableName).append(") {").increaseIndentation();
        for (XCasePart casePart : expr.getCases()) {
            ITreeAppendable caseAppendable = b.trace(casePart, true);
            caseAppendable.newLine().increaseIndentation().append("case ");
            ITreeAppendable conditionAppendable = caseAppendable.trace(casePart.getCase(), true);
            if (!enumeration) {
                this.internalToJavaExpression(casePart.getCase(), conditionAppendable);
            } else {
                XAbstractFeatureCall featureCall = (XAbstractFeatureCall)casePart.getCase();
                JvmEnumerationLiteral enumerationLiteral = (JvmEnumerationLiteral)featureCall.getFeature();
                conditionAppendable.append(enumerationLiteral.getSimpleName());
            }
            caseAppendable.append(":");
            XExpression then = casePart.getThen();
            if (then != null) {
                this.executeThenPart(expr, switchResultName, then, caseAppendable, isReferenced);
                if (!this.isEarlyExit(then)) {
                    caseAppendable.newLine().append("break;");
                }
            }
            caseAppendable.decreaseIndentation();
        }
        if (expr.getDefault() != null || enumeration) {
            location = this.getLocationOfDefault(expr);
            defaultAppendable = location != null ? b.trace(location) : b;
            defaultAppendable.newLine().increaseIndentation().append("default:");
            if (expr.getDefault() != null) {
                defaultAppendable.openPseudoScope();
                this.executeThenPart(expr, switchResultName, expr.getDefault(), defaultAppendable, isReferenced);
                defaultAppendable.closeScope();
            }
            if (!this.isEarlyExit(expr.getDefault())) {
                defaultAppendable.newLine().append("break;");
            }
            defaultAppendable.decreaseIndentation();
        }
        b.decreaseIndentation().newLine().append("}");
        if (needNullCheck) {
            b.decreaseIndentation().newLine().append("}");
            if (expr.getDefault() != null) {
                b.append(" else {").increaseIndentation();
                location = this.getLocationOfDefault(expr);
                defaultAppendable = location != null ? b.trace(location) : b;
                this.executeThenPart(expr, switchResultName, expr.getDefault(), defaultAppendable, isReferenced);
                b.decreaseIndentation().newLine().append("}");
            }
        }
    }

    protected String declareLocalVariable(XSwitchExpression expr, ITreeAppendable b) {
        String variableName = this.getSwitchLocalVariableName(expr, b);
        if (variableName != null) {
            return variableName;
        }
        String name = this.createSwitchLocalVariableName(expr);
        JvmTypeReference variableType = this.getSwitchLocalVariableType(expr);
        b.newLine().append("final ");
        this.serialize(variableType, expr, b);
        b.append(" ");
        variableName = this.declareAndAppendSwitchSyntheticLocalVariable(expr, name, b);
        b.append(" = ");
        this.internalToJavaExpression(expr.getSwitch(), b);
        b.append(";");
        return variableName;
    }

    protected String getSwitchLocalVariableName(XSwitchExpression expr, ITreeAppendable b) {
        XFeatureCall featureCall;
        JvmIdentifiableElement feature;
        JvmFormalParameter declaredParam = expr.getDeclaredParam();
        if (declaredParam != null) {
            if (b.hasName(declaredParam)) {
                return b.getName(declaredParam);
            }
            return null;
        }
        XExpression switchExpression = expr.getSwitch();
        if (b.hasName(switchExpression)) {
            return b.getName(switchExpression);
        }
        if (switchExpression instanceof XFeatureCall && b.hasName(feature = (featureCall = (XFeatureCall)switchExpression).getFeature())) {
            return b.getName(feature);
        }
        return null;
    }

    protected String declareAndAppendSwitchSyntheticLocalVariable(XSwitchExpression expr, String name, ITreeAppendable b) {
        JvmFormalParameter declaredParam = expr.getDeclaredParam();
        if (declaredParam == null) {
            String declareSyntheticVariable = b.declareSyntheticVariable(expr, name);
            b.append(declareSyntheticVariable);
            return declareSyntheticVariable;
        }
        String declareSyntheticVariable = b.declareSyntheticVariable(declaredParam, name);
        b.trace((EObject)declaredParam, (EStructuralFeature)TypesPackage.Literals.JVM_FORMAL_PARAMETER__NAME, 0).append(declareSyntheticVariable);
        return declareSyntheticVariable;
    }

    protected String createSwitchLocalVariableName(XSwitchExpression expr) {
        String name = this.getSwitchLocalVariableSimpleName(expr);
        if (name != null) {
            return this.makeJavaIdentifier(name);
        }
        return "_switchValue";
    }

    protected String getSwitchLocalVariableSimpleName(XSwitchExpression expr) {
        IdentifiableSimpleNameProvider nameProvider = this.getNameProvider();
        String varName = nameProvider.getSimpleName((JvmIdentifiableElement)expr.getDeclaredParam());
        if (varName != null) {
            return varName;
        }
        XExpression expression = expr.getSwitch();
        if (!(expression instanceof XFeatureCall)) {
            return null;
        }
        XFeatureCall featureCall = (XFeatureCall)expression;
        JvmIdentifiableElement feature = featureCall.getFeature();
        return nameProvider.getSimpleName(feature);
    }

    protected JvmTypeReference getSwitchLocalVariableType(XSwitchExpression expr) {
        JvmFormalParameter declaredParam = expr.getDeclaredParam();
        if (declaredParam == null) {
            return this.getType(expr.getSwitch());
        }
        return this.getParameterType(declaredParam);
    }

    protected String declareSwitchResultVariable(XSwitchExpression expr, ITreeAppendable b, boolean isReferenced) {
        LightweightTypeReference type = this.getTypeForVariableDeclaration(expr);
        String switchResultName = b.declareSyntheticVariable(this.getSwitchExpressionKey(expr), "_switchResult");
        if (isReferenced) {
            b.newLine();
            b.append(type);
            b.append(" ").append(switchResultName).append(" = ");
            b.append(this.getDefaultValueLiteral(expr));
            b.append(";");
        }
        return switchResultName;
    }

    protected void executeThenPart(XSwitchExpression expr, String switchResultName, XExpression then, ITreeAppendable b, boolean isReferenced) {
        boolean canBeReferenced = isReferenced && !this.isPrimitiveVoid(then);
        this.internalToJavaStatement(then, b, canBeReferenced);
        if (canBeReferenced) {
            b.newLine().append(switchResultName).append(" = ");
            this.internalToConvertedExpression(then, b, this.getLightweightType(expr));
            b.append(";");
        }
    }

    protected void _toJavaIfElseStatement(XSwitchExpression expr, ITreeAppendable b, boolean isReferenced) {
        String switchResultName = this.declareSwitchResultVariable(expr, b, isReferenced);
        this.internalToJavaStatement(expr.getSwitch(), b, true);
        String matchedVariable = b.declareSyntheticVariable(Tuples.pair((Object)expr, (Object)"matches"), "_matched");
        String variableName = this.declareLocalVariable(expr, b);
        b.newLine().append("boolean ");
        b.append(matchedVariable).append(" = false;");
        ArrayList fallThroughCases = Lists.newArrayList();
        for (XCasePart casePart : expr.getCases()) {
            XExpression then = casePart.getThen();
            if (then == null) {
                fallThroughCases.add(casePart);
                continue;
            }
            this._toJavaIfStatement(casePart, fallThroughCases, expr, then, b, isReferenced, switchResultName, matchedVariable, variableName);
        }
        XExpression then = expr.getDefault();
        if (then != null) {
            boolean needsMatcherIf;
            ILocationData location;
            if (!fallThroughCases.isEmpty()) {
                XCasePart casePart = (XCasePart)fallThroughCases.remove(fallThroughCases.size() - 1);
                this._toJavaIfStatement(casePart, fallThroughCases, expr, then, b, isReferenced, switchResultName, matchedVariable, variableName);
            }
            ITreeAppendable defaultAppendable = (location = this.getLocationOfDefault(expr)) != null ? b.trace(location) : b;
            boolean bl = needsMatcherIf = isReferenced || !this.allCasesAreExitedEarly(expr);
            if (needsMatcherIf) {
                defaultAppendable.newLine().append("if (!").append(matchedVariable).append(") {");
                defaultAppendable.increaseIndentation();
            }
            this.executeThenPart(expr, switchResultName, then, defaultAppendable, isReferenced);
            if (needsMatcherIf) {
                defaultAppendable.decreaseIndentation();
                defaultAppendable.newLine().append("}");
            }
        }
    }

    protected void _toJavaIfStatement(XCasePart casePart, List<XCasePart> fallThroughCases, XSwitchExpression expr, XExpression then, ITreeAppendable b, boolean isReferenced, String switchResultName, String matchedVariable, String variableName) {
        ITreeAppendable caseAppendable = b;
        if (!fallThroughCases.isEmpty()) {
            boolean first = true;
            Iterator<XCasePart> i = fallThroughCases.iterator();
            while (i.hasNext()) {
                XCasePart fallThroughCase = i.next();
                caseAppendable = this.appendOpenIfStatement(fallThroughCase, caseAppendable, matchedVariable, variableName);
                this.appendCloseIfStatement(fallThroughCase, caseAppendable);
                if (first) {
                    first = false;
                } else {
                    caseAppendable.decreaseIndentation();
                    caseAppendable.newLine().append("}");
                }
                i.remove();
            }
            caseAppendable = this.appendOpenIfStatement(casePart, caseAppendable, matchedVariable, variableName);
            this.appendCloseIfStatement(casePart, caseAppendable);
            if (!first) {
                caseAppendable.decreaseIndentation();
                caseAppendable.newLine().append("}");
            }
            caseAppendable.newLine().append("if (").append(matchedVariable).append(") {").increaseIndentation();
            this.executeThenPart(expr, switchResultName, then, caseAppendable, isReferenced);
            caseAppendable.decreaseIndentation().newLine().append("}");
        } else {
            caseAppendable = this.appendOpenIfStatement(casePart, caseAppendable, matchedVariable, variableName);
            this.executeThenPart(expr, switchResultName, then, caseAppendable, isReferenced);
            this.appendCloseIfStatement(casePart, caseAppendable);
        }
        caseAppendable.decreaseIndentation();
        caseAppendable.newLine().append("}");
    }

    protected ITreeAppendable appendOpenIfStatement(XCasePart casePart, ITreeAppendable b, String matchedVariable, String variableName) {
        ITreeAppendable caseAppendable = b.trace(casePart, true);
        caseAppendable.newLine().append("if (!").append(matchedVariable).append(") {");
        caseAppendable.increaseIndentation();
        if (casePart.getTypeGuard() != null) {
            ITreeAppendable typeGuardAppendable = caseAppendable.trace((EObject)casePart.getTypeGuard(), true);
            typeGuardAppendable.newLine().append("if (");
            typeGuardAppendable.append(variableName);
            typeGuardAppendable.append(" instanceof ");
            typeGuardAppendable.trace((EObject)casePart.getTypeGuard()).append(casePart.getTypeGuard().getType());
            typeGuardAppendable.append(") {");
            typeGuardAppendable.increaseIndentation();
            typeGuardAppendable.openPseudoScope();
        }
        if (casePart.getCase() != null) {
            ITreeAppendable conditionAppendable = caseAppendable.trace(casePart.getCase(), true);
            this.internalToJavaStatement(casePart.getCase(), conditionAppendable, true);
            conditionAppendable.newLine().append("if (");
            LightweightTypeReference convertedType = this.getLightweightType(casePart.getCase());
            if (convertedType.isType(Boolean.TYPE) || convertedType.isType(Boolean.class)) {
                this.internalToJavaExpression(casePart.getCase(), conditionAppendable);
            } else {
                JvmType objectsType = this.findKnownType(Objects.class, (Notifier)casePart);
                if (objectsType != null) {
                    conditionAppendable.append(objectsType);
                    conditionAppendable.append(".equal(").append(variableName).append(", ");
                    this.internalToJavaExpression(casePart.getCase(), conditionAppendable);
                    conditionAppendable.append(")");
                } else {
                    conditionAppendable.append(ObjectExtensions.class);
                    conditionAppendable.append(".operator_equals(").append(variableName).append(", ");
                    this.internalToJavaExpression(casePart.getCase(), conditionAppendable);
                    conditionAppendable.append(")");
                }
            }
            conditionAppendable.append(")");
            caseAppendable.append(" {");
            caseAppendable.increaseIndentation();
        }
        return caseAppendable.newLine().append(matchedVariable).append("=true;");
    }

    protected ITreeAppendable appendCloseIfStatement(XCasePart casePart, ITreeAppendable caseAppendable) {
        if (casePart.getCase() != null) {
            caseAppendable.decreaseIndentation().newLine().append("}");
        }
        if (casePart.getTypeGuard() != null) {
            caseAppendable.decreaseIndentation().newLine().append("}");
            caseAppendable.closeScope();
        }
        return caseAppendable;
    }

    protected boolean isCompiledToJavaSwitch(XSwitchExpression expr) {
        if (!this.switchExpressions.isJavaSwitchExpression(expr)) {
            return false;
        }
        for (XCasePart casePart : expr.getCases()) {
            if (!this.switchExpressions.isJavaCaseExpression(expr, casePart)) {
                return false;
            }
            if (this.switchExpressions.isConstant(casePart)) continue;
            return false;
        }
        return true;
    }

    protected boolean isCompiledToJava7Switch(XSwitchExpression expr) {
        if (!this.switchExpressions.isJava7SwitchExpression(expr)) {
            return false;
        }
        for (XCasePart casePart : expr.getCases()) {
            if (!this.switchExpressions.isJavaCaseExpression(expr, casePart)) {
                return false;
            }
            if (this.switchExpressions.isConstant(casePart)) continue;
            return false;
        }
        return true;
    }

    protected boolean allCasesAreExitedEarly(XSwitchExpression expr) {
        for (XCasePart casePart : expr.getCases()) {
            if (casePart.getThen() == null || this.isEarlyExit(casePart.getThen())) continue;
            return false;
        }
        return true;
    }

    protected boolean isSimpleFeatureCall(XExpression switch1) {
        if (switch1 instanceof XFeatureCall) {
            XFeatureCall featureCall = (XFeatureCall)switch1;
            return !(featureCall.getFeature() instanceof JvmOperation);
        }
        return false;
    }

    protected Object getSwitchExpressionKey(XSwitchExpression expr) {
        return new Pair((Object)expr, (Object)"key");
    }

    @Override
    protected String getReferenceName(XExpression expr, ITreeAppendable b) {
        Object key;
        if (expr instanceof XSwitchExpression && b.hasName(key = this.getSwitchExpressionKey((XSwitchExpression)expr))) {
            return b.getName(key);
        }
        return super.getReferenceName(expr, b);
    }

    protected ILocationData getLocationOfDefault(XSwitchExpression expression) {
        ICompositeNode startNode = NodeModelUtils.getNode((EObject)expression);
        if (startNode != null) {
            ArrayList resultNodes = Lists.newArrayList();
            boolean defaultSeen = false;
            for (INode child : startNode.getChildren()) {
                if (defaultSeen) {
                    resultNodes.add(child);
                    if (GrammarUtil.containingAssignment((EObject)child.getGrammarElement()) == null) continue;
                    break;
                }
                if (!(child.getGrammarElement() instanceof Keyword) || !"default".equals(child.getText())) continue;
                defaultSeen = true;
                resultNodes.add(child);
            }
            return this.toLocationData(resultNodes);
        }
        return null;
    }

    protected void _toJavaExpression(XSwitchExpression expr, ITreeAppendable b) {
        String referenceName = this.getReferenceName(expr, b);
        if (referenceName == null) {
            throw new IllegalStateException("Switch expression wasn't translated to Java statements before.");
        }
        b.trace(expr, false).append(referenceName);
    }

    protected void _toJavaStatement(XSynchronizedExpression synchronizedExpression, ITreeAppendable b, boolean isReferenced) {
        if (isReferenced) {
            this.declareSyntheticVariable(synchronizedExpression, b);
        }
        ITreeAppendable synchronizedAppendable = b.trace(synchronizedExpression, true);
        XExpression param = synchronizedExpression.getParam();
        if (!this.canCompileToJavaExpression(param, b)) {
            this.internalToJavaStatement(param, synchronizedAppendable, isReferenced);
        }
        synchronizedAppendable.newLine().append("synchronized (");
        this.internalToJavaExpression(param, synchronizedAppendable);
        synchronizedAppendable.append(") {").increaseIndentation();
        synchronizedAppendable.openPseudoScope();
        XExpression expression = synchronizedExpression.getExpression();
        this.internalToJavaStatement(expression, b, isReferenced);
        if (isReferenced) {
            b.newLine().append(this.getVarName(synchronizedExpression, synchronizedAppendable)).append(" = ");
            this.internalToConvertedExpression(expression, b, this.getLightweightType(synchronizedExpression));
            b.append(";");
        }
        synchronizedAppendable.closeScope();
        synchronizedAppendable.decreaseIndentation().newLine().append("}");
    }

    protected void _toJavaExpression(XSynchronizedExpression synchronizedExpression, ITreeAppendable b) {
        b.trace(synchronizedExpression, false).append(this.getVarName(synchronizedExpression, b));
    }

    protected void _toJavaStatement(XClosure closure, ITreeAppendable b, boolean isReferenced) {
        if (!isReferenced) {
            throw new IllegalArgumentException("a closure definition does not cause any side-effects");
        }
        LightweightTypeReference type = this.getLightweightType(closure);
        JvmOperation operation = this.findImplementingOperation(type);
        if (operation != null) {
            b.newLine().append("final ");
            b.append(type);
            b.append(" ");
            String variableName = b.declareSyntheticVariable(closure, "_function");
            b.append(variableName).append(" = ");
            GeneratorConfig config = b.getGeneratorConfig();
            if (config != null && config.getJavaSourceVersion().isAtLeast(JavaVersion.JAVA8) && this.canCompileToJavaLambda(closure, type, operation)) {
                this.toLambda(closure, b, type, operation, false);
            } else {
                this.toAnonymousClass(closure, b, type, operation);
            }
            b.append(";");
        }
    }

    protected ITreeAppendable toAnonymousClass(XClosure closure, ITreeAppendable b, LightweightTypeReference type, JvmOperation operation) {
        b.append("new ");
        b.append(type);
        b.append("() {");
        b.increaseIndentation();
        try {
            b.openScope();
            String selfVariable = null;
            if (this.needSyntheticSelfVariable(closure, type)) {
                b.newLine().append("final ");
                b.append(type).append(" ");
                selfVariable = b.declareVariable(type.getType(), "_self");
                b.append(selfVariable);
                b.append(" = this;");
            }
            LightweightTypeReference returnType = this.getClosureOperationReturnType(type, operation);
            this.appendOperationVisibility(b, operation);
            if (!operation.getTypeParameters().isEmpty()) {
                this.appendTypeParameters(b, operation, type);
            }
            b.append(returnType);
            b.append(" ").append(operation.getSimpleName());
            b.append("(");
            EList<JvmFormalParameter> closureParams = closure.getFormalParameters();
            int i = 0;
            while (i < closureParams.size()) {
                JvmFormalParameter closureParam = (JvmFormalParameter)closureParams.get(i);
                LightweightTypeReference parameterType = this.getClosureOperationParameterType(type, operation, i);
                this.appendClosureParameter(closureParam, parameterType, b);
                if (i != closureParams.size() - 1) {
                    b.append(", ");
                }
                ++i;
            }
            b.append(")");
            if (!operation.getExceptions().isEmpty()) {
                b.append(" throws ");
                i = 0;
                while (i < operation.getExceptions().size()) {
                    this.serialize((JvmTypeReference)operation.getExceptions().get(i), closure, b, false, false, false, false);
                    if (i != operation.getExceptions().size() - 1) {
                        b.append(", ");
                    }
                    ++i;
                }
            }
            b.append(" {");
            b.increaseIndentation();
            if (selfVariable == null) {
                this.reassignThisInClosure(b, type.getType());
            } else {
                this.reassignThisInClosure(b, null);
            }
            this.compile(closure.getExpression(), b, returnType, (Set<JvmTypeReference>)Sets.newHashSet((Iterable)operation.getExceptions()));
            b.decreaseIndentation();
            b.newLine().append("}");
        }
        finally {
            b.closeScope();
        }
        return b.decreaseIndentation().newLine().append("}");
    }

    protected boolean needSyntheticSelfVariable(XClosure closure, LightweightTypeReference typeRef) {
        return false;
    }

    private void appendTypeParameters(ITreeAppendable b, JvmOperation operation, LightweightTypeReference instantiatedType) {
        BottomResolvedOperation resolvedOperation = new BottomResolvedOperation(operation, instantiatedType, this.overrideTester);
        List<JvmTypeParameter> typeParameters = resolvedOperation.getResolvedTypeParameters();
        b.append("<");
        int i = 0;
        while (i < typeParameters.size()) {
            if (i != 0) {
                b.append(", ");
            }
            JvmTypeParameter typeParameter = typeParameters.get(i);
            b.append(typeParameter.getName());
            List<LightweightTypeReference> constraints = resolvedOperation.getResolvedTypeParameterConstraints(i);
            if (!constraints.isEmpty()) {
                b.append(" extends ");
                int j = 0;
                while (j < constraints.size()) {
                    if (j != 0) {
                        b.append(" & ");
                    }
                    b.append(constraints.get(j));
                    ++j;
                }
            }
            ++i;
        }
        b.append("> ");
    }

    protected void appendClosureParameter(JvmFormalParameter closureParam, LightweightTypeReference parameterType, ITreeAppendable appendable) {
        appendable.append("final ");
        appendable.append(parameterType);
        appendable.append(" ");
        String proposedParamName = this.makeJavaIdentifier(closureParam.getName());
        String name = appendable.declareVariable(closureParam, proposedParamName);
        appendable.append(name);
    }

    protected void appendOperationVisibility(ITreeAppendable b, JvmOperation operation) {
        b.newLine();
        JvmDeclaredType declaringType = operation.getDeclaringType();
        GeneratorConfig config = b.getGeneratorConfig();
        if (config != null && config.getJavaSourceVersion().isAtLeast(JavaVersion.JAVA6) || declaringType instanceof JvmGenericType && !((JvmGenericType)declaringType).isInterface()) {
            b.append("@").append(Override.class).newLine();
        }
        switch (operation.getVisibility()) {
            case DEFAULT: {
                break;
            }
            case PUBLIC: {
                b.append("public ");
                return;
            }
            case PROTECTED: {
                b.append("protected ");
                return;
            }
            case PRIVATE: {
                b.append("private ");
                return;
            }
        }
    }

    protected LightweightTypeReference getClosureOperationParameterType(LightweightTypeReference closureType, JvmOperation operation, int i) {
        ITypeReferenceOwner owner = this.newTypeReferenceOwner((EObject)operation);
        Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> mapping = new DeclaratorTypeArgumentCollector().getTypeParameterMapping(closureType);
        LightweightTypeReference parameterType = owner.toLightweightTypeReference(((JvmFormalParameter)operation.getParameters().get(i)).getParameterType());
        return new StandardTypeParameterSubstitutor(mapping, owner).substitute(parameterType);
    }

    protected LightweightTypeReference getClosureOperationReturnType(LightweightTypeReference closureType, JvmOperation operation) {
        ITypeReferenceOwner owner = this.newTypeReferenceOwner((EObject)operation);
        Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> mapping = new DeclaratorTypeArgumentCollector().getTypeParameterMapping(closureType);
        LightweightTypeReference parameterType = owner.toLightweightTypeReference(operation.getReturnType());
        return new StandardTypeParameterSubstitutor(mapping, owner).substitute(parameterType);
    }

    protected ITreeAppendable toLambda(XClosure closure, ITreeAppendable b, LightweightTypeReference type, JvmOperation operation, boolean writeExplicitTargetType) {
        if (writeExplicitTargetType) {
            b.append("((");
            b.append(type);
            b.append(") ");
        }
        try {
            b.openPseudoScope();
            b.append("(");
            EList<JvmFormalParameter> closureParams = closure.getFormalParameters();
            int i = 0;
            while (i < closureParams.size()) {
                JvmFormalParameter closureParam = (JvmFormalParameter)closureParams.get(i);
                LightweightTypeReference parameterType = this.getClosureOperationParameterType(type, operation, i);
                b.append(parameterType);
                b.append(" ");
                String proposedParamName = this.makeJavaIdentifier(closureParam.getName());
                String name = b.declareUniqueNameVariable(closureParam, proposedParamName);
                b.append(name);
                if (i != closureParams.size() - 1) {
                    b.append(", ");
                }
                ++i;
            }
            b.append(") -> {");
            b.increaseIndentation();
            LightweightTypeReference returnType = this.getClosureOperationReturnType(type, operation);
            this.compile(closure.getExpression(), b, returnType, (Set<JvmTypeReference>)Sets.newHashSet((Iterable)operation.getExceptions()));
            b.decreaseIndentation();
            b.newLine().append("}");
        }
        finally {
            b.closeScope();
        }
        if (writeExplicitTargetType) {
            b.append(")");
        }
        return b;
    }

    protected void _toJavaExpression(XClosure closure, ITreeAppendable b) {
        if (b.hasName(closure)) {
            b.trace(closure, false).append(this.getVarName(closure, b));
        } else {
            LightweightTypeReference type = this.getLightweightType(closure);
            JvmOperation operation = this.findImplementingOperation(type);
            if (operation != null) {
                GeneratorConfig config = b.getGeneratorConfig();
                if (config != null && config.getJavaSourceVersion().isAtLeast(JavaVersion.JAVA8) && this.canCompileToJavaLambda(closure, type, operation)) {
                    this.toLambda(closure, b.trace(closure, false), type, operation, true);
                } else {
                    this.toAnonymousClass(closure, b.trace(closure, false), type, operation);
                }
            }
        }
    }

    protected boolean canCompileToJavaLambda(XClosure closure, LightweightTypeReference typeRef, JvmOperation operation) {
        if (!typeRef.isInterfaceType()) {
            return false;
        }
        if (!operation.getTypeParameters().isEmpty()) {
            return false;
        }
        TreeIterator iterator = closure.eAllContents();
        JvmType jvmType = typeRef.getType();
        while (iterator.hasNext()) {
            EObject obj = (EObject)iterator.next();
            if (obj instanceof XClosure) {
                iterator.prune();
                continue;
            }
            if (!(obj instanceof XFeatureCall) || !this.isReferenceToSelf((XFeatureCall)obj, jvmType)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean internalCanCompileToJavaExpression(XExpression expression, ITreeAppendable appendable) {
        if (expression instanceof XListLiteral) {
            XListLiteral listLiteral = (XListLiteral)expression;
            for (XExpression element : listLiteral.getElements()) {
                if (this.internalCanCompileToJavaExpression(element, appendable)) continue;
                return false;
            }
            return true;
        }
        if (expression instanceof XSetLiteral) {
            XSetLiteral setLiteral = (XSetLiteral)expression;
            for (XExpression element : setLiteral.getElements()) {
                if (this.internalCanCompileToJavaExpression(element, appendable)) continue;
                return false;
            }
            return true;
        }
        if (expression instanceof XBlockExpression) {
            return false;
        }
        if (expression instanceof XTryCatchFinallyExpression) {
            return false;
        }
        if (expression instanceof XThrowExpression) {
            return false;
        }
        if (expression instanceof XInstanceOfExpression) {
            XInstanceOfExpression instanceOfExpression = (XInstanceOfExpression)expression;
            return this.internalCanCompileToJavaExpression(instanceOfExpression.getExpression(), appendable);
        }
        if (expression instanceof XVariableDeclaration) {
            return false;
        }
        if (expression instanceof XWhileExpression) {
            return false;
        }
        if (expression instanceof XDoWhileExpression) {
            return false;
        }
        if (expression instanceof XBasicForLoopExpression) {
            return false;
        }
        if (expression instanceof XForLoopExpression) {
            return false;
        }
        if (expression instanceof XCastedExpression) {
            XCastedExpression castedExpression = (XCastedExpression)expression;
            return this.internalCanCompileToJavaExpression(castedExpression.getTarget(), appendable);
        }
        if (expression instanceof XReturnExpression) {
            return false;
        }
        if (expression instanceof XIfExpression) {
            return false;
        }
        if (expression instanceof XSwitchExpression) {
            return false;
        }
        if (expression instanceof XSynchronizedExpression) {
            return false;
        }
        return super.internalCanCompileToJavaExpression(expression, appendable);
    }

    @Override
    protected boolean isVariableDeclarationRequired(XExpression expr, ITreeAppendable b) {
        EList<XExpression> siblings;
        XSwitchExpression switchExpression;
        XCasePart casePart;
        XIfExpression ifExpression;
        if (expr instanceof XAnnotation) {
            return false;
        }
        if (expr instanceof XListLiteral) {
            return false;
        }
        if (expr instanceof XSetLiteral) {
            return false;
        }
        if (expr instanceof XCastedExpression) {
            return false;
        }
        if (expr instanceof XInstanceOfExpression) {
            return false;
        }
        if (expr instanceof XMemberFeatureCall && this.isVariableDeclarationRequired((XMemberFeatureCall)expr, b)) {
            return true;
        }
        EObject container = expr.eContainer();
        if (container instanceof XVariableDeclaration || container instanceof XReturnExpression || container instanceof XThrowExpression) {
            return false;
        }
        if (container instanceof XIfExpression && ((ifExpression = (XIfExpression)container).getThen() == expr || ifExpression.getElse() == expr)) {
            return false;
        }
        if (container instanceof XCasePart && (casePart = (XCasePart)container).getThen() == expr) {
            return false;
        }
        if (container instanceof XSwitchExpression && (switchExpression = (XSwitchExpression)container).getDefault() == expr) {
            return false;
        }
        if (container instanceof XBlockExpression && (siblings = ((XBlockExpression)container).getExpressions()).get(siblings.size() - 1) == expr) {
            return false;
        }
        if (container instanceof XClosure && ((XClosure)container).getExpression() == expr) {
            return false;
        }
        return super.isVariableDeclarationRequired(expr, b);
    }

    protected void _toJavaExpression(XAnnotation annotation, ITreeAppendable b) {
        b.append("@");
        b.append(annotation.getAnnotationType());
        XExpression value = annotation.getValue();
        if (value != null) {
            b.append("(");
            this.internalToJavaExpression(value, b);
            b.append(")");
        } else {
            EList<XAnnotationElementValuePair> valuePairs = annotation.getElementValuePairs();
            if (valuePairs.isEmpty()) {
                return;
            }
            b.append("(");
            int i = 0;
            while (i < valuePairs.size()) {
                XAnnotationElementValuePair pair = (XAnnotationElementValuePair)valuePairs.get(i);
                b.append(pair.getElement().getSimpleName());
                b.append(" = ");
                this.internalToJavaExpression(pair.getValue(), b);
                if (i < valuePairs.size() - 1) {
                    b.append(", ");
                }
                ++i;
            }
            b.append(")");
        }
    }
}

