/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.standalone;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipException;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.builder.standalone.ClusteringConfig;
import org.eclipse.xtext.builder.standalone.IIssueHandler;
import org.eclipse.xtext.builder.standalone.LanguageAccess;
import org.eclipse.xtext.builder.standalone.compiler.IJavaCompiler;
import org.eclipse.xtext.common.types.access.impl.ClasspathTypeProvider;
import org.eclipse.xtext.common.types.access.impl.IndexedJvmTypeAccess;
import org.eclipse.xtext.common.types.descriptions.IStubGenerator;
import org.eclipse.xtext.generator.AbstractFileSystemAccess;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IFileSystemAccessExtension3;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.mwe.NameBasedFilter;
import org.eclipse.xtext.mwe.PathTraverser;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.clustering.DisabledClusteringPolicy;
import org.eclipse.xtext.resource.clustering.DynamicResourceClusteringPolicy;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.resource.persistence.IResourceStorageFacade;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.MapExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

public class StandaloneBuilder {
    private static final Logger LOG = Logger.getLogger(StandaloneBuilder.class);
    @Accessors
    private Map<String, LanguageAccess> languages;
    @Accessors
    private String baseDir;
    @Accessors
    private Iterable<String> sourceDirs;
    @Accessors
    private Iterable<String> javaSourceDirs = CollectionLiterals.newArrayList((Object[])new String[0]);
    @Accessors
    private Iterable<String> classPathEntries;
    @Accessors
    private File tempDir = Files.createTempDir();
    @Accessors
    private String encoding;
    @Accessors
    private String classPathLookUpFilter;
    @Accessors
    private boolean failOnValidationError = true;
    @Accessors
    private boolean debugLog;
    @Accessors
    private boolean writeStorageResources;
    @Accessors
    private ClusteringConfig clusteringConfig = null;
    @Inject
    private IndexedJvmTypeAccess jvmTypeAccess;
    @Inject
    private Provider<XtextResourceSet> resourceSetProvider;
    @Inject
    private AbstractFileSystemAccess commonFileAccess;
    @Inject
    protected IIssueHandler issueHandler;
    @Inject
    private IEncodingProvider.Runtime encodingProvider;
    @Inject
    private IJavaCompiler compiler;
    private Map<LanguageAccess, JavaIoFileSystemAccess> configuredFsas = CollectionLiterals.newHashMap((Pair[])new Pair[0]);

    public void setTempDir(String pathAsString) {
        boolean _notEquals;
        boolean bl = _notEquals = !Objects.equal((Object)pathAsString, null);
        if (_notEquals) {
            File _file;
            this.tempDir = _file = new File(pathAsString);
        }
    }

    public boolean launch() {
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        Collection<LanguageAccess> _values = this.languages.values();
        Functions.Function1<LanguageAccess, Boolean> _function = new Functions.Function1<LanguageAccess, Boolean>(){

            public Boolean apply(LanguageAccess it) {
                return it.isLinksAgainstJava();
            }
        };
        boolean needsJava = IterableExtensions.exists(_values, (Functions.Function1)_function);
        boolean _equals = Objects.equal((Object)this.baseDir, null);
        if (_equals) {
            String _property;
            this.baseDir = _property = System.getProperty("user.dir");
            LOG.warn((Object)("Property baseDir not set. Using '" + this.baseDir + "'"));
        }
        if (needsJava) {
            LOG.info((Object)"Using common types.");
        }
        XtextResourceSet resourceSet = (XtextResourceSet)this.resourceSetProvider.get();
        boolean bl = _notEquals = !Objects.equal((Object)this.encoding, null);
        if (_notEquals) {
            this.forceDebugLog("Setting encoding.");
            Collection<LanguageAccess> _values_1 = this.languages.values();
            this.fileEncodingSetup(_values_1, this.encoding);
        }
        LOG.info((Object)"Collecting source models.");
        long startedAt = System.currentTimeMillis();
        Iterable rootsToTravers = this.classPathEntries;
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)this.classPathLookUpFilter, null);
        if (_notEquals_1) {
            Iterable _filter;
            LOG.info((Object)"Class path look up filter is active.");
            final Pattern cpLookUpFilter = Pattern.compile(this.classPathLookUpFilter);
            Functions.Function1<String, Boolean> _function_1 = new Functions.Function1<String, Boolean>(){

                public Boolean apply(String root) {
                    Matcher _matcher = cpLookUpFilter.matcher(root);
                    return _matcher.matches();
                }
            };
            Iterable _converted_rootsToTravers = rootsToTravers = (_filter = IterableExtensions.filter(this.classPathEntries, (Functions.Function1)_function_1));
            int _length = ((Object[])Conversions.unwrapArray((Object)_converted_rootsToTravers, Object.class)).length;
            String _plus = "Investigating " + Integer.valueOf(_length);
            String _plus_1 = String.valueOf(_plus) + " of ";
            int _length_1 = ((Object[])Conversions.unwrapArray(this.classPathEntries, Object.class)).length;
            String _plus_2 = String.valueOf(_plus_1) + Integer.valueOf(_length_1);
            String _plus_3 = String.valueOf(_plus_2) + " class path entries.";
            LOG.info((Object)_plus_3);
        }
        List<URI> sourceResourceURIs = this.collectResources(this.sourceDirs, (ResourceSet)resourceSet);
        List<URI> _collectResources = this.collectResources(rootsToTravers, (ResourceSet)resourceSet);
        Iterable allResourcesURIs = Iterables.concat(sourceResourceURIs, _collectResources);
        long _currentTimeMillis = System.currentTimeMillis();
        long _minus = _currentTimeMillis - startedAt;
        String _plus_4 = "Finished collecting source models. Took: " + Long.valueOf(_minus);
        String _plus_5 = String.valueOf(_plus_4) + " ms.";
        this.forceDebugLog(_plus_5);
        Iterable allClassPathEntries = Iterables.concat(this.sourceDirs, this.classPathEntries);
        if (needsJava) {
            LOG.info((Object)"Installing type provider.");
            this.installTypeProvider(allClassPathEntries, resourceSet, null);
        }
        DisabledClusteringPolicy _xifexpression = null;
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)this.clusteringConfig, null);
        if (_notEquals_2) {
            DynamicResourceClusteringPolicy _xblockexpression = null;
            LOG.info((Object)"Clustering configured.");
            DynamicResourceClusteringPolicy _dynamicResourceClusteringPolicy = new DynamicResourceClusteringPolicy();
            Procedures.Procedure1<DynamicResourceClusteringPolicy> _function_2 = new Procedures.Procedure1<DynamicResourceClusteringPolicy>(){

                public void apply(DynamicResourceClusteringPolicy it) {
                    long _minimumFreeMemory = StandaloneBuilder.this.clusteringConfig.getMinimumFreeMemory();
                    long _multiply = _minimumFreeMemory * 1024L;
                    long _multiply_1 = _multiply * 1024L;
                    it.setMinimumFreeMemory(_multiply_1);
                    int _minimumClusterSize = StandaloneBuilder.this.clusteringConfig.getMinimumClusterSize();
                    it.setMinimumClusterSize(_minimumClusterSize);
                    long _minimumPercentFreeMemory = StandaloneBuilder.this.clusteringConfig.getMinimumPercentFreeMemory();
                    it.setMinimumPercentFreeMemory(_minimumPercentFreeMemory);
                }
            };
            _xblockexpression = (DynamicResourceClusteringPolicy)ObjectExtensions.operator_doubleArrow((Object)_dynamicResourceClusteringPolicy, (Procedures.Procedure1)_function_2);
            _xifexpression = _xblockexpression;
        } else {
            _xifexpression = new DisabledClusteringPolicy();
        }
        DisabledClusteringPolicy strategy = _xifexpression;
        ArrayList _newArrayList = CollectionLiterals.newArrayList((Object[])new IResourceDescription[0]);
        ResourceDescriptionsData index = new ResourceDescriptionsData((Iterable)_newArrayList);
        Iterator allResourceIterator = allResourcesURIs.iterator();
        while (allResourceIterator.hasNext()) {
            ArrayList resources = CollectionLiterals.newArrayList((Object[])new Resource[0]);
            int clusterIndex = 0;
            boolean continue_ = true;
            while (allResourceIterator.hasNext() && continue_) {
                boolean _not;
                URI uri = (URI)allResourceIterator.next();
                Resource resource = resourceSet.getResource(uri, true);
                resources.add(resource);
                this.fillIndex(uri, resource, index);
                boolean _continueProcessing = strategy.continueProcessing((ResourceSet)resourceSet, null, ++clusterIndex);
                boolean bl4 = _not = !_continueProcessing;
                if (!_not) continue;
                continue_ = false;
            }
            if (continue_) continue;
            this.clearResourceSet((ResourceSet)resourceSet);
        }
        this.installIndex(resourceSet, index);
        if (needsJava) {
            File _generateStubs = this.generateStubs(index, sourceResourceURIs);
            String stubsClasses = this.compileStubs(_generateStubs);
            LOG.info((Object)"Installing type provider for stubs.");
            ArrayList _newArrayList_1 = CollectionLiterals.newArrayList((Object[])new String[]{stubsClasses});
            Iterable _plus_6 = Iterables.concat((Iterable)allClassPathEntries, (Iterable)_newArrayList_1);
            this.installTypeProvider(_plus_6, resourceSet, this.jvmTypeAccess);
        }
        LOG.info((Object)"Validate and generate.");
        Iterator<URI> sourceResourceIterator = sourceResourceURIs.iterator();
        boolean hasValidationErrors = false;
        while (sourceResourceIterator.hasNext()) {
            ArrayList resources = CollectionLiterals.newArrayList((Object[])new Resource[0]);
            int clusterIndex = 0;
            boolean continue_ = true;
            while (sourceResourceIterator.hasNext() && continue_) {
                boolean _not_1;
                URI uri = sourceResourceIterator.next();
                Resource resource = resourceSet.getResource(uri, true);
                resources.add(resource);
                resource.getContents();
                EcoreUtil2.resolveLazyCrossReferences((Resource)resource, (CancelIndicator)CancelIndicator.NullImpl);
                boolean _or = false;
                boolean _validate = this.validate(resource);
                boolean _not = !_validate;
                _or = _not ? true : hasValidationErrors;
                hasValidationErrors = _or;
                boolean _continueProcessing = strategy.continueProcessing((ResourceSet)resourceSet, null, ++clusterIndex);
                boolean bl5 = _not_1 = !_continueProcessing;
                if (!_not_1) continue;
                continue_ = false;
            }
            boolean _and = false;
            _and = !this.failOnValidationError ? false : hasValidationErrors;
            if (_and) {
                return !hasValidationErrors;
            }
            this.generate(resources);
            if (continue_) continue;
            this.clearResourceSet((ResourceSet)resourceSet);
        }
        return !hasValidationErrors;
    }

    public void fillIndex(URI uri, Resource resource, ResourceDescriptionsData index) {
        LanguageAccess _languageAccess = this.languageAccess(uri);
        IResourceDescription.Manager _resourceDescriptionManager = _languageAccess.getResourceDescriptionManager();
        IResourceDescription description = _resourceDescriptionManager.getResourceDescription(resource);
        index.addDescription(uri, description);
    }

    public void fileEncodingSetup(Collection<LanguageAccess> langs, String encoding) {
        for (LanguageAccess lang : langs) {
            IEncodingProvider _encodingProvider;
            IEncodingProvider provider = _encodingProvider = lang.getEncodingProvider();
            boolean _matched = false;
            if (!_matched && provider instanceof IEncodingProvider.Runtime) {
                _matched = true;
                ((IEncodingProvider.Runtime)provider).setDefaultEncoding(encoding);
            }
            if (_matched) continue;
            this.forceDebugLog("Couldn't set encoding '" + encoding + "' for provider '" + provider + "'. Only subclasses of IEncodingProvider.Runtime are supported.");
        }
    }

    protected void installIndex(XtextResourceSet resourceSet, ResourceDescriptionsData index) {
        ResourceDescriptionsData.ResourceSetAdapter.installResourceDescriptionsData((ResourceSet)resourceSet, (ResourceDescriptionsData)index);
    }

    protected String compileStubs(File stubsDir) {
        File stubsClasses = this.createTempDir("classes");
        this.compiler.setClassPath(this.classPathEntries);
        String _absolutePath = stubsDir.getAbsolutePath();
        String _plus = "Compiling stubs located in " + _absolutePath;
        LOG.info((Object)_plus);
        Iterable _plus_1 = Iterables.concat(this.javaSourceDirs, this.sourceDirs);
        String _absolutePath_1 = stubsDir.getAbsolutePath();
        ArrayList _newArrayList = CollectionLiterals.newArrayList((Object[])new String[]{_absolutePath_1});
        Iterable _plus_2 = Iterables.concat((Iterable)_plus_1, (Iterable)_newArrayList);
        Set<String> sourcesToCompile = this.uniqueEntries(_plus_2);
        String _join = IterableExtensions.join(sourcesToCompile, (CharSequence)",");
        String _plus_3 = "Compiler source roots: " + _join;
        this.forceDebugLog(_plus_3);
        IJavaCompiler.CompilationResult result = this.compiler.compile(sourcesToCompile, stubsClasses);
        if (result != null) {
            switch (result) {
                case SKIPPED: {
                    LOG.info((Object)"Nothing to compile. Stubs compilation was skipped.");
                    break;
                }
                case FAILED: {
                    this.forceDebugLog("Stubs compilation finished with errors.");
                    break;
                }
                case SUCCEEDED: {
                    this.forceDebugLog("Stubs compilation successfully finished.");
                    break;
                }
            }
        }
        return stubsClasses.getAbsolutePath();
    }

    protected Set<String> uniqueEntries(Iterable<String> pathes) {
        Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

            public String apply(String it) {
                File _file = new File(it);
                return _file.getAbsolutePath();
            }
        };
        Iterable _map = IterableExtensions.map(pathes, (Functions.Function1)_function);
        return IterableExtensions.toSet((Iterable)_map);
    }

    protected File generateStubs(final ResourceDescriptionsData data, List<URI> sourceResourceURIs) {
        boolean _notEquals;
        File stubsDir = this.createTempDir("stubs");
        String _absolutePath = stubsDir.getAbsolutePath();
        String _plus = "Generating stubs into " + _absolutePath;
        LOG.info((Object)_plus);
        boolean bl = _notEquals = !Objects.equal((Object)this.encoding, null);
        if (_notEquals) {
            this.encodingProvider.setDefaultEncoding(this.encoding);
        }
        String _absolutePath_1 = stubsDir.getAbsolutePath();
        this.commonFileAccess.setOutputPath("DEFAULT_OUTPUT", _absolutePath_1);
        Functions.Function1<URI, Boolean> _function = new Functions.Function1<URI, Boolean>(){

            public Boolean apply(URI it) {
                LanguageAccess _languageAccess = StandaloneBuilder.this.languageAccess(it);
                return _languageAccess.isLinksAgainstJava();
            }
        };
        Iterable generateStubs = IterableExtensions.filter(sourceResourceURIs, (Functions.Function1)_function);
        Procedures.Procedure1<URI> _function_1 = new Procedures.Procedure1<URI>(){

            public void apply(URI it) {
                LanguageAccess _languageAccess = StandaloneBuilder.this.languageAccess(it);
                IStubGenerator _stubGenerator = _languageAccess.getStubGenerator();
                IResourceDescription _resourceDescription = data.getResourceDescription(it);
                _stubGenerator.doGenerateStubs((IFileSystemAccess)StandaloneBuilder.this.commonFileAccess, _resourceDescription);
            }
        };
        IterableExtensions.forEach((Iterable)generateStubs, (Procedures.Procedure1)_function_1);
        return stubsDir;
    }

    protected boolean validate(Resource resource) {
        try {
            URI _uRI = resource.getURI();
            String _lastSegment = _uRI.lastSegment();
            String _plus = "Starting validation for input: '" + _lastSegment;
            String _plus_1 = String.valueOf(_plus) + "'";
            LOG.info((Object)_plus_1);
            URI _uRI_1 = resource.getURI();
            LanguageAccess _languageAccess = this.languageAccess(_uRI_1);
            IResourceValidator resourceValidator = _languageAccess.getResourceValidator();
            List validationResult = resourceValidator.validate(resource, CheckMode.ALL, null);
            return this.issueHandler.handleIssue(validationResult);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void generate(List<Resource> sourceResources) {
        for (Resource it : sourceResources) {
            boolean _matched;
            URI _uRI = it.getURI();
            String _lastSegment = _uRI.lastSegment();
            String _plus = "Starting generator for input: '" + _lastSegment;
            String _plus_1 = String.valueOf(_plus) + "'";
            LOG.info((Object)_plus_1);
            URI _uRI_1 = it.getURI();
            this.registerCurrentSource(_uRI_1);
            URI _uRI_2 = it.getURI();
            LanguageAccess access = this.languageAccess(_uRI_2);
            JavaIoFileSystemAccess fileSystemAccess = this.getFileSystemAccess(access);
            boolean _isWriteStorageResources = this.isWriteStorageResources();
            if (_isWriteStorageResources && !(_matched = false) && it instanceof StorageAwareResource) {
                boolean _notEquals;
                IResourceStorageFacade _resourceStorageFacade = ((StorageAwareResource)it).getResourceStorageFacade();
                boolean bl = _notEquals = !Objects.equal((Object)_resourceStorageFacade, null);
                if (_notEquals) {
                    _matched = true;
                    IResourceStorageFacade _resourceStorageFacade_1 = ((StorageAwareResource)it).getResourceStorageFacade();
                    _resourceStorageFacade_1.saveResource((StorageAwareResource)it, (IFileSystemAccessExtension3)fileSystemAccess);
                }
            }
            IGenerator _generator = access.getGenerator();
            _generator.doGenerate(it, (IFileSystemAccess)fileSystemAccess);
        }
    }

    protected void registerCurrentSource(final URI uri) {
        URI absoluteSource;
        boolean _equals;
        LanguageAccess _languageAccess = this.languageAccess(uri);
        JavaIoFileSystemAccess fsa = this.getFileSystemAccess(_languageAccess);
        Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

            public String apply(String it) {
                File _file = new File(it);
                String _absolutePath = _file.getAbsolutePath();
                URI _createFileURI = URI.createFileURI((String)_absolutePath);
                return _createFileURI.toString();
            }
        };
        Iterable _map = IterableExtensions.map(this.sourceDirs, (Functions.Function1)_function);
        Functions.Function1<String, Boolean> _function_1 = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                String _string = uri.toString();
                return _string.startsWith(it);
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_map, (Functions.Function1)_function_1);
        Functions.Function2<String, String, String> _function_2 = new Functions.Function2<String, String, String>(){

            public String apply(String longest, String current) {
                int _length_1;
                String _xifexpression = null;
                int _length = current.length();
                boolean _greaterThan = _length > (_length_1 = longest.length());
                _xifexpression = _greaterThan ? current : longest;
                return _xifexpression;
            }
        };
        String _reduce = (String)IterableExtensions.reduce((Iterable)_filter, (Functions.Function2)_function_2);
        URI _createFileURI = null;
        if (_reduce != null) {
            _createFileURI = URI.createFileURI((String)_reduce);
        }
        if (_equals = Objects.equal((Object)(absoluteSource = _createFileURI), null)) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"Resource ");
            _builder.append((Object)uri, "");
            _builder.append((Object)" is not contained in any of the known source folders ");
            _builder.append(this.sourceDirs, "");
            _builder.append((Object)".");
            throw new IllegalStateException(_builder.toString());
        }
        Map _outputConfigurations = fsa.getOutputConfigurations();
        Collection _values = _outputConfigurations.values();
        for (OutputConfiguration output : _values) {
            Set _sourceFolders = output.getSourceFolders();
            for (String relativeSource : _sourceFolders) {
                String _string = absoluteSource.toString();
                boolean _endsWith = _string.endsWith(relativeSource);
                if (!_endsWith) continue;
                fsa.setCurrentSource(relativeSource);
            }
        }
    }

    private JavaIoFileSystemAccess getFileSystemAccess(LanguageAccess language) {
        JavaIoFileSystemAccess fsa = this.configuredFsas.get(language);
        boolean _equals = Objects.equal((Object)fsa, null);
        if (_equals) {
            JavaIoFileSystemAccess _configureFileSystemAccess;
            JavaIoFileSystemAccess _createFileSystemAccess;
            File _file = new File(this.baseDir);
            fsa = _createFileSystemAccess = language.createFileSystemAccess(_file);
            fsa = _configureFileSystemAccess = this.configureFileSystemAccess(fsa, language);
            this.configuredFsas.put(language, fsa);
        }
        return fsa;
    }

    protected JavaIoFileSystemAccess configureFileSystemAccess(JavaIoFileSystemAccess fsa, LanguageAccess language) {
        return fsa;
    }

    private LanguageAccess languageAccess(URI uri) {
        String _fileExtension = uri.fileExtension();
        return this.languages.get(_fileExtension);
    }

    protected File createTempDir(String subDir) {
        try {
            boolean _exists;
            boolean _not_1;
            boolean _not;
            File file = new File(this.tempDir, subDir);
            boolean _and = false;
            boolean _mkdirs = file.mkdirs();
            boolean bl = _not = !_mkdirs;
            _and = !_not ? false : (_not_1 = !(_exists = file.exists()));
            if (_and) {
                String _absolutePath = file.getAbsolutePath();
                String _plus = "Failed to create directory '" + _absolutePath;
                String _plus_1 = String.valueOf(_plus) + "'";
                throw new IOException(_plus_1);
            }
            return file;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void installTypeProvider(Iterable<String> classPathRoots, XtextResourceSet resSet, IndexedJvmTypeAccess typeAccess) {
        URLClassLoader classLoader = this.createURLClassLoader(classPathRoots);
        new ClasspathTypeProvider((ClassLoader)classLoader, (ResourceSet)resSet, typeAccess, null);
        resSet.setClasspathURIContext((Object)classLoader);
    }

    private URLClassLoader createURLClassLoader(Iterable<String> classPathEntries) {
        Functions.Function1<String, URL> _function = new Functions.Function1<String, URL>(){

            public URL apply(String str) {
                try {
                    File _file = new File(str);
                    java.net.URI _uRI = _file.toURI();
                    return _uRI.toURL();
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        Iterable classPathUrls = IterableExtensions.map(classPathEntries, (Functions.Function1)_function);
        return new URLClassLoader((URL[])Conversions.unwrapArray((Object)classPathUrls, URL.class));
    }

    protected List<URI> collectResources(Iterable<String> roots, ResourceSet resourceSet) {
        Set<String> _keySet = this.languages.keySet();
        String extensions = IterableExtensions.join(_keySet, (CharSequence)"|");
        final NameBasedFilter nameBasedFilter = new NameBasedFilter();
        nameBasedFilter.setRegularExpression(".*\\.(?:(" + extensions + "))$");
        final ArrayList resources = CollectionLiterals.newArrayList((Object[])new URI[0]);
        PathTraverser _pathTraverser = new PathTraverser();
        List _list = IterableExtensions.toList(roots);
        Predicate<URI> _function = new Predicate<URI>(){

            public boolean apply(URI input) {
                boolean matches = nameBasedFilter.matches(input);
                if (matches) {
                    StandaloneBuilder.this.forceDebugLog("Adding file '" + input + "'");
                    resources.add(input);
                }
                return matches;
            }
        };
        Multimap modelsFound = _pathTraverser.resolvePathes(_list, (Predicate)_function);
        Map _asMap = modelsFound.asMap();
        Procedures.Procedure2<String, Collection<URI>> _function_1 = new Procedures.Procedure2<String, Collection<URI>>(){

            public void apply(String uri, Collection<URI> resource) {
                boolean _isDirectory;
                boolean _not;
                boolean _notEquals;
                File file = new File(uri);
                boolean _and = false;
                boolean _and_1 = false;
                boolean bl = _notEquals = !Objects.equal(resource, null);
                _and_1 = !_notEquals ? false : (_not = !(_isDirectory = file.isDirectory()));
                if (!_and_1) {
                    _and = false;
                } else {
                    boolean _endsWith;
                    String _name = file.getName();
                    _and = _endsWith = _name.endsWith(".jar");
                }
                if (_and) {
                    StandaloneBuilder.this.registerBundle(file);
                }
            }
        };
        MapExtensions.forEach((Map)_asMap, (Procedures.Procedure2)_function_1);
        return resources;
    }

    protected void registerBundle(File file) {
        block34: {
            JarFile jarFile;
            block32: {
                String name;
                block33: {
                    Map _platformResourceMap;
                    boolean _containsKey;
                    boolean _notEquals;
                    Manifest manifest;
                    block31: {
                        JarFile _jarFile;
                        jarFile = null;
                        jarFile = _jarFile = new JarFile(file);
                        manifest = jarFile.getManifest();
                        boolean _equals = Objects.equal((Object)manifest, null);
                        if (!_equals) break block31;
                        try {
                            boolean _notEquals_1;
                            boolean bl = _notEquals_1 = !Objects.equal((Object)jarFile, null);
                            if (_notEquals_1) {
                                jarFile.close();
                            }
                        }
                        catch (Throwable _t_1) {
                            if (_t_1 instanceof IOException) {
                                IOException e_2 = (IOException)_t_1;
                                LOG.error((Object)jarFile, (Throwable)e_2);
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t_1);
                        }
                        return;
                    }
                    Attributes _mainAttributes = manifest.getMainAttributes();
                    name = _mainAttributes.getValue("Bundle-SymbolicName");
                    boolean bl = _notEquals = !Objects.equal((Object)name, null);
                    if (!_notEquals) break block32;
                    int indexOf = name.indexOf(";");
                    if (indexOf > 0) {
                        String _substring;
                        name = _substring = name.substring(0, indexOf);
                    }
                    if (!(_containsKey = (_platformResourceMap = EcorePlugin.getPlatformResourceMap()).containsKey(name))) break block33;
                    try {
                        boolean _notEquals_1;
                        boolean bl2 = _notEquals_1 = !Objects.equal((Object)jarFile, null);
                        if (_notEquals_1) {
                            jarFile.close();
                        }
                    }
                    catch (Throwable _t_1) {
                        if (_t_1 instanceof IOException) {
                            IOException e_2 = (IOException)_t_1;
                            LOG.error((Object)jarFile, (Throwable)e_2);
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t_1);
                    }
                    return;
                }
                try {
                    try {
                        java.net.URI _uRI = file.toURI();
                        String _plus = "archive:" + _uRI;
                        String path = String.valueOf(_plus) + "!/";
                        URI uri = URI.createURI((String)path);
                        Map _platformResourceMap_1 = EcorePlugin.getPlatformResourceMap();
                        _platformResourceMap_1.put(name, uri);
                    }
                    catch (Throwable _t) {
                        if (_t instanceof ZipException) {
                            ZipException e = (ZipException)_t;
                            String _absolutePath = file.getAbsolutePath();
                            String _plus_1 = "Could not open Jar file " + _absolutePath;
                            String _plus_2 = String.valueOf(_plus_1) + ".";
                            this.forceDebugLog(_plus_2);
                        } else if (_t instanceof Exception) {
                            Exception e_1 = (Exception)_t;
                            String _absolutePath_1 = file.getAbsolutePath();
                            LOG.error((Object)_absolutePath_1, (Throwable)e_1);
                        } else {
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                        try {
                            boolean _notEquals_1;
                            boolean bl = _notEquals_1 = !Objects.equal((Object)jarFile, null);
                            if (_notEquals_1) {
                                jarFile.close();
                            }
                            break block34;
                        }
                        catch (Throwable _t_1) {
                            if (_t_1 instanceof IOException) {
                                IOException e_2 = (IOException)_t_1;
                                LOG.error((Object)jarFile, (Throwable)e_2);
                                break block34;
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t_1);
                        }
                    }
                }
                catch (Throwable throwable) {
                    block35: {
                        try {
                            boolean _notEquals_1;
                            boolean bl = _notEquals_1 = !Objects.equal(jarFile, null);
                            if (_notEquals_1) {
                                jarFile.close();
                            }
                        }
                        catch (Throwable _t_1) {
                            if (_t_1 instanceof IOException) {
                                IOException e_2 = (IOException)_t_1;
                                LOG.error((Object)jarFile, (Throwable)e_2);
                                break block35;
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t_1);
                        }
                    }
                    throw throwable;
                }
            }
            try {
                boolean _notEquals_1;
                boolean bl = _notEquals_1 = !Objects.equal((Object)jarFile, null);
                if (_notEquals_1) {
                    jarFile.close();
                }
            }
            catch (Throwable _t_1) {
                if (_t_1 instanceof IOException) {
                    IOException e_2 = (IOException)_t_1;
                    LOG.error((Object)jarFile, (Throwable)e_2);
                }
                throw Exceptions.sneakyThrow((Throwable)_t_1);
            }
        }
    }

    public IJavaCompiler getCompiler() {
        return this.compiler;
    }

    public void clearResourceSet(ResourceSet resourceSet) {
        boolean wasDeliver = resourceSet.eDeliver();
        try {
            resourceSet.eSetDeliver(false);
            EList _resources = resourceSet.getResources();
            _resources.clear();
        }
        finally {
            resourceSet.eSetDeliver(wasDeliver);
        }
    }

    protected void forceDebugLog(String logMessage) {
        boolean _isDebugEnabled = LOG.isDebugEnabled();
        if (_isDebugEnabled) {
            LOG.debug((Object)logMessage);
        } else if (this.debugLog) {
            LOG.info((Object)logMessage);
        }
    }

    @Pure
    public Map<String, LanguageAccess> getLanguages() {
        return this.languages;
    }

    public void setLanguages(Map<String, LanguageAccess> languages) {
        this.languages = languages;
    }

    @Pure
    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    @Pure
    public Iterable<String> getSourceDirs() {
        return this.sourceDirs;
    }

    public void setSourceDirs(Iterable<String> sourceDirs) {
        this.sourceDirs = sourceDirs;
    }

    @Pure
    public Iterable<String> getJavaSourceDirs() {
        return this.javaSourceDirs;
    }

    public void setJavaSourceDirs(Iterable<String> javaSourceDirs) {
        this.javaSourceDirs = javaSourceDirs;
    }

    @Pure
    public Iterable<String> getClassPathEntries() {
        return this.classPathEntries;
    }

    public void setClassPathEntries(Iterable<String> classPathEntries) {
        this.classPathEntries = classPathEntries;
    }

    @Pure
    public File getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(File tempDir) {
        this.tempDir = tempDir;
    }

    @Pure
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Pure
    public String getClassPathLookUpFilter() {
        return this.classPathLookUpFilter;
    }

    public void setClassPathLookUpFilter(String classPathLookUpFilter) {
        this.classPathLookUpFilter = classPathLookUpFilter;
    }

    @Pure
    public boolean isFailOnValidationError() {
        return this.failOnValidationError;
    }

    public void setFailOnValidationError(boolean failOnValidationError) {
        this.failOnValidationError = failOnValidationError;
    }

    @Pure
    public boolean isDebugLog() {
        return this.debugLog;
    }

    public void setDebugLog(boolean debugLog) {
        this.debugLog = debugLog;
    }

    @Pure
    public boolean isWriteStorageResources() {
        return this.writeStorageResources;
    }

    public void setWriteStorageResources(boolean writeStorageResources) {
        this.writeStorageResources = writeStorageResources;
    }

    @Pure
    public ClusteringConfig getClusteringConfig() {
        return this.clusteringConfig;
    }

    public void setClusteringConfig(ClusteringConfig clusteringConfig) {
        this.clusteringConfig = clusteringConfig;
    }
}

