/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.conversion.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractValueConverterService;
import org.eclipse.xtext.conversion.impl.DefaultTerminalConverter;
import org.eclipse.xtext.conversion.impl.EFactoryValueConverter;
import org.eclipse.xtext.nodemodel.INode;

public abstract class AbstractDeclarativeValueConverterService
extends AbstractValueConverterService
implements IValueConverterService.Introspectable {
    private static final Logger log = Logger.getLogger(AbstractDeclarativeValueConverterService.class);
    private Grammar grammar;
    private volatile Map<String, IValueConverter<Object>> converters;
    @Inject
    protected DefaultTerminalConverter.Factory defaultTerminalConverterFactory;

    @Inject
    public void setGrammar(IGrammarAccess grammarAccess) {
        this.grammar = grammarAccess.getGrammar();
    }

    protected Grammar getGrammar() {
        return this.grammar;
    }

    @Override
    public String toString(Object value, String lexerRule) {
        return this.getConverter(lexerRule).toString(value);
    }

    @Override
    public Object toValue(String string, String lexerRule, INode node) throws ValueConverterException {
        return this.getConverter(lexerRule).toValue(string, node);
    }

    @Override
    public IValueConverter<Object> getConverter(String lexerRule) {
        Map<String, IValueConverter<Object>> map = this.getConverters();
        if (map.containsKey(lexerRule)) {
            return map.get(lexerRule);
        }
        return IValueConverter.NO_OP_CONVERTER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, IValueConverter<Object>> getConverters() {
        if (this.converters == null) {
            AbstractDeclarativeValueConverterService abstractDeclarativeValueConverterService = this;
            synchronized (abstractDeclarativeValueConverterService) {
                if (this.converters == null) {
                    HashMap converters = Maps.newHashMap();
                    this.internalRegisterForClass(this.getClass(), converters);
                    this.converters = ImmutableMap.copyOf((Map)converters);
                }
            }
        }
        return this.converters;
    }

    protected void internalRegisterForClass(Class<?> clazz, Map<String, IValueConverter<Object>> converters) {
        Method[] methods = clazz.getDeclaredMethods();
        HashSet thisConverters = Sets.newHashSet();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (this.isConfigurationMethod(method)) {
                try {
                    String ruleName = method.getAnnotation(ValueConverter.class).rule();
                    AbstractRule rule = GrammarUtil.findRuleForName(this.getGrammar(), ruleName);
                    if (rule != null) {
                        if (rule instanceof TerminalRule && ((TerminalRule)rule).isFragment()) {
                            throw new IllegalStateException("Tried to register a value converter for a fragment terminal rule: '" + ruleName + "'");
                        }
                        if (!thisConverters.add(ruleName)) {
                            throw new IllegalStateException("Tried to register two value converters for rule '" + ruleName + "'");
                        }
                        if (!converters.containsKey(ruleName)) {
                            IValueConverter valueConverter = (IValueConverter)method.invoke((Object)this, new Object[0]);
                            if (valueConverter instanceof IValueConverter.RuleSpecific) {
                                ((IValueConverter.RuleSpecific)((Object)valueConverter)).setRule(rule);
                            }
                            converters.put(ruleName, valueConverter);
                        }
                    } else {
                        log.trace((Object)("Tried to register value converter for rule '" + ruleName + "' which is not available in the grammar."));
                    }
                }
                catch (IllegalStateException e) {
                    throw e;
                }
                catch (IllegalArgumentException e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            ++n2;
        }
        if (clazz.getSuperclass() != null) {
            this.internalRegisterForClass(clazz.getSuperclass(), converters);
        }
        this.registerEFactoryConverters(converters);
    }

    protected boolean isConfigurationMethod(Method method) {
        return method.isAnnotationPresent(ValueConverter.class) && method.getParameterTypes().length == 0 && IValueConverter.class.isAssignableFrom(method.getReturnType());
    }

    protected void registerEFactoryConverters(Map<String, IValueConverter<Object>> converters) {
        for (ParserRule parserRule : GrammarUtil.allParserRules(this.getGrammar())) {
            if (!GrammarUtil.isDatatypeRule(parserRule) || converters.containsKey(parserRule.getName())) continue;
            EDataType datatype = (EDataType)parserRule.getType().getClassifier();
            converters.put(parserRule.getName(), new EFactoryValueConverter(datatype));
        }
        for (TerminalRule terminalRule : GrammarUtil.allTerminalRules(this.getGrammar())) {
            String terminalRuleName;
            if (terminalRule.isFragment() || converters.containsKey(terminalRuleName = terminalRule.getName())) continue;
            converters.put(terminalRuleName, this.defaultTerminalConverterFactory.create(terminalRule));
        }
    }

    public void setDefaultTerminalConverterFactory(DefaultTerminalConverter.Factory defaultTerminalConverterFactory) {
        this.defaultTerminalConverterFactory = defaultTerminalConverterFactory;
    }

    public DefaultTerminalConverter.Factory getDefaultTerminalConverterFactory() {
        return this.defaultTerminalConverterFactory;
    }
}

