/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.common.outline;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.ide.common.outline.IXtendOutlineContext;
import org.eclipse.xtend.ide.common.outline.IXtendOutlineNodeBuilder;
import org.eclipse.xtend.ide.common.outline.IXtendOutlineTreeBuilder;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeExtensions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedConstructor;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedFeature;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedField;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.ResolvedFeatures;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xtype.XImportSection;

public abstract class AbstractXtendOutlineTreeBuilder
implements IXtendOutlineTreeBuilder {
    @Inject
    @Extension
    private JvmTypeExtensions _jvmTypeExtensions;
    @Inject
    private CommonTypeComputationServices services;
    @Inject
    @Extension
    protected IXtendJvmAssociations _iXtendJvmAssociations;
    @Extension
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    protected IXtendOutlineNodeBuilder xtendOutlineNodeBuilder;

    protected void _build(Void modelElement, IXtendOutlineContext context) {
    }

    protected void _build(EObject modelElement, final IXtendOutlineContext context) {
        EList _eContents = modelElement.eContents();
        Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

            public void apply(EObject it) {
                AbstractXtendOutlineTreeBuilder.this.xtendOutlineNodeBuilder.buildEObjectNode(it, context);
            }
        };
        IterableExtensions.forEach((Iterable)_eContents, (Procedures.Procedure1)_function);
    }

    protected void buildPackageAndImportSection(XtendFile xtendFile, IXtendOutlineContext context) {
        XImportSection _importSection_1;
        EList _importDeclarations;
        boolean _isEmpty;
        boolean _not;
        boolean _notEquals_1;
        boolean _notEquals;
        String _package = xtendFile.getPackage();
        boolean bl = _notEquals = !Objects.equal((Object)_package, null);
        if (_notEquals) {
            this.xtendOutlineNodeBuilder.buildPackageNode(xtendFile, context);
        }
        boolean _and = false;
        XImportSection _importSection = xtendFile.getImportSection();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_importSection, null);
        _and = !_notEquals_1 ? false : (_not = !(_isEmpty = (_importDeclarations = (_importSection_1 = xtendFile.getImportSection()).getImportDeclarations()).isEmpty()));
        if (_and) {
            this.xtendOutlineNodeBuilder.buildImportSectionNode(xtendFile, context);
        }
    }

    protected void buildInheritedMembers(JvmDeclaredType inferredType, IXtendOutlineContext context) {
        Resource _eResource = inferredType.eResource();
        ResourceSet _resourceSet = _eResource.getResourceSet();
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, _resourceSet);
        LightweightTypeReference typeReference = owner.toLightweightTypeReference((JvmType)inferredType);
        List superTypes = typeReference.getAllSuperTypes();
        IXtendOutlineContext superTypeContext = context;
        for (LightweightTypeReference superTypeRef : superTypes) {
            IXtendOutlineContext _increaseInheritanceDepth;
            superTypeContext = _increaseInheritanceDepth = superTypeContext.increaseInheritanceDepth();
            ResolvedFeatures resolvedFeatures = new ResolvedFeatures(superTypeRef);
            List _declaredFields = resolvedFeatures.getDeclaredFields();
            for (IResolvedField jvmField : _declaredFields) {
                boolean _not;
                JvmField _declaration = jvmField.getDeclaration();
                boolean _skipFeature = this.skipFeature((JvmFeature)_declaration);
                boolean bl = _not = !_skipFeature;
                if (!_not) continue;
                this.xtendOutlineNodeBuilder.buildResolvedFeatureNode(inferredType, (IResolvedFeature)jvmField, superTypeContext);
            }
            List _declaredConstructors = resolvedFeatures.getDeclaredConstructors();
            for (IResolvedConstructor constructor : _declaredConstructors) {
                boolean _not_1;
                JvmConstructor _declaration_1 = constructor.getDeclaration();
                boolean _skipFeature_1 = this.skipFeature((JvmFeature)_declaration_1);
                boolean bl = _not_1 = !_skipFeature_1;
                if (!_not_1) continue;
                this.xtendOutlineNodeBuilder.buildResolvedFeatureNode(inferredType, (IResolvedFeature)constructor, superTypeContext);
            }
            List _declaredOperations = resolvedFeatures.getDeclaredOperations();
            for (IResolvedOperation operation : _declaredOperations) {
                JvmOperation _declaration_3;
                boolean _isProcessed;
                boolean _not_3;
                boolean _not_2;
                boolean _and = false;
                JvmOperation _declaration_2 = operation.getDeclaration();
                boolean _skipFeature_2 = this.skipFeature((JvmFeature)_declaration_2);
                boolean bl = _not_2 = !_skipFeature_2;
                _and = !_not_2 ? false : (_not_3 = !(_isProcessed = superTypeContext.isProcessed((JvmMember)(_declaration_3 = operation.getDeclaration()))));
                if (!_and) continue;
                this.xtendOutlineNodeBuilder.buildResolvedFeatureNode(inferredType, (IResolvedFeature)operation, superTypeContext);
            }
            JvmType declaredType = superTypeRef.getType();
            if (!(declaredType instanceof JvmDeclaredType)) continue;
            final IXtendOutlineContext nestedTypeContext = superTypeContext.hideInherited();
            EList _members = ((JvmDeclaredType)declaredType).getMembers();
            Iterable _filter = Iterables.filter((Iterable)_members, JvmDeclaredType.class);
            Procedures.Procedure1<JvmDeclaredType> _function = new Procedures.Procedure1<JvmDeclaredType>(){

                public void apply(JvmDeclaredType it) {
                    AbstractXtendOutlineTreeBuilder.this.buildJvmType(it, nestedTypeContext);
                }
            };
            IterableExtensions.forEach((Iterable)_filter, (Procedures.Procedure1)_function);
        }
    }

    protected boolean skipFeature(JvmFeature feature) {
        boolean _xifexpression = false;
        if (feature instanceof JvmConstructor) {
            boolean _isSingleSyntheticDefaultConstructor;
            boolean _or = false;
            JvmDeclaredType _declaringType = ((JvmConstructor)feature).getDeclaringType();
            boolean _isLocal = _declaringType.isLocal();
            _or = _isLocal ? true : (_isSingleSyntheticDefaultConstructor = this._jvmTypeExtensions.isSingleSyntheticDefaultConstructor((JvmConstructor)feature));
            _xifexpression = _or;
        }
        return _xifexpression;
    }

    protected void buildJvmType(JvmDeclaredType typeElement, IXtendOutlineContext context) {
        boolean _not;
        IXtendOutlineContext jvmTypeContext = this.xtendOutlineNodeBuilder.buildXtendNode((EObject)typeElement, context);
        boolean _isProcessed = jvmTypeContext.isProcessed((JvmMember)typeElement);
        boolean bl = _not = !_isProcessed;
        if (_not) {
            jvmTypeContext.markAsProcessed((JvmMember)typeElement);
            this.buildMembers(typeElement, typeElement, jvmTypeContext);
        }
    }

    protected void buildMembers(JvmDeclaredType inferredType, JvmDeclaredType baseType, @Extension IXtendOutlineContext context) {
        EList _members = inferredType.getMembers();
        for (JvmMember member : _members) {
            boolean _not;
            boolean _isProcessed = context.isProcessed(member);
            boolean bl = _not = !_isProcessed;
            if (!_not) continue;
            if (member instanceof JvmDeclaredType) {
                boolean _isShowInherited = context.isShowInherited();
                if (_isShowInherited) {
                    IXtendOutlineContext typeContext = context.newContext();
                    EObject sourceElement = this._iXtendJvmAssociations.getPrimarySourceElement((EObject)member);
                    if (sourceElement instanceof XtendTypeDeclaration) {
                        this.buildType(sourceElement, typeContext);
                    } else {
                        this.buildJvmType((JvmDeclaredType)member, typeContext);
                    }
                } else {
                    this.buildJvmType((JvmDeclaredType)member, context);
                }
            } else if (member instanceof JvmFeature) {
                boolean _not_1;
                boolean _skipFeature = this.skipFeature((JvmFeature)member);
                boolean bl2 = _not_1 = !_skipFeature;
                if (_not_1) {
                    final IXtendOutlineContext featureContext = this.buildFeature(baseType, (JvmFeature)member, (EObject)member, context);
                    EList _localClasses = ((JvmFeature)member).getLocalClasses();
                    Procedures.Procedure1<JvmGenericType> _function = new Procedures.Procedure1<JvmGenericType>(){

                        public void apply(JvmGenericType it) {
                            IXtendOutlineContext _newContext = featureContext.newContext();
                            AbstractXtendOutlineTreeBuilder.this.buildJvmType((JvmDeclaredType)it, _newContext);
                        }
                    };
                    IterableExtensions.forEach((Iterable)_localClasses, (Procedures.Procedure1)_function);
                }
            }
            context.markAsProcessed(member);
        }
        boolean _isShowInherited_1 = context.isShowInherited();
        if (_isShowInherited_1) {
            this.buildInheritedMembers(inferredType, context);
        }
    }

    protected IXtendOutlineContext buildFeature(JvmDeclaredType inferredType, JvmFeature jvmFeature, EObject semanticFeature, IXtendOutlineContext context) {
        boolean _not;
        IXtendOutlineContext _xifexpression = null;
        boolean _isSynthetic = this._jvmTypeExtensions.isSynthetic((JvmIdentifiableElement)jvmFeature);
        boolean bl = _not = !_isSynthetic;
        if (_not) {
            _xifexpression = this.xtendOutlineNodeBuilder.buildFeatureNode(inferredType, semanticFeature, context);
        }
        return _xifexpression;
    }

    protected abstract void buildType(EObject var1, IXtendOutlineContext var2);

    @Override
    public void build(EObject modelElement, IXtendOutlineContext context) {
        if (modelElement != null) {
            this._build(modelElement, context);
            return;
        }
        if (modelElement == null) {
            this._build((Void)null, context);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(modelElement, context).toString());
    }

    public void setXtendOutlineNodeBuilder(IXtendOutlineNodeBuilder xtendOutlineNodeBuilder) {
        this.xtendOutlineNodeBuilder = xtendOutlineNodeBuilder;
    }
}

