/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Singleton;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.internal.AlternateJdkLoader;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

@Singleton
public class ProcessorInstanceForJvmTypeProvider {
    private static final Logger logger = Logger.getLogger(ProcessorInstanceForJvmTypeProvider.class);

    public Object getProcessorInstance(JvmType type) {
        try {
            ClassLoader _classLoader = this.getClassLoader((EObject)type);
            Class<?> _loadClass = null;
            if (_classLoader != null) {
                String _identifier = type.getIdentifier();
                _loadClass = _classLoader.loadClass(_identifier);
            }
            Class<?> loadClass = _loadClass;
            Object _newInstance = null;
            if (loadClass != null) {
                _newInstance = loadClass.newInstance();
            }
            return _newInstance;
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                String _identifier_1 = type.getIdentifier();
                String _plus = "Problem during instantiation of " + _identifier_1;
                String _plus_1 = String.valueOf(_plus) + " : ";
                String _message = e.getMessage();
                String _plus_2 = String.valueOf(_plus_1) + _message;
                throw new IllegalStateException(_plus_2, e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected ClassLoader getClassLoader(EObject ctx) {
        boolean _notEquals;
        Resource _eResource = ctx.eResource();
        ResourceSet resourceSet = _eResource.getResourceSet();
        EList _eAdapters = resourceSet.eAdapters();
        Iterable _filter = Iterables.filter((Iterable)_eAdapters, ProcessorClassloaderAdapter.class);
        ProcessorClassloaderAdapter adapter = (ProcessorClassloaderAdapter)((Object)IterableExtensions.head((Iterable)_filter));
        boolean bl = _notEquals = !Objects.equal((Object)((Object)adapter), null);
        if (_notEquals) {
            return adapter.getClassLoader();
        }
        boolean _matched = false;
        if (resourceSet instanceof XtextResourceSet) {
            boolean _notEquals_1;
            _matched = true;
            Object classLoaderCtx = ((XtextResourceSet)resourceSet).getClasspathURIContext();
            ClassLoader _switchResult_1 = null;
            boolean _matched_1 = false;
            if (classLoaderCtx instanceof ClassLoader) {
                _matched_1 = true;
                _switchResult_1 = (ClassLoader)classLoaderCtx;
            }
            if (!_matched_1 && classLoaderCtx instanceof Class) {
                _matched_1 = true;
                _switchResult_1 = ((Class)classLoaderCtx).getClassLoader();
            }
            ClassLoader jvmTypeLoader = _switchResult_1;
            ClassLoader _xifexpression = null;
            if (jvmTypeLoader instanceof URLClassLoader) {
                URLClassLoader _xblockexpression = null;
                ArrayList urls = CollectionLiterals.newArrayList((Object[])new URL[0]);
                URL[] _uRLs = ((URLClassLoader)jvmTypeLoader).getURLs();
                Iterables.addAll((Collection)urls, (Iterable)((Iterable)Conversions.doWrapArray((Object)_uRLs)));
                ClassLoader bootClassloader = ((URLClassLoader)jvmTypeLoader).getParent();
                if (bootClassloader instanceof AlternateJdkLoader) {
                    URL[] _uRLs_1 = ((AlternateJdkLoader)bootClassloader).getURLs();
                    Iterables.addAll((Collection)urls, (Iterable)((Iterable)Conversions.doWrapArray((Object)_uRLs_1)));
                }
                ClassLoader _classLoader = TransformationContext.class.getClassLoader();
                _xblockexpression = new URLClassLoader((URL[])Conversions.unwrapArray((Object)urls, URL.class), _classLoader);
                _xifexpression = _xblockexpression;
            } else {
                _xifexpression = jvmTypeLoader;
            }
            ClassLoader processorClassLoader = _xifexpression;
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)processorClassLoader, null);
            if (_notEquals_1) {
                EList _eAdapters_1 = ((XtextResourceSet)resourceSet).eAdapters();
                ProcessorClassloaderAdapter _processorClassloaderAdapter = new ProcessorClassloaderAdapter(processorClassLoader);
                _eAdapters_1.add((Object)_processorClassloaderAdapter);
                return processorClassLoader;
            }
        }
        logger.info((Object)"No class loader configured. Trying with this class classloader.");
        Class<?> _class = this.getClass();
        return _class.getClassLoader();
    }

    @Accessors
    public static class ProcessorClassloaderAdapter
    extends AdapterImpl {
        private ClassLoader classLoader;

        public ProcessorClassloaderAdapter(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public boolean isAdapterForType(Object type) {
            return Objects.equal((Object)type, ProcessorClassloaderAdapter.class);
        }

        public void unsetTarget(Notifier oldTarget) {
            this.discard();
        }

        public void setTarget(Notifier newTarget) {
            boolean _equals = Objects.equal((Object)newTarget, null);
            if (_equals) {
                this.discard();
            }
        }

        public ClassLoader discard() {
            Object _xifexpression = null;
            if (this.classLoader instanceof Closeable) {
                Object _xtrycatchfinallyexpression = null;
                try {
                    Object _xblockexpression = null;
                    ((Closeable)((Object)this.classLoader)).close();
                    this.classLoader = null;
                    _xtrycatchfinallyexpression = _xblockexpression = null;
                }
                catch (Throwable _t) {
                    if (_t instanceof IOException) {
                        IOException e = (IOException)_t;
                        String _message = e.getMessage();
                        logger.error((Object)_message, (Throwable)e);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                _xifexpression = _xtrycatchfinallyexpression;
            }
            return _xifexpression;
        }

        @Pure
        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public void setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }
    }
}

