/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.validation;

import com.google.inject.Inject;
import org.eclipse.xtext.ui.editor.IXtextEditorCallback;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionProvider;
import org.eclipse.xtext.ui.editor.validation.AnnotationIssueProcessor;
import org.eclipse.xtext.ui.editor.validation.IValidationIssueProcessor;
import org.eclipse.xtext.ui.editor.validation.MarkerCreator;
import org.eclipse.xtext.ui.editor.validation.MarkerIssueProcessor;
import org.eclipse.xtext.ui.editor.validation.ValidationJob;
import org.eclipse.xtext.ui.validation.MarkerTypeProvider;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;

public class ValidatingEditorCallback
extends IXtextEditorCallback.NullImpl {
    @Inject
    private IResourceValidator resourceValidator;
    @Inject
    private MarkerCreator markerCreator;
    @Inject
    private MarkerTypeProvider markerTypeProvider;
    @Inject
    private IssueResolutionProvider issueResolutionProvider;

    @Override
    public void afterCreatePartControl(XtextEditor editor) {
        super.afterCreatePartControl(editor);
        if (editor.isEditable()) {
            ValidationJob validationJob = this.newValidationJob(editor);
            validationJob.schedule();
        }
    }

    @Override
    public void afterSave(XtextEditor editor) {
        super.afterSave(editor);
        if (editor.isEditable()) {
            ValidationJob validationJob = this.newValidationJob(editor);
            validationJob.schedule();
        }
    }

    private ValidationJob newValidationJob(XtextEditor editor) {
        IValidationIssueProcessor issueProcessor = editor.getResource() == null ? new AnnotationIssueProcessor(editor.getDocument(), editor.getInternalSourceViewer().getAnnotationModel(), this.issueResolutionProvider) : new MarkerIssueProcessor(editor.getResource(), this.markerCreator, this.markerTypeProvider);
        ValidationJob validationJob = new ValidationJob(this.resourceValidator, editor.getDocument(), issueProcessor, CheckMode.NORMAL_AND_FAST);
        return validationJob;
    }
}

