/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.parser.antlr;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.generator.LineSeparatorHarmonizer;
import org.eclipse.xtext.parser.antlr.IAntlrTokenFileProvider;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.generator.AbstractXtextGeneratorFragment;
import org.eclipse.xtext.xtext.generator.CodeConfig;
import org.eclipse.xtext.xtext.generator.Issues;
import org.eclipse.xtext.xtext.generator.model.IXtextGeneratorFileSystemAccess;
import org.eclipse.xtext.xtext.generator.model.TypeReference;
import org.eclipse.xtext.xtext.generator.parser.antlr.AntlrGrammar;
import org.eclipse.xtext.xtext.generator.parser.antlr.AntlrGrammarGenUtil;
import org.eclipse.xtext.xtext.generator.parser.antlr.AntlrOptions;
import org.eclipse.xtext.xtext.generator.parser.antlr.AntlrToolFacade;
import org.eclipse.xtext.xtext.generator.parser.antlr.KeywordHelper;
import org.eclipse.xtext.xtext.generator.parser.antlr.MutableTokenDefProvider;
import org.eclipse.xtext.xtext.generator.parser.antlr.postProcessing.SuppressWarningsProcessor;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.AntlrCodeQualityHelper;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.AntlrLexerSplitter;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.AntlrParserSplitter;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.BacktrackingGuardForUnorderedGroupsRemover;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.BacktrackingGuardRemover;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.PartialClassExtractor;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.SyntacticPredicateFixup;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.UnorderedGroupsSplitter;

public abstract class AbstractAntlrGeneratorFragment2
extends AbstractXtextGeneratorFragment {
    @Inject
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private AntlrToolFacade antlrTool;
    @Inject
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private AntlrCodeQualityHelper codeQualityHelper;
    @Inject
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private LineSeparatorHarmonizer newLineNormalizer;
    @Inject
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private CodeConfig codeConfig;
    @Accessors
    private AntlrOptions options = new AntlrOptions();
    private final ArrayList<String> antlrParams = CollectionLiterals.newArrayList((Object[])new String[0]);

    public void addAntlrParam(String param) {
        this.antlrParams.add(param);
    }

    public String[] getAntlrParams() {
        boolean _not;
        ArrayList params = Lists.newArrayList(this.antlrParams);
        boolean _contains = params.contains("-Xconversiontimeout");
        boolean bl = _not = !_contains;
        if (_not) {
            params.add(0, "-Xconversiontimeout");
            params.add(1, "100000");
        }
        return (String[])Conversions.unwrapArray((Object)params, String.class);
    }

    @Override
    public void checkConfiguration(Issues issues) {
        boolean _not;
        super.checkConfiguration(issues);
        boolean _isWorkable = this.antlrTool.isWorkable();
        boolean bl = _not = !_isWorkable;
        if (_not) {
            issues.addError("\n\n*ATTENTION*\nIt is highly recommended to use ANTLR's parser generator (get it from 'http://xtext.itemis.com/'). \nAs an alternative to ANTLR you could also use the alternative implementation shipped with Xtext.\nTo do so use the generator fragment 'org.eclipse.xtext.generator.parser.packrat.PackratParserFragment' in your mwe2 file instead.");
        }
    }

    @Override
    public void generate() {
        this.checkGrammar();
        this.doGenerate();
    }

    protected abstract void doGenerate();

    protected void checkGrammar() {
        boolean _not;
        boolean _hasProductionRules = this.hasProductionRules(this.getGrammar());
        boolean bl = _not = !_hasProductionRules;
        if (_not) {
            throw new IllegalArgumentException("You may not generate an ANTLR parser for a grammar without production rules.");
        }
    }

    protected boolean hasProductionRules(Grammar grammar) {
        AbstractRule firstRule = (AbstractRule)grammar.getRules().get(0);
        return firstRule instanceof ParserRule && !GrammarUtil.isDatatypeRule((ParserRule)((ParserRule)firstRule));
    }

    protected void splitLexerClassFile(IXtextGeneratorFileSystemAccess fsa, TypeReference lexer) {
        String content = fsa.readTextFile(lexer.getJavaPath()).toString();
        AntlrLexerSplitter splitter = new AntlrLexerSplitter(content);
        splitter.setCasesPerSpecialStateSwitch(this.options.getCasesPerSpecialStateSwitch());
        fsa.generateFile(lexer.getJavaPath(), splitter.transform());
    }

    protected void splitParserClassFile(IXtextGeneratorFileSystemAccess fsa, TypeReference parser) {
        String content = fsa.readTextFile(parser.getJavaPath()).toString();
        int _fieldsPerClass = this.getOptions().getFieldsPerClass();
        AntlrParserSplitter splitter = new AntlrParserSplitter(content, _fieldsPerClass);
        String _transform = splitter.transform();
        int _methodsPerClass = this.getOptions().getMethodsPerClass();
        PartialClassExtractor extractor = new PartialClassExtractor(_transform, _methodsPerClass);
        fsa.generateFile(parser.getJavaPath(), extractor.transform());
    }

    protected void simplifyUnorderedGroupPredicatesIfRequired(Grammar grammar, IXtextGeneratorFileSystemAccess fsa, TypeReference parser) {
        if (this.containsUnorderedGroup(grammar) || this.hasParameterizedRules(grammar)) {
            this.simplifyUnorderedGroupPredicates(fsa, parser);
        }
    }

    protected boolean hasParameterizedRules(Grammar grammar) {
        List _allParserRules = GrammarUtil.allParserRules((Grammar)grammar);
        for (ParserRule rule : _allParserRules) {
            boolean _isEmpty = rule.getParameters().isEmpty();
            boolean _not = !_isEmpty;
            if (!_not) continue;
            return true;
        }
        return false;
    }

    protected void simplifyUnorderedGroupPredicates(IXtextGeneratorFileSystemAccess fsa, TypeReference parser) {
        String content = fsa.readTextFile(parser.getJavaPath()).toString();
        UnorderedGroupsSplitter splitter = new UnorderedGroupsSplitter(content);
        String transformed = splitter.transform();
        SyntacticPredicateFixup fixup = new SyntacticPredicateFixup(transformed);
        transformed = fixup.transform();
        BacktrackingGuardForUnorderedGroupsRemover remover = new BacktrackingGuardForUnorderedGroupsRemover(transformed);
        String newContent = remover.transform();
        fsa.generateFile(parser.getJavaPath(), newContent);
    }

    protected void suppressWarnings(IXtextGeneratorFileSystemAccess fsa, TypeReference type) {
        String content = fsa.readTextFile(type.getJavaPath()).toString();
        String newContent = new SuppressWarningsProcessor().process(content);
        fsa.generateFile(type.getJavaPath(), newContent);
    }

    protected void suppressWarnings(IXtextGeneratorFileSystemAccess fsa, TypeReference ... types) {
        Consumer<TypeReference> _function = it -> this.suppressWarnings(fsa, (TypeReference)it);
        ((List)Conversions.doWrapArray((Object)types)).forEach(_function);
    }

    protected void normalizeLineDelimiters(IXtextGeneratorFileSystemAccess fsa, TypeReference type) {
        String content = fsa.readTextFile(type.getJavaPath()).toString();
        content = this.newLineNormalizer.postProcess(fsa.getURI(type.getJavaPath()), (CharSequence)content).toString();
        content = content.replaceAll("\"\\+(\\r)?\\n\\s+\"", "");
        fsa.generateFile(type.getJavaPath(), content);
    }

    protected void normalizeLineDelimiters(IXtextGeneratorFileSystemAccess fsa, TypeReference ... types) {
        Consumer<TypeReference> _function = it -> this.normalizeLineDelimiters(fsa, (TypeReference)it);
        ((List)Conversions.doWrapArray((Object)types)).forEach(_function);
    }

    protected void normalizeTokens(IXtextGeneratorFileSystemAccess fsa, String tokenFile) {
        String _plus;
        String content = fsa.readTextFile(tokenFile).toString();
        content = this.newLineNormalizer.postProcess(fsa.getURI(tokenFile), (CharSequence)content).toString();
        List splitted = Strings.split((String)content, (String)this.codeConfig.getLineDelimiter());
        Collections.sort(splitted);
        String _concat = Strings.concat((String)this.codeConfig.getLineDelimiter(), (List)splitted);
        String _lineDelimiter = this.codeConfig.getLineDelimiter();
        content = _plus = _concat + _lineDelimiter;
        fsa.generateFile(tokenFile, content);
    }

    protected void splitParserAndLexerIfEnabled(IXtextGeneratorFileSystemAccess fsa, TypeReference parser, TypeReference lexer) {
        this.improveCodeQuality(fsa, lexer, parser);
        boolean _isClassSplitting = this.getOptions().isClassSplitting();
        if (_isClassSplitting) {
            this.splitLexerClassFile(fsa, lexer);
            this.splitParserClassFile(fsa, parser);
        }
    }

    protected void improveCodeQuality(IXtextGeneratorFileSystemAccess fsa, TypeReference lexer, TypeReference parser) {
        String lexerContent = fsa.readTextFile(lexer.getJavaPath()).toString();
        lexerContent = this.codeQualityHelper.stripUnnecessaryComments(lexerContent, this.options);
        fsa.generateFile(lexer.getJavaPath(), lexerContent);
        String parserContent = fsa.readTextFile(parser.getJavaPath()).toString();
        parserContent = this.codeQualityHelper.stripUnnecessaryComments(parserContent, this.options);
        parserContent = this.codeQualityHelper.removeDuplicateBitsets(parserContent, this.options);
        parserContent = this.codeQualityHelper.removeDuplicateDFAs(parserContent, this.options);
        fsa.generateFile(parser.getJavaPath(), parserContent);
    }

    protected void cleanupLexerTokensFile(AntlrGrammar lexerGrammar, KeywordHelper helper, IXtextGeneratorFileSystemAccess fsa) {
        try {
            boolean _isBacktrackLexer = this.options.isBacktrackLexer();
            if (_isBacktrackLexer) {
                MutableTokenDefProvider provider = this.createLexerTokensProvider(lexerGrammar, helper, fsa);
                Iterator entries = provider.getTokenDefMap().entrySet().iterator();
                while (entries.hasNext()) {
                    String value = (String)entries.next().getValue();
                    if (helper.isKeywordRule(value) || value.startsWith("RULE_") || value.startsWith("SUPER_")) continue;
                    entries.remove();
                }
                CharArrayWriter writer = new CharArrayWriter();
                PrintWriter _printWriter = new PrintWriter(writer);
                provider.writeTokenFile(_printWriter);
                String _tokensFileName = lexerGrammar.getTokensFileName();
                char[] _charArray = writer.toCharArray();
                String _string = new String(_charArray);
                fsa.generateFile(_tokensFileName, _string);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected MutableTokenDefProvider createLexerTokensProvider(AntlrGrammar lexerGrammar, KeywordHelper helper, IXtextGeneratorFileSystemAccess fsa) {
        Charset _forName = Charset.forName(this.codeConfig.getEncoding());
        MutableTokenDefProvider provider = new MutableTokenDefProvider(helper, _forName);
        IAntlrTokenFileProvider _function = () -> fsa.readBinaryFile(lexerGrammar.getTokensFileName());
        provider.setAntlrTokenFileProvider(_function);
        return provider;
    }

    protected void cleanupParserTokensFile(AntlrGrammar lexerGrammar, AntlrGrammar parserGrammar, KeywordHelper helper, IXtextGeneratorFileSystemAccess fsa) {
        try {
            MutableTokenDefProvider provider = this.createLexerTokensProvider(lexerGrammar, helper, fsa);
            Set _entrySet = provider.getTokenDefMap().entrySet();
            for (Map.Entry entry : _entrySet) {
                String value = (String)entry.getValue();
                boolean _isKeywordRule = helper.isKeywordRule(value);
                if (_isKeywordRule) {
                    String keywordAsAntlrString = AntlrGrammarGenUtil.toAntlrString(helper.getKeywordValue(value));
                    entry.setValue("'" + keywordAsAntlrString + "'");
                    continue;
                }
                boolean _startsWith = value.startsWith("'");
                if (!_startsWith) continue;
                String _antlrString = AntlrGrammarGenUtil.toAntlrString(value);
                String _plus = "'" + _antlrString;
                String _plus_1 = _plus + "'";
                entry.setValue(_plus_1);
            }
            CharArrayWriter writer = new CharArrayWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            provider.writeTokenFile(printWriter);
            String _tokensFileName = parserGrammar.getTokensFileName();
            char[] _charArray = writer.toCharArray();
            String _string = new String(_charArray);
            fsa.generateFile(_tokensFileName, _string);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void removeBackTrackingGuards(IXtextGeneratorFileSystemAccess fsa, TypeReference parser, int lookaheadThreshold) {
        String content = fsa.readTextFile(parser.getJavaPath()).toString();
        BacktrackingGuardRemover remover = new BacktrackingGuardRemover(content, lookaheadThreshold);
        String newContent = remover.transform();
        fsa.generateFile(parser.getJavaPath(), newContent);
    }

    protected boolean containsUnorderedGroup(Grammar grammar) {
        List _allParserRules = GrammarUtil.allParserRules((Grammar)grammar);
        for (ParserRule rule : _allParserRules) {
            boolean _hasNext = Iterators.filter((Iterator)rule.eAllContents(), UnorderedGroup.class).hasNext();
            if (!_hasNext) continue;
            return true;
        }
        return false;
    }

    @Pure
    protected AntlrToolFacade getAntlrTool() {
        return this.antlrTool;
    }

    @Pure
    protected AntlrCodeQualityHelper getCodeQualityHelper() {
        return this.codeQualityHelper;
    }

    @Pure
    protected LineSeparatorHarmonizer getNewLineNormalizer() {
        return this.newLineNormalizer;
    }

    @Pure
    protected CodeConfig getCodeConfig() {
        return this.codeConfig;
    }

    @Pure
    public AntlrOptions getOptions() {
        return this.options;
    }

    public void setOptions(AntlrOptions options) {
        this.options = options;
    }
}

