/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.serializer.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionDiffBuilder;
import org.eclipse.xtext.ide.serializer.IChangeSerializer;
import org.eclipse.xtext.ide.serializer.IEmfResourceChange;
import org.eclipse.xtext.ide.serializer.hooks.IResourceSnapshot;
import org.eclipse.xtext.ide.serializer.impl.EObjectDescriptionDeltaProvider;
import org.eclipse.xtext.ide.serializer.impl.RecordingEmfResourceUpdater;
import org.eclipse.xtext.ide.serializer.impl.RecordingResourceUpdater;
import org.eclipse.xtext.ide.serializer.impl.RecordingXtextResourceUpdater;
import org.eclipse.xtext.ide.serializer.impl.RelatedEmfResourceUpdater;
import org.eclipse.xtext.ide.serializer.impl.RelatedResourceUpdater;
import org.eclipse.xtext.ide.serializer.impl.RelatedResourcesProvider;
import org.eclipse.xtext.ide.serializer.impl.RelatedXtextResourceUpdater;
import org.eclipse.xtext.ide.serializer.impl.ResourceUpdater;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

public class ChangeSerializer
implements IChangeSerializer {
    @Inject
    private EObjectDescriptionDeltaProvider deltaProvider;
    @Inject
    private RelatedResourcesProvider relatedResourcesProvider;
    private ResourceSet resourceSet = null;
    private boolean updateCrossReferences = true;
    private boolean updateRelatedFiles = true;
    private IProgressMonitor monitor = new NullProgressMonitor();
    private Map<Resource, RecordingResourceUpdater> updaters = Maps.newLinkedHashMap();
    private List<Pair<Notifier, IChangeSerializer.IModification<? extends Notifier>>> modifications = Lists.newArrayList();
    private static final int additionalEffortInEndRecordChanges = 5;

    @Override
    public <T extends Notifier> void addModification(T context, IChangeSerializer.IModification<T> modification) {
        this.modifications.add((Pair<Notifier, IChangeSerializer.IModification<? extends Notifier>>)Tuples.create(context, modification));
    }

    @Override
    public void applyModifications(IAcceptor<IEmfResourceChange> changeAcceptor) {
        LinkedHashSet resources = Sets.newLinkedHashSet();
        for (Pair<Notifier, IChangeSerializer.IModification<? extends Notifier>> p : this.modifications) {
            Notifier context = (Notifier)p.getFirst();
            if (context instanceof EObject) {
                resources.add(((EObject)context).eResource());
                continue;
            }
            if (context instanceof Resource) {
                resources.add((Resource)context);
                continue;
            }
            if (!(context instanceof ResourceSet)) continue;
            throw new IllegalStateException("Not supported");
        }
        int weightedPrepareAndApplyEffort = 2 * resources.size() + this.modifications.size();
        int weightedCreateTextChangesEffort = 2 * resources.size() + 5;
        SubMonitor monitorInAll = SubMonitor.convert((IProgressMonitor)this.monitor, (int)(weightedPrepareAndApplyEffort + weightedCreateTextChangesEffort));
        SubMonitor monitorPrepareAndApply = SubMonitor.convert((IProgressMonitor)monitorInAll.split(weightedPrepareAndApplyEffort, 0), (String)"Preparing and applying file changes...", (int)weightedPrepareAndApplyEffort);
        for (Resource resource : resources) {
            monitorPrepareAndApply.split(2);
            this.beginRecordChanges(resource);
        }
        for (Pair pair : this.modifications) {
            monitorPrepareAndApply.split(1);
            this.apply((Notifier)pair.getFirst(), (IChangeSerializer.IModification)pair.getSecond());
        }
        SubMonitor monitorCreateTextChanges = monitorInAll.split(weightedCreateTextChangesEffort, 0);
        monitorCreateTextChanges.setWorkRemaining(weightedCreateTextChangesEffort);
        this.endRecordChanges(changeAcceptor, (IProgressMonitor)monitorCreateTextChanges);
    }

    protected <T extends Notifier> void apply(Notifier context, IChangeSerializer.IModification<T> modification) {
        modification.modify(context);
    }

    protected void beginRecordChanges(Resource resource) {
        RecordingResourceUpdater updater = this.updaters.get(resource);
        if (updater != null) {
            return;
        }
        if (this.resourceSet == null) {
            this.resourceSet = resource.getResourceSet();
        } else if (resource.getResourceSet() != this.resourceSet) {
            throw new IllegalStateException("Wrong ResourceSet.");
        }
        updater = this.createResourceUpdater(resource);
        this.updaters.put(resource, updater);
    }

    protected RelatedResourceUpdater createResourceUpdater(RelatedResourcesProvider.RelatedResource relatedResource) {
        URI uri = relatedResource.getUri();
        IGrammarAccess grammar = this.getService(uri, IGrammarAccess.class);
        RelatedResourceUpdater updater = grammar != null ? (RelatedResourceUpdater)this.getService(uri, RelatedXtextResourceUpdater.class) : (RelatedResourceUpdater)this.getService(uri, RelatedEmfResourceUpdater.class);
        updater.init(this, this.resourceSet, relatedResource);
        return updater;
    }

    protected RecordingResourceUpdater createResourceUpdater(Resource resource) {
        if (resource instanceof XtextResource) {
            RecordingXtextResourceUpdater updater = this.getService(resource, RecordingXtextResourceUpdater.class);
            updater.beginRecording(this, (XtextResource)resource);
            return updater;
        }
        RecordingEmfResourceUpdater updater = this.getService(resource, RecordingEmfResourceUpdater.class);
        updater.beginRecording(this, resource);
        return updater;
    }

    protected void endRecordChanges(IAcceptor<IEmfResourceChange> changeAcceptor) {
        this.endRecordChanges(changeAcceptor, null);
    }

    protected void endRecordChanges(IAcceptor<IEmfResourceChange> changeAcceptor, IProgressMonitor monitor) {
        if (this.updaters.isEmpty()) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)(monitor != null ? monitor : this.monitor), null, (int)(5 + 2 * this.updaters.size()));
        subMonitor.split(5);
        List<IResourceSnapshot> snapshots = this.getSnapshots();
        EObjectDescriptionDeltaProvider.Deltas deltas = this.deltaProvider.getDelta(this, snapshots);
        ArrayList updaters = Lists.newArrayList(this.updaters.values());
        if (this.updateRelatedFiles && this.updateCrossReferences) {
            List<RelatedResourcesProvider.RelatedResource> related = this.relatedResourcesProvider.getRelatedResources(deltas.getSnapshots());
            for (RelatedResourcesProvider.RelatedResource ref : related) {
                RelatedResourceUpdater updater = this.createResourceUpdater(ref);
                updaters.add(updater);
            }
        }
        subMonitor = SubMonitor.convert((IProgressMonitor)subMonitor, (String)"Creating text changes...", (int)updaters.size());
        for (ResourceUpdater updater : updaters) {
            subMonitor.split(1);
            updater.applyChange(deltas, changeAcceptor);
        }
        for (ResourceUpdater updater : updaters) {
            updater.unload();
        }
        subMonitor.done();
    }

    protected void resetState() {
        this.modifications.clear();
        this.updaters.clear();
        this.resourceSet = null;
    }

    @Override
    public ITextRegionDiffBuilder getModifiableDocument(Resource resource) {
        RecordingResourceUpdater updater = this.updaters.get(resource);
        if (updater instanceof RecordingXtextResourceUpdater) {
            return ((RecordingXtextResourceUpdater)updater).getDocument();
        }
        return null;
    }

    protected <T> T getService(Resource resource, Class<T> clazz) {
        if (resource instanceof XtextResource) {
            return (T)((XtextResource)resource).getResourceServiceProvider().get(clazz);
        }
        return this.getService(resource.getURI(), clazz);
    }

    protected <T> T getService(URI uri, Class<T> clazz) {
        return (T)IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(uri).get(clazz);
    }

    protected List<IResourceSnapshot> getSnapshots() {
        return this.updaters.values().stream().map(u -> u.getSnapshot()).collect(Collectors.toList());
    }

    @Override
    public boolean isUpdateCrossReferences() {
        return this.updateCrossReferences;
    }

    @Override
    public boolean isUpdateRelatedFiles() {
        return this.updateRelatedFiles;
    }

    @Override
    public void setUpdateCrossReferences(boolean value) {
        this.updateCrossReferences = value;
    }

    @Override
    public void setUpdateRelatedFiles(boolean value) {
        this.updateRelatedFiles = value;
    }

    @Override
    public void setProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }
}

