/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.outline;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.internal.ui.viewsupport.ColoringLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.ide.common.outline.IXtendOutlineContext;
import org.eclipse.xtend.ide.common.outline.IXtendOutlineNodeBuilder;
import org.eclipse.xtend.ide.common.outline.IXtendOutlineTreeBuilder;
import org.eclipse.xtend.ide.labeling.XtendImages;
import org.eclipse.xtend.ide.outline.EclipseXtendOutlineContext;
import org.eclipse.xtend.ide.outline.XtendEObjectNode;
import org.eclipse.xtend.ide.outline.XtendFeatureNode;
import org.eclipse.xtend.ide.outline.XtendOutlineModes;
import org.eclipse.xtend.ide.outline.XtendOutlineNodeFactory;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.IOutlineTreeProvider;
import org.eclipse.xtext.ui.editor.outline.impl.BackgroundOutlineTreeProvider;
import org.eclipse.xtext.ui.editor.outline.impl.DocumentRootNode;
import org.eclipse.xtext.ui.editor.outline.impl.EObjectNode;
import org.eclipse.xtext.ui.editor.outline.impl.EStructuralFeatureNode;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeExtensions;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedFeature;
import org.eclipse.xtext.xbase.ui.labeling.XbaseImageAdornments;
import org.eclipse.xtext.xtype.XtypePackage;

public abstract class AbstractMultiModeOutlineTreeProvider
extends BackgroundOutlineTreeProvider
implements IXtendOutlineNodeBuilder {
    @Inject
    private XtendImages images;
    @Inject
    private XbaseImageAdornments adornments;
    @Inject
    private IXtendJvmAssociations associations;
    @Inject
    private JvmTypeExtensions typeExtensions;
    private IOutlineTreeProvider.ModeAware modeAware;
    private IXtendOutlineTreeBuilder xtendOutlineTreeBuilder;

    public void internalCreateChildren(DocumentRootNode parentNode, EObject modelElement) {
        IXtendOutlineContext context = this.newContext((IOutlineNode)parentNode);
        this.xtendOutlineTreeBuilder.build(modelElement, context);
    }

    protected void internalCreateChildren(IOutlineNode parentNode, EObject modelElement) {
        IXtendOutlineContext context = this.newContext(parentNode);
        this.xtendOutlineTreeBuilder.build(modelElement, context);
    }

    protected abstract IXtendOutlineContext newContext(IOutlineNode var1);

    public IXtendOutlineContext buildEObjectNode(EObject modelElement, IXtendOutlineContext context) {
        EclipseXtendOutlineContext eclipseXtendOutlineContext = (EclipseXtendOutlineContext)context;
        IOutlineNode parentNode = eclipseXtendOutlineContext.getParentNode();
        EObjectNode node = this.createNode(parentNode, modelElement);
        return eclipseXtendOutlineContext.withParentNode((IOutlineNode)node);
    }

    public IXtendOutlineContext buildXtendNode(EObject modelElement, IXtendOutlineContext context) {
        EclipseXtendOutlineContext eclipseXtendOutlineContext = (EclipseXtendOutlineContext)context;
        IOutlineNode parentNode = eclipseXtendOutlineContext.getParentNode();
        int inheritanceDepth = eclipseXtendOutlineContext.getInheritanceDepth();
        XtendEObjectNode xtendNode = this.createXtendNode(parentNode, modelElement, inheritanceDepth);
        return eclipseXtendOutlineContext.withParentNode((IOutlineNode)xtendNode);
    }

    public IXtendOutlineContext buildFeatureNode(JvmDeclaredType inferredType, EObject semanticFeature, IXtendOutlineContext context) {
        EclipseXtendOutlineContext eclipseXtendOutlineContext = (EclipseXtendOutlineContext)context;
        IOutlineNode parentNode = eclipseXtendOutlineContext.getParentNode();
        int inheritanceDepth = eclipseXtendOutlineContext.getInheritanceDepth();
        XtendFeatureNode featureNode = this.createNodeForFeature(parentNode, inferredType, semanticFeature, inheritanceDepth);
        return eclipseXtendOutlineContext.withParentNode((IOutlineNode)featureNode);
    }

    public IXtendOutlineContext buildDispatcherNode(JvmDeclaredType baseType, JvmFeature dispatcher, List<JvmOperation> dispatchCases, IXtendOutlineContext context) {
        EclipseXtendOutlineContext eclipseXtendOutlineContext = (EclipseXtendOutlineContext)context;
        IOutlineNode parentNode = eclipseXtendOutlineContext.getParentNode();
        int inheritanceDepth = eclipseXtendOutlineContext.getInheritanceDepth();
        XtendFeatureNode dispatcherNode = this.createNodeForFeature(parentNode, baseType, (EObject)dispatcher, inheritanceDepth);
        dispatcherNode.setDispatch(true);
        if (this.isInheritsDispatchCases(baseType, dispatchCases)) {
            dispatcherNode.setImageDescriptor(this.images.forDispatcherFunction(dispatcher.getVisibility(), this.adornments.get((JvmIdentifiableElement)dispatcher) | 0x80));
        }
        return eclipseXtendOutlineContext.withParentNode((IOutlineNode)dispatcherNode);
    }

    public IXtendOutlineContext buildPackageNode(XtendFile xtendFile, IXtendOutlineContext context) {
        EclipseXtendOutlineContext eclipseXtendOutlineContext = (EclipseXtendOutlineContext)context;
        IOutlineNode parentNode = eclipseXtendOutlineContext.getParentNode();
        String primaryPackage = xtendFile.getPackage();
        EStructuralFeatureNode node = this.getOutlineNodeFactory().createEStructuralFeatureNode(parentNode, (EObject)xtendFile, (EStructuralFeature)XtendPackage.Literals.XTEND_FILE__PACKAGE, this.images.forPackage(), primaryPackage, true);
        return eclipseXtendOutlineContext.withParentNode((IOutlineNode)node);
    }

    public IXtendOutlineContext buildImportSectionNode(XtendFile xtendFile, IXtendOutlineContext context) {
        EclipseXtendOutlineContext eclipseXtendOutlineContext = (EclipseXtendOutlineContext)context;
        IOutlineNode parentNode = eclipseXtendOutlineContext.getParentNode();
        EStructuralFeatureNode node = this.getOutlineNodeFactory().createEStructuralFeatureNode(parentNode, (EObject)xtendFile.getImportSection(), (EStructuralFeature)XtypePackage.Literals.XIMPORT_SECTION__IMPORT_DECLARATIONS, this.images.forImportContainer(), "import declarations", false);
        return eclipseXtendOutlineContext.withParentNode((IOutlineNode)node);
    }

    public IXtendOutlineContext buildResolvedFeatureNode(JvmDeclaredType inferredType, IResolvedFeature resolvedFeature, IXtendOutlineContext context) {
        EclipseXtendOutlineContext eclipseXtendOutlineContext = (EclipseXtendOutlineContext)context;
        IOutlineNode parentNode = eclipseXtendOutlineContext.getParentNode();
        int inheritanceDepth = eclipseXtendOutlineContext.getInheritanceDepth();
        XtendFeatureNode node = this.createNodeForResolvedFeature(parentNode, inferredType, resolvedFeature, inheritanceDepth);
        return eclipseXtendOutlineContext.withParentNode((IOutlineNode)node);
    }

    protected boolean isInheritsDispatchCases(JvmDeclaredType baseType, List<JvmOperation> dispatchCases) {
        for (JvmOperation dispatchCase : dispatchCases) {
            if (dispatchCase.getDeclaringType() == baseType) continue;
            return true;
        }
        return false;
    }

    protected XtendFeatureNode createNodeForFeature(IOutlineNode parentNode, JvmDeclaredType inferredType, EObject featureElement, int inheritanceDepth) {
        boolean synthetic = false;
        if (featureElement instanceof JvmFeature) {
            synthetic = this.typeExtensions.isSynthetic((JvmIdentifiableElement)featureElement);
        }
        Object text = this.computeDecoratedText(featureElement, inheritanceDepth);
        ImageDescriptor image = this.getImageDescriptor(featureElement);
        if (this.isShowInherited()) {
            return this.getOutlineNodeFactory().createXtendFeatureNode(parentNode, featureElement, image, text, true, synthetic, inheritanceDepth);
        }
        return this.getOutlineNodeFactory().createXtendFeatureNode(parentNode, featureElement, image, text, true, synthetic, inheritanceDepth);
    }

    protected XtendFeatureNode createNodeForResolvedFeature(IOutlineNode parentNode, JvmDeclaredType inferredType, IResolvedFeature feature, int inheritanceDepth) {
        boolean synthetic = this.typeExtensions.isSynthetic((JvmIdentifiableElement)feature.getDeclaration());
        Object text = this.computeDecoratedText(feature, inheritanceDepth);
        ImageDescriptor image = this.getImageDescriptor(feature);
        return this.getOutlineNodeFactory().createXtendFeatureNode(parentNode, (EObject)feature.getDeclaration(), image, text, true, synthetic, inheritanceDepth);
    }

    protected boolean isShowInherited() {
        if (this.modeAware != null) {
            return this.modeAware.getCurrentMode() == XtendOutlineModes.SHOW_INHERITED_MODE;
        }
        return false;
    }

    protected boolean isLeaf(EObject modelElement) {
        if (modelElement instanceof JvmDeclaredType) {
            return ((JvmDeclaredType)modelElement).getMembers().isEmpty();
        }
        if (modelElement instanceof XtendTypeDeclaration) {
            return ((XtendTypeDeclaration)modelElement).getMembers().isEmpty();
        }
        return super.isLeaf(modelElement);
    }

    protected XtendEObjectNode createXtendNode(IOutlineNode parentNode, EObject modelElement, int inheritanceDepth) {
        Object text = this.computeDecoratedText(modelElement, inheritanceDepth);
        ImageDescriptor image = this.getImageDescriptor(modelElement);
        XtendEObjectNode objectNode = this.getOutlineNodeFactory().createXtendEObjectNode(parentNode, modelElement, image, text, true, inheritanceDepth);
        return objectNode;
    }

    protected Object computeDecoratedText(Object modelElement, int inheritanceDepth) {
        Object supertext = super.getText(modelElement);
        if (!(supertext instanceof StyledString)) {
            return supertext;
        }
        StyledString styledText = (StyledString)supertext;
        if (inheritanceDepth > 0) {
            styledText = this.applyStylerToFirstSegment(styledText, ColoringLabelProvider.INHERITED_STYLER);
        }
        if (modelElement instanceof JvmIdentifiableElement) {
            JvmIdentifiableElement jvmElement = (JvmIdentifiableElement)modelElement;
            if (!this.getAssociations().getSourceElements((EObject)jvmElement).isEmpty() && !this.getAssociations().isPrimaryJvmElement((EObject)jvmElement)) {
                styledText = this.applyStylerToFirstSegment(styledText, StyledString.QUALIFIER_STYLER);
            }
        }
        if (this.isShowInherited()) {
            String qualifier;
            if (modelElement instanceof IResolvedFeature) {
                qualifier = this.createQualifier((IResolvedFeature)modelElement);
                this.appendQualifier(styledText, qualifier);
            } else if (modelElement instanceof JvmMember) {
                qualifier = this.createQualifier((JvmMember)modelElement);
                this.appendQualifier(styledText, qualifier);
            } else if (modelElement instanceof XtendMember) {
                XtendMember xtendMember = (XtendMember)modelElement;
                if (xtendMember.eContainer() instanceof XtendTypeDeclaration) {
                    String qualifiedName = this.createQualifier((XtendTypeDeclaration)xtendMember.eContainer(), '.');
                    this.appendQualifier(styledText, qualifiedName);
                } else if (xtendMember instanceof XtendTypeDeclaration) {
                    XtendFile xtendFile = (XtendFile)EcoreUtil2.getContainerOfType((EObject)xtendMember, XtendFile.class);
                    String qualifiedName = xtendFile.getPackage() == null ? "(default package)" : xtendFile.getPackage();
                    this.appendQualifier(styledText, qualifiedName);
                }
            }
        }
        return styledText;
    }

    private void appendQualifier(StyledString styledText, String qualifier) {
        if (qualifier != null) {
            styledText.append(" - " + qualifier, StyledString.QUALIFIER_STYLER);
        }
    }

    private StyledString applyStylerToFirstSegment(StyledString styledText, StyledString.Styler styler) {
        if (styledText.getStyleRanges().length > 0) {
            StyleRange textStyle = styledText.getStyleRanges()[0];
            if (textStyle.start != 0) {
                styledText.setStyle(0, textStyle.start, styler);
            } else {
                styledText.setStyle(0, textStyle.length, styler);
            }
        } else {
            styledText = new StyledString(styledText.getString(), styler);
        }
        return styledText;
    }

    private String createQualifier(JvmMember jvmMember) {
        String qualifier = null;
        if (jvmMember instanceof JvmFeature) {
            JvmDeclaredType declaringType = jvmMember.getDeclaringType();
            qualifier = this.getPackageFreeNameForType(declaringType);
        } else if (jvmMember instanceof JvmDeclaredType) {
            JvmDeclaredType jvmDeclaredType;
            qualifier = jvmMember.eContainer() instanceof JvmDeclaredType ? this.getPackageFreeNameForType((JvmDeclaredType)jvmMember.eContainer()) : (Strings.isNullOrEmpty((String)(jvmDeclaredType = (JvmDeclaredType)jvmMember).getPackageName()) ? "(default package)" : jvmDeclaredType.getPackageName());
        }
        return qualifier;
    }

    private String getPackageFreeNameForType(JvmDeclaredType declaringType) {
        Object qualifier = declaringType.getSimpleName();
        while (declaringType.eContainer() instanceof JvmDeclaredType) {
            declaringType = (JvmDeclaredType)declaringType.eContainer();
            qualifier = declaringType.getSimpleName() + "." + (String)qualifier;
        }
        return qualifier;
    }

    private String createQualifier(IResolvedFeature feature) {
        String qualifier = feature.getContextType().getHumanReadableName();
        return qualifier;
    }

    private String createQualifier(XtendTypeDeclaration xtendType, char innerClassDelimiter) {
        if (xtendType.getName() == null) {
            return null;
        }
        XtendTypeDeclaration declaringType = null;
        if (xtendType.eContainer() instanceof XtendTypeDeclaration) {
            declaringType = (XtendTypeDeclaration)xtendType.eContainer();
        }
        if (declaringType == null) {
            return xtendType.getName();
        }
        Object qualifier = xtendType.getName();
        while (xtendType.eContainer() instanceof XtendTypeDeclaration) {
            XtendTypeDeclaration parent = (XtendTypeDeclaration)xtendType.eContainer();
            qualifier = parent.getName() + innerClassDelimiter + (String)qualifier;
            xtendType = parent;
        }
        return qualifier;
    }

    protected XtendOutlineNodeFactory getOutlineNodeFactory() {
        return (XtendOutlineNodeFactory)super.getOutlineNodeFactory();
    }

    protected IXtendJvmAssociations getAssociations() {
        return this.associations;
    }

    public void setModeAware(IOutlineTreeProvider.ModeAware modeAware) {
        this.modeAware = modeAware;
    }

    public void setXtendOutlineTreeBuilder(IXtendOutlineTreeBuilder xtendOutlineTreeBuilder) {
        this.xtendOutlineTreeBuilder = xtendOutlineTreeBuilder;
    }
}

