/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.javaconverter;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.xtend.core.javaconverter.JavaASTFlattener;
import org.eclipse.xtend.core.javaconverter.JavaCodeAnalyzer;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.ui.util.ClipboardUtil;
import org.eclipse.xtext.xbase.conversion.IJavaCodeConverter;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

public class JavaConverter
implements IJavaCodeConverter {
    @Inject
    private JavaCodeAnalyzer javaAnalyzer;
    @Inject
    private Provider<JavaASTFlattener> astFlattenerProvider;
    private boolean fallbackConversionStartegy = false;

    public ConversionResult toXtend(ICompilationUnit cu) {
        try {
            ASTParser parser = this.javaAnalyzer.createDefaultJavaParser();
            parser.setStatementsRecovery(true);
            parser.setResolveBindings(true);
            parser.setBindingsRecovery(true);
            parser.setSource(cu);
            ASTNode root = parser.createAST(null);
            String _source = cu.getSource();
            Set<ASTNode> _singleton = Collections.singleton(root);
            return this.executeAstFlattener(_source, _singleton);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public ConversionResult toXtend(String unitName, String javaSrc) {
        ConversionResult _xblockexpression = null;
        boolean _equals = Objects.equal((Object)unitName, null);
        if (_equals) {
            throw new IllegalArgumentException();
        }
        _xblockexpression = this.internalToXtend(unitName, javaSrc, null, null);
        return _xblockexpression;
    }

    public ConversionResult bodyDeclarationToXtend(String javaSrc, ClipboardUtil.JavaImportData additionalImports, IJavaProject project) {
        return this.internalToXtend(null, javaSrc, additionalImports, project);
    }

    public ConversionResult statementToXtend(String javaSrc) {
        ASTParser parser = this.javaAnalyzer.createDefaultJavaParser();
        char[] _charArray = javaSrc.toCharArray();
        parser.setSource(_charArray);
        parser.setKind(2);
        ASTNode root = parser.createAST(null);
        if (root instanceof Block) {
            List statements = ((Block)root).statements();
            return this.executeAstFlattener(javaSrc, statements);
        }
        Set<ASTNode> _singleton = Collections.singleton(root);
        return this.executeAstFlattener(javaSrc, _singleton);
    }

    public ConversionResult expressionToXtend(String javaSrc) {
        ASTParser parser = this.javaAnalyzer.createDefaultJavaParser();
        char[] _charArray = javaSrc.toCharArray();
        parser.setSource(_charArray);
        parser.setKind(1);
        ASTNode root = parser.createAST(null);
        Set<ASTNode> _singleton = Collections.singleton(root);
        return this.executeAstFlattener(javaSrc, _singleton);
    }

    private ConversionResult internalToXtend(String unitName, String javaSrc, ClipboardUtil.JavaImportData additionalImports, IJavaProject proj) {
        boolean _equals;
        boolean _notEquals_1;
        boolean _notEquals;
        ASTParser parser = this.javaAnalyzer.createDefaultJavaParser();
        parser.setStatementsRecovery(true);
        parser.setResolveBindings(true);
        parser.setBindingsRecovery(true);
        boolean bl = _notEquals = !Objects.equal((Object)proj, null);
        if (_notEquals) {
            parser.setProject(proj);
        } else {
            ClassLoader sysClassLoader = ClassLoader.getSystemClassLoader();
            URL[] _uRLs = ((URLClassLoader)sysClassLoader).getURLs();
            Functions.Function1<URL, String> _function = new Functions.Function1<URL, String>(){

                public String apply(URL it) {
                    return it.getFile();
                }
            };
            List cpEntries = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)_uRLs)), (Functions.Function1)_function);
            parser.setEnvironment((String[])Conversions.unwrapArray((Object)cpEntries, String.class), null, null, true);
        }
        final StringBuilder javaSrcBuilder = new StringBuilder();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)additionalImports, null);
        if (_notEquals_1) {
            String[] _imports = additionalImports.getImports();
            Procedures.Procedure1<String> _function_1 = new Procedures.Procedure1<String>(){

                public void apply(String it) {
                    javaSrcBuilder.append("import " + it + ";");
                }
            };
            IterableExtensions.forEach((Iterable)((Iterable)Conversions.doWrapArray((Object)_imports)), (Procedures.Procedure1)_function_1);
        }
        if (_equals = Objects.equal((Object)unitName, null)) {
            parser.setUnitName("MISSING");
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"class MISSING { ");
            _builder.append((Object)javaSrc, "");
            _builder.append((Object)"}");
            javaSrcBuilder.append((CharSequence)_builder);
        } else {
            parser.setUnitName(unitName);
            javaSrcBuilder.append(javaSrc);
        }
        parser.setKind(8);
        String preparedJavaSrc = javaSrcBuilder.toString();
        char[] _charArray = preparedJavaSrc.toCharArray();
        parser.setSource(_charArray);
        ASTNode result = parser.createAST(null);
        Set<ASTNode> _singleton = Collections.singleton(result);
        return this.executeAstFlattener(preparedJavaSrc, _singleton);
    }

    private ConversionResult executeAstFlattener(String preparedJavaSource, Collection<? extends ASTNode> parseResult) {
        JavaASTFlattener astFlattener = (JavaASTFlattener)((Object)this.astFlattenerProvider.get());
        astFlattener.useFallBackStrategy(this.fallbackConversionStartegy);
        astFlattener.setJavaSources(preparedJavaSource);
        for (ASTNode aSTNode : parseResult) {
            aSTNode.accept((ASTVisitor)astFlattener);
        }
        return ConversionResult.create(astFlattener);
    }

    public JavaConverter useRobustSyntax() {
        this.fallbackConversionStartegy = true;
        return this;
    }

    public boolean isCompatibleTargetObject(String javaToConvert, EObject targetElement) {
        return false;
    }

    @Accessors(value={AccessorType.PUBLIC_GETTER})
    public static class ConversionResult {
        private String xtendCode;
        private Iterable<String> problems = CollectionLiterals.newArrayList((Object[])new String[0]);

        public static ConversionResult create(JavaASTFlattener flattener) {
            boolean _notEquals;
            String _result;
            ConversionResult result = new ConversionResult();
            result.xtendCode = _result = flattener.getResult();
            List<String> _problems = flattener.getProblems();
            boolean bl = _notEquals = !Objects.equal(_problems, null);
            if (_notEquals) {
                List<String> _problems_1 = flattener.getProblems();
                result.problems = _problems_1;
            }
            return result;
        }

        @Pure
        public String getXtendCode() {
            return this.xtendCode;
        }

        @Pure
        public Iterable<String> getProblems() {
            return this.problems;
        }
    }
}

