/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.nodemodel.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.nodemodel.BidiIterable;
import org.eclipse.xtext.nodemodel.BidiTreeIterator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.AbstractNode;
import org.eclipse.xtext.nodemodel.impl.BasicNodeIterable;
import org.eclipse.xtext.nodemodel.impl.CompositeNodeWithSemanticElement;
import org.eclipse.xtext.nodemodel.impl.CompositeNodeWithSemanticElementAndSyntaxError;
import org.eclipse.xtext.nodemodel.impl.CompositeNodeWithSyntaxError;
import org.eclipse.xtext.nodemodel.impl.HiddenLeafNode;
import org.eclipse.xtext.nodemodel.impl.HiddenLeafNodeWithSyntaxError;
import org.eclipse.xtext.nodemodel.impl.LeafNode;
import org.eclipse.xtext.nodemodel.impl.LeafNodeWithSyntaxError;
import org.eclipse.xtext.nodemodel.impl.RootNode;
import org.eclipse.xtext.nodemodel.impl.SyntheticCompositeNode;
import org.eclipse.xtext.nodemodel.serialization.DeserializationConversionContext;
import org.eclipse.xtext.nodemodel.serialization.SerializationConversionContext;
import org.eclipse.xtext.nodemodel.serialization.SerializationUtil;
import org.eclipse.xtext.nodemodel.util.EmptyBidiIterable;
import org.eclipse.xtext.nodemodel.util.NodeIterable;
import org.eclipse.xtext.nodemodel.util.SingletonBidiIterable;

public class CompositeNode
extends AbstractNode
implements ICompositeNode {
    private AbstractNode firstChild;
    private int lookAhead;
    private static final AbstractNode.NodeType[] NODE_TYPE_VALUES = AbstractNode.NodeType.values();

    @Override
    public BidiIterable<INode> getChildren() {
        if (this.hasChildren()) {
            INode firstChild = this.getFirstChild();
            if (firstChild.hasSiblings()) {
                return new NodeIterable(firstChild);
            }
            return SingletonBidiIterable.create(firstChild);
        }
        return EmptyBidiIterable.instance();
    }

    public BidiIterable<AbstractNode> basicGetChildren() {
        if (this.firstChild != null) {
            if (this.firstChild.hasSiblings()) {
                return new BasicNodeIterable(this.firstChild);
            }
            return SingletonBidiIterable.create(this.basicGetFirstChild());
        }
        return EmptyBidiIterable.instance();
    }

    @Override
    public boolean hasChildren() {
        return this.firstChild != null || this.isFolded();
    }

    @Override
    public int getLookAhead() {
        return this.lookAhead;
    }

    @Override
    public int getTotalLength() {
        if (this.firstChild != null) {
            int offset = this.firstChild.getTotalOffset();
            AbstractNode lastChild = this.firstChild.basicGetPreviousSibling();
            return lastChild.getTotalOffset() + lastChild.getTotalLength() - offset;
        }
        return 0;
    }

    @Override
    public int getTotalOffset() {
        if (this.firstChild != null) {
            return this.firstChild.getTotalOffset();
        }
        CompositeNode compositeWithSiblings = this;
        while (!compositeWithSiblings.basicHasNextSibling() && compositeWithSiblings.basicGetParent() != null) {
            compositeWithSiblings = compositeWithSiblings.basicGetParent();
        }
        if (compositeWithSiblings.basicHasNextSibling()) {
            AbstractNode sibling = compositeWithSiblings.basicGetNextSibling();
            return sibling.getTotalOffset();
        }
        BidiTreeIterator<INode> iter = this.getRootNode().getAsTreeIterable().iterator();
        INode lastSeen = null;
        while (iter.hasNext()) {
            INode next = iter.next();
            if (next == this) {
                if (lastSeen == null) {
                    return 0;
                }
                return lastSeen.getTotalEndOffset();
            }
            if (!(next instanceof ILeafNode)) continue;
            lastSeen = (ILeafNode)next;
        }
        return 0;
    }

    protected void basicSetLookAhead(int lookAhead) {
        this.lookAhead = lookAhead;
    }

    @Override
    public INode getFirstChild() {
        if (this.isFolded()) {
            return new SyntheticCompositeNode(this, 1);
        }
        return this.firstChild;
    }

    protected AbstractNode basicGetFirstChild() {
        return this.firstChild;
    }

    protected void basicSetFirstChild(AbstractNode firstChild) {
        this.firstChild = firstChild;
    }

    @Override
    public INode getLastChild() {
        if (this.isFolded()) {
            return new SyntheticCompositeNode(this, 1);
        }
        return this.basicGetLastChild();
    }

    protected AbstractNode basicGetLastChild() {
        if (this.firstChild == null) {
            return null;
        }
        return this.firstChild.basicGetPreviousSibling();
    }

    protected boolean isFolded() {
        Object grammarElementOrArray = this.basicGetGrammarElement();
        return this.isFolded(grammarElementOrArray);
    }

    protected boolean isFolded(Object grammarElementOrArray) {
        return grammarElementOrArray != null && !(grammarElementOrArray instanceof EObject);
    }

    public ICompositeNode resolveAsParent() {
        Object grammarElementOrArray = this.basicGetGrammarElement();
        if (!this.isFolded()) {
            return this;
        }
        EObject[] grammarElements = (EObject[])grammarElementOrArray;
        return new SyntheticCompositeNode(this, grammarElements.length - 1);
    }

    @Override
    public EObject getGrammarElement() {
        Object grammarElementOrArray = this.basicGetGrammarElement();
        if (!this.isFolded()) {
            return (EObject)grammarElementOrArray;
        }
        EObject[] grammarElements = (EObject[])grammarElementOrArray;
        return grammarElements[0];
    }

    @Override
    void readData(DataInputStream in, DeserializationConversionContext context) throws IOException {
        super.readData(in, context);
        int childNodeCount = SerializationUtil.readInt(in, true);
        if (childNodeCount > 0) {
            AbstractNode child = null;
            AbstractNode prevChild = null;
            int i = 0;
            while (i < childNodeCount) {
                int nodeId = SerializationUtil.readInt(in, true);
                AbstractNode.NodeType nodeType = NODE_TYPE_VALUES[nodeId];
                child = this.createChildNode(nodeType);
                child.readData(in, context);
                if (this.firstChild == null) {
                    this.firstChild = child;
                }
                child.basicSetParent(this);
                child.basicSetPreviousSibling(prevChild);
                prevChild = child;
                ++i;
            }
            this.firstChild.basicSetPreviousSibling(child);
            child = this.firstChild.basicGetPreviousSibling();
            prevChild = this.firstChild;
            while (child != this.firstChild) {
                child.basicSetNextSibling(prevChild);
                prevChild = child;
                child = child.basicGetPreviousSibling();
            }
            this.firstChild.basicSetNextSibling(prevChild);
        }
        this.lookAhead = SerializationUtil.readInt(in, true);
    }

    private AbstractNode createChildNode(AbstractNode.NodeType type) {
        switch (type) {
            case CompositeNode: {
                return new CompositeNode();
            }
            case CompositeNodeWithSemanticElement: {
                return new CompositeNodeWithSemanticElement();
            }
            case CompositeNodeWithSemanticElementAndSyntaxError: {
                return new CompositeNodeWithSemanticElementAndSyntaxError();
            }
            case CompositeNodeWithSyntaxError: {
                return new CompositeNodeWithSyntaxError();
            }
            case HiddenLeafNode: {
                return new HiddenLeafNode();
            }
            case HiddenLeafNodeWithSyntaxError: {
                return new HiddenLeafNodeWithSyntaxError();
            }
            case LeafNode: {
                return new LeafNode();
            }
            case LeafNodeWithSyntaxError: {
                return new LeafNodeWithSyntaxError();
            }
            case RootNode: {
                return new RootNode();
            }
        }
        throw new IllegalArgumentException("Trying to construct a non-existing INode");
    }

    @Override
    void write(DataOutputStream out, SerializationConversionContext scc) throws IOException {
        super.write(out, scc);
        int childNodeCount = this.getChildCount();
        SerializationUtil.writeInt(out, childNodeCount, true);
        AbstractNode it = this.firstChild;
        int i = 0;
        while (i < childNodeCount) {
            SerializationUtil.writeInt(out, it.getNodeId().ordinal(), true);
            it.write(out, scc);
            it = it.basicGetNextSibling();
            ++i;
        }
        SerializationUtil.writeInt(out, this.lookAhead, true);
    }

    private int getChildCount() {
        if (this.firstChild == null) {
            return 0;
        }
        AbstractNode it = this.firstChild;
        int count = 0;
        do {
            ++count;
        } while ((it = it.basicGetNextSibling()) != this.firstChild);
        return count;
    }

    @Override
    int fillGrammarElementToIdMap(int currentId, Map<EObject, Integer> grammarElementToIdMap, List<String> grammarIdToURIMap) {
        currentId = super.fillGrammarElementToIdMap(currentId, grammarElementToIdMap, grammarIdToURIMap);
        if (this.firstChild != null) {
            AbstractNode it = this.firstChild;
            do {
                currentId = it.fillGrammarElementToIdMap(currentId, grammarElementToIdMap, grammarIdToURIMap);
            } while ((it = it.basicGetNextSibling()) != this.firstChild);
        }
        return currentId;
    }

    @Override
    AbstractNode.NodeType getNodeId() {
        return AbstractNode.NodeType.CompositeNode;
    }
}

