/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.wizard.project;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xpand2.XpandExecutionContextImpl;
import org.eclipse.xpand2.XpandFacade;
import org.eclipse.xpand2.output.Outlet;
import org.eclipse.xpand2.output.Output;
import org.eclipse.xpand2.output.OutputImpl;
import org.eclipse.xtend.type.impl.java.JavaBeansMetaModel;
import org.eclipse.xtend.typesystem.MetaModel;
import org.eclipse.xtext.ui.util.PluginProjectFactory;
import org.eclipse.xtext.ui.util.ProjectFactory;
import org.eclipse.xtext.ui.wizard.AbstractProjectCreator;
import org.eclipse.xtext.xtext.ui.wizard.project.Messages;
import org.eclipse.xtext.xtext.ui.wizard.project.XtextProjectInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtextProjectCreator
extends AbstractProjectCreator {
    protected static final String[] DSL_PROJECT_NATURES = new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.pde.PluginNature", "org.eclipse.xtext.ui.shared.xtextNature"};
    protected static final String[] DSL_UI_PROJECT_NATURES = new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.pde.PluginNature"};
    protected static final String[] BUILDERS = new String[]{"org.eclipse.jdt.core.javabuilder", "org.eclipse.pde.ManifestBuilder", "org.eclipse.pde.SchemaBuilder", "org.eclipse.xtext.ui.shared.xtextBuilder"};
    protected static final String[] GENERATOR_PROJECT_NATURES = DSL_UI_PROJECT_NATURES;
    protected static final String[] TEST_PROJECT_NATURES = DSL_UI_PROJECT_NATURES;
    protected static final String SRC_GEN_ROOT = "src-gen";
    protected static final String SRC_ROOT = "src";
    protected static final String XTEND_GEN_ROOT = "xtend-gen";
    protected static final List<String> SRC_FOLDER_LIST = ImmutableList.of((Object)"src", (Object)"src-gen");
    @Inject
    private Provider<PluginProjectFactory> projectFactoryProvider;

    protected XtextProjectInfo getXtextProjectInfo() {
        return (XtextProjectInfo)this.getProjectInfo();
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getCreateModelProjectMessage(), (int)this.getMonitorTicks());
        IProject project = this.createDslProject((IProgressMonitor)subMonitor.newChild(1));
        this.createDslUiProject((IProgressMonitor)subMonitor.newChild(1));
        if (this.getXtextProjectInfo().isCreateTestProject()) {
            this.createTestProject((IProgressMonitor)subMonitor.newChild(1));
        }
        IFile dslGrammarFile = project.getFile((IPath)new Path(String.valueOf(this.getModelFolderName()) + "/" + this.getXtextProjectInfo().getLanguageName().replace('.', '/') + ".xtext"));
        BasicNewResourceWizard.selectAndReveal((IResource)dslGrammarFile, (IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        this.setResult(dslGrammarFile);
    }

    protected int getMonitorTicks() {
        int ticks = 2;
        ticks = this.getXtextProjectInfo().isCreateTestProject() ? ticks + 1 : ticks;
        return ticks;
    }

    protected PluginProjectFactory createProjectFactory() {
        return (PluginProjectFactory)this.projectFactoryProvider.get();
    }

    protected String getCreateModelProjectMessage() {
        return String.valueOf(Messages.XtextProjectCreator_CreatingProjectsMessage2) + this.getXtextProjectInfo().getProjectName();
    }

    protected IProject createDslUiProject(IProgressMonitor monitor) throws CoreException {
        PluginProjectFactory factory = this.createProjectFactory();
        this.configureDslUiProjectFactory(factory);
        return this.createProject((ProjectFactory)factory, this.getDslUiProjectTemplateName(), monitor);
    }

    protected void configureDslUiProjectFactory(PluginProjectFactory factory) {
        this.configureProjectFactory((ProjectFactory)factory);
        List<String> requiredBundles = this.getDslUiProjectRequiredBundles();
        factory.setProjectName(this.getXtextProjectInfo().getUiProjectName());
        factory.addProjectNatures(this.getDslUiProjectNatures());
        factory.addRequiredBundles(requiredBundles);
        factory.setLocation(this.getXtextProjectInfo().getUiProjectLocation());
    }

    protected List<String> getDslUiProjectRequiredBundles() {
        ArrayList requiredBundles = Lists.newArrayList((Object[])new String[]{String.valueOf(this.getXtextProjectInfo().getProjectName()) + ";visibility:=reexport", "org.eclipse.xtext.ui", "org.eclipse.ui.editors;bundle-version=\"3.5.0\"", "org.eclipse.ui.ide;bundle-version=\"3.5.0\""});
        return requiredBundles;
    }

    protected String[] getDslUiProjectNatures() {
        return DSL_UI_PROJECT_NATURES;
    }

    protected IProject createDslProject(IProgressMonitor monitor) throws CoreException {
        PluginProjectFactory factory = this.createProjectFactory();
        this.configureDslProjectFactory(factory);
        return this.createProject((ProjectFactory)factory, this.getDslProjectTemplateName(), monitor);
    }

    protected void configureDslProjectFactory(PluginProjectFactory factory) {
        this.configureProjectFactory((ProjectFactory)factory);
        factory.addFolders(Collections.singletonList(XTEND_GEN_ROOT));
        List<String> requiredBundles = this.getDslProjectRequiredBundles();
        factory.setProjectName(this.getXtextProjectInfo().getProjectName());
        factory.addProjectNatures(this.getDslProjectNatures());
        factory.addRequiredBundles(requiredBundles);
        factory.setLocation(this.getXtextProjectInfo().getProjectLocation());
    }

    protected List<String> getDslProjectRequiredBundles() {
        String[] bundles;
        ArrayList requiredBundles = Lists.newArrayList((Object[])new String[]{"org.eclipse.xtext;bundle-version=\"2.0.0\";visibility:=reexport", "org.apache.log4j;bundle-version=\"1.2.15\";visibility:=reexport", "org.apache.commons.logging;bundle-version=\"1.0.4\";resolution:=optional;visibility:=reexport", "org.eclipse.xtext.generator;resolution:=optional", "org.eclipse.emf.codegen.ecore;resolution:=optional", "org.eclipse.emf.mwe.utils;resolution:=optional", "org.eclipse.emf.mwe2.launch;resolution:=optional"});
        String[] stringArray = bundles = this.getXtextProjectInfo().getWizardContribution().getRequiredBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            String bundleId = stringArray[n2];
            requiredBundles.add(String.valueOf(bundleId.trim()) + ";resolution:=optional");
            ++n2;
        }
        for (String bundleId : this.getAdditionalRequiredBundles()) {
            requiredBundles.add(bundleId.trim());
        }
        return requiredBundles;
    }

    protected String[] getDslProjectNatures() {
        return DSL_PROJECT_NATURES;
    }

    protected PluginProjectFactory configureProjectFactory(ProjectFactory factory) {
        PluginProjectFactory result = (PluginProjectFactory)factory;
        result.addWorkingSets(Arrays.asList(this.getXtextProjectInfo().getWorkingSets()));
        result.addBuilderIds(this.getBuilderIDs());
        result.addImportedPackages(this.getImportedPackages());
        result.addFolders(this.getAllFolders());
        return result;
    }

    protected String[] getBuilderIDs() {
        return BUILDERS;
    }

    protected String[] getTestProjectNatures() {
        return TEST_PROJECT_NATURES;
    }

    protected IProject createTestProject(IProgressMonitor monitor) throws CoreException {
        PluginProjectFactory factory = this.createProjectFactory();
        this.configureTestProjectBuilder(factory);
        return this.createProject((ProjectFactory)factory, this.getTestProjectTemplateName(), monitor);
    }

    protected void configureTestProjectBuilder(PluginProjectFactory factory) {
        this.configureProjectFactory((ProjectFactory)factory);
        List<String> requiredBundles = this.getTestProjectRequiredBundles();
        factory.setProjectName(this.getXtextProjectInfo().getTestProjectName());
        factory.addProjectNatures(this.getTestProjectNatures());
        factory.addRequiredBundles(requiredBundles);
        factory.setLocation(this.getXtextProjectInfo().getTestProjectLocation());
    }

    protected List<String> getTestProjectRequiredBundles() {
        ArrayList requiredBundles = Lists.newArrayList((Object[])new String[]{this.getXtextProjectInfo().getProjectName(), this.getXtextProjectInfo().getUiProjectName(), "org.eclipse.core.runtime", "org.eclipse.xtext", "org.eclipse.xtext.junit4", "org.eclipse.xtext.ui.junit", "org.junit4", "org.eclipse.ui.workbench;resolution:=optional"});
        return requiredBundles;
    }

    protected IProject createProject(ProjectFactory factory, String templateName, IProgressMonitor monitor) throws CoreException {
        IProject result = factory.createProject(monitor, null);
        if (result == null) {
            return null;
        }
        IFolder srcFolder = (IFolder)result.findMember(this.getModelFolderName());
        OutputImpl output = new OutputImpl();
        output.addOutlet(new Outlet(false, this.getEncoding(), null, true, srcFolder.getLocation().makeAbsolute().toOSString()));
        XpandExecutionContextImpl execCtx = new XpandExecutionContextImpl((Output)output, null);
        execCtx.getResourceManager().setFileEncoding("iso-8859-1");
        execCtx.registerMetaModel((MetaModel)new JavaBeansMetaModel());
        XpandFacade facade = XpandFacade.create((XpandExecutionContext)execCtx);
        facade.evaluate(templateName, (Object)this.getXtextProjectInfo(), new Object[0]);
        result.refreshLocal(2, monitor);
        return result;
    }

    protected String pathToTemplates() {
        return "org::eclipse::xtext::xtext::ui::wizard::project::";
    }

    protected String getDslProjectTemplateName() {
        return String.valueOf(this.pathToTemplates()) + "DslProject::main";
    }

    protected String getDslUiProjectTemplateName() {
        return String.valueOf(this.pathToTemplates()) + "DslUiProject::main";
    }

    protected String getGeneratorProjectTemplateName() {
        return String.valueOf(this.pathToTemplates()) + "GeneratorProject::main";
    }

    protected String getTestProjectTemplateName() {
        return String.valueOf(this.pathToTemplates()) + "TestProject::main";
    }

    protected List<String> getImportedPackages() {
        return Lists.newArrayList((Object[])new String[]{"org.apache.log4j", "org.apache.commons.logging"});
    }

    protected Collection<String> getAdditionalRequiredBundles() {
        return Collections.emptyList();
    }

    protected String getModelFolderName() {
        return SRC_ROOT;
    }

    protected List<String> getAllFolders() {
        return SRC_FOLDER_LIST;
    }
}

