/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.builderState;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.builder.builderState.IMarkerUpdater;
import org.eclipse.xtext.builder.builderState.Messages;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.ui.validation.IResourceUIValidatorExtension;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.validation.CheckMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerUpdaterImpl
implements IMarkerUpdater {
    @Inject
    private IResourceServiceProvider.Registry resourceServiceProviderRegistry;
    @Inject
    private IStorage2UriMapper mapper;

    @Override
    public void updateMarker(ResourceSet resourceSet, ImmutableList<IResourceDescription.Delta> resourceDescriptionDeltas, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.MarkerUpdaterImpl_ValidateResources, (int)resourceDescriptionDeltas.size());
        subMonitor.subTask(Messages.MarkerUpdaterImpl_ValidateResources);
        for (IResourceDescription.Delta delta : resourceDescriptionDeltas) {
            if (subMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            SubMonitor child = subMonitor.newChild(1);
            if (delta.getNew() != null) {
                URI uri = delta.getNew().getURI();
                Iterable storages = this.mapper.getStorages(uri);
                child.setWorkRemaining(3);
                for (Pair pair : storages) {
                    child.setWorkRemaining(3);
                    if (pair.getFirst() instanceof IFile) {
                        IResourceUIValidatorExtension resourceUIValidatorExtension = this.getResourceUIValidatorExtension(uri);
                        resourceUIValidatorExtension.updateValidationMarkers((IFile)pair.getFirst(), resourceSet.getResource(uri, true), CheckMode.NORMAL_AND_FAST, (IProgressMonitor)child.newChild(2));
                        continue;
                    }
                    child.worked(1);
                }
                continue;
            }
            Iterable storages = this.mapper.getStorages(delta.getOld().getURI());
            for (Pair pair : storages) {
                if (!(pair.getFirst() instanceof IFile)) continue;
                IResourceUIValidatorExtension resourceUIValidatorExtension = this.getResourceUIValidatorExtension(delta.getOld().getURI());
                resourceUIValidatorExtension.deleteValidationMarkers((IFile)pair.getFirst(), CheckMode.NORMAL_AND_FAST, (IProgressMonitor)child);
            }
            subMonitor.worked(1);
        }
    }

    protected IResourceUIValidatorExtension getResourceUIValidatorExtension(URI uri) {
        IResourceServiceProvider provider = this.resourceServiceProviderRegistry.getResourceServiceProvider(uri);
        IResourceUIValidatorExtension resourceUIValidatorExtension = (IResourceUIValidatorExtension)provider.get(IResourceUIValidatorExtension.class);
        return resourceUIValidatorExtension;
    }
}

