/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.codetemplates.ui.highlighting;

import com.google.inject.Inject;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.codetemplates.templates.Codetemplate;
import org.eclipse.xtext.ui.codetemplates.templates.Codetemplates;
import org.eclipse.xtext.ui.codetemplates.ui.evaluator.EvaluatedTemplate;
import org.eclipse.xtext.ui.codetemplates.ui.highlighting.TemplateBodyHighlighter;
import org.eclipse.xtext.ui.codetemplates.ui.registry.LanguageRegistry;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ui.editor.syntaxcoloring.ISemanticHighlightingCalculator;

public class SemanticHighlighter
implements ISemanticHighlightingCalculator {
    @Inject
    private LanguageRegistry registry;

    public void provideHighlightingFor(XtextResource resource, final IHighlightedPositionAcceptor acceptor) {
        TemplateBodyHighlighter highlighter;
        if (resource == null || resource.getContents().isEmpty()) {
            return;
        }
        Codetemplates templates = (Codetemplates)resource.getContents().get(0);
        Grammar grammar = templates.getLanguage();
        if (grammar != null && !grammar.eIsProxy() && (highlighter = this.getHighlighter(grammar)) != null) {
            for (Codetemplate template : templates.getTemplates()) {
                if (template.getBody() == null) continue;
                final EvaluatedTemplate evaluatedTemplate = new EvaluatedTemplate(template);
                highlighter.provideHighlightingFor(evaluatedTemplate.getMappedString(), new IHighlightedPositionAcceptor(){

                    public void addPosition(int offset, int length, String ... id) {
                        int beginOffset = evaluatedTemplate.getOriginalOffset(offset);
                        int endOffset = evaluatedTemplate.getOriginalOffset(offset + length);
                        int fixedLength = endOffset - beginOffset;
                        acceptor.addPosition(beginOffset, fixedLength, id);
                    }
                });
            }
        }
    }

    protected TemplateBodyHighlighter getHighlighter(Grammar grammar) {
        return this.registry.getTemplateBodyHighlighter(grammar);
    }
}

