/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.model;

import com.google.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.xtext.resource.IExternalContentSupport;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IResourceForEditorInputFactory;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

public class ResourceForIEditorInputFactory
implements IResourceForEditorInputFactory {
    @Inject
    private IResourceSetProvider resourceSetProvider;
    @Inject
    private IResourceFactory resourceFactory;
    @Inject
    private IExternalContentSupport externalContentSupport;
    @Inject
    private IExternalContentSupport.IExternalContentProvider externalContentProvider;

    public Resource createResource(IEditorInput editorInput) {
        try {
            IStorage storage;
            Resource result;
            if (editorInput instanceof IStorageEditorInput && (result = this.createResource(storage = ((IStorageEditorInput)editorInput).getStorage())) != null) {
                return result;
            }
        }
        catch (CoreException e) {
            throw new WrappedException((Exception)((Object)e));
        }
        throw new IllegalArgumentException("Couldn't create EMF Resource for input " + editorInput);
    }

    protected Resource createResource(IStorage storage) throws CoreException {
        return this.createResourceFor(storage);
    }

    protected Resource createResourceFor(IStorage storage) throws CoreException {
        ResourceSet resourceSet = this.getResourceSet(storage);
        URI uri = URI.createPlatformResourceURI((String)storage.getFullPath().toString(), (boolean)true);
        this.configureResourceSet(resourceSet, uri);
        URI normalized = resourceSet.getURIConverter().normalize(uri);
        XtextResource resource = (XtextResource)this.resourceFactory.createResource(normalized);
        resourceSet.getResources().add((Object)resource);
        resource.setValidationDisabled(false);
        return resource;
    }

    protected XtextResource createResource(ResourceSet resourceSet, URI uri) {
        Resource aResource = resourceSet.createResource(uri, "");
        if (!(aResource instanceof XtextResource)) {
            throw new IllegalStateException("The resource factory registered for " + uri + " does not yield an XtextResource. Make sure the file name extension is correct (case matters).");
        }
        return (XtextResource)aResource;
    }

    protected ResourceSet getResourceSet(IStorage storage) {
        if (storage instanceof IFile) {
            return this.resourceSetProvider.get(((IFile)storage).getProject());
        }
        return this.resourceSetProvider.get(null);
    }

    protected void configureResourceSet(ResourceSet resourceSet, URI primaryURI) {
        this.externalContentSupport.configureResourceSet(resourceSet, this.externalContentProvider);
    }

    protected IResourceSetProvider getResourceSetProvider() {
        return this.resourceSetProvider;
    }

    protected IExternalContentSupport getExternalContentSupport() {
        return this.externalContentSupport;
    }

    protected IExternalContentSupport.IExternalContentProvider getExternalContentProvider() {
        return this.externalContentProvider;
    }
}

