/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.compiler.batch;

import com.google.inject.Injector;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.log4j.BasicConfigurator;
import org.eclipse.xtext.xtend2.Xtend2StandaloneSetup;
import org.eclipse.xtext.xtend2.compiler.batch.Xtend2BatchCompiler;

public class Main {
    public static void main(String[] args) {
        BasicConfigurator.configure();
        Injector injector = new Xtend2StandaloneSetup().createInjectorAndDoEMFRegistration();
        Xtend2BatchCompiler xtend2BatchCompiler = (Xtend2BatchCompiler)injector.getInstance(Xtend2BatchCompiler.class);
        if (args == null || args.length == 0) {
            Main.printUsage();
            return;
        }
        Iterator<String> arguments = Arrays.asList(args).iterator();
        while (arguments.hasNext()) {
            String argument = arguments.next();
            if ("-d".equals(argument.trim())) {
                xtend2BatchCompiler.setOutputPath(arguments.next().trim());
                continue;
            }
            if ("-classpath".equals(argument.trim()) || "-cp".equals(argument.trim())) {
                xtend2BatchCompiler.setClassPath(arguments.next().trim());
                continue;
            }
            if ("-tempdir".equals(argument.trim()) || "-td".equals(argument.trim())) {
                xtend2BatchCompiler.setTempDirectory(arguments.next().trim());
                continue;
            }
            if ("-encoding".equals(argument.trim())) {
                xtend2BatchCompiler.setFileEncoding(arguments.next().trim());
                continue;
            }
            xtend2BatchCompiler.setSourcePath(argument);
        }
        xtend2BatchCompiler.compile();
    }

    private static void printUsage() {
        System.out.println("Usage: Xtend2BatchCompiler <options> <source directories>");
        System.out.println("where possible options include:");
        System.out.println("-d <directory>             Specify where to place generated xtend files");
        System.out.println("-tp <path>                 Temp directory to hold generated stubs and classes");
        System.out.println("-cp <path>                 Specify where to find user class files");
        System.out.println("-encoding <encoding>       Specify character encoding used by source files");
    }
}

