/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.autoedit;

import com.google.inject.Inject;
import com.google.inject.MembersInjector;
import com.google.inject.Provider;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.xtend.ide.autoedit.RichStringPartitionDelimiterSkippingStrategy;
import org.eclipse.xtext.formatting.IIndentationInformation;
import org.eclipse.xtext.ui.editor.autoedit.AbstractEditStrategyProvider;
import org.eclipse.xtext.ui.editor.autoedit.DefaultAutoEditStrategyProvider;
import org.eclipse.xtext.ui.editor.autoedit.MultiLineTerminalsEditStrategy;

public class AutoEditStrategyProvider
extends DefaultAutoEditStrategyProvider {
    @Inject
    protected MultiLineTerminalsEditStrategyInRichString.Factory multiLineTerminalsInRichString;
    @Inject
    protected Provider<RichStringPartitionDelimiterSkippingStrategy> richStringPartitionEndSkippingEditStrategy;

    protected void configureIndentationEditStrategy(AbstractEditStrategyProvider.IEditStrategyAcceptor acceptor) {
        super.configureIndentationEditStrategy(acceptor);
        acceptor.accept((IAutoEditStrategy)this.defaultIndentLineAutoEditStrategy.get(), "__rich_string");
    }

    protected void configureCurlyBracesBlock(AbstractEditStrategyProvider.IEditStrategyAcceptor acceptor) {
        super.configureCurlyBracesBlock(acceptor);
        acceptor.accept((IAutoEditStrategy)this.multiLineTerminalsInRichString.newInstance("{", null, "}"), "__rich_string");
    }

    protected void configureStringLiteral(AbstractEditStrategyProvider.IEditStrategyAcceptor acceptor) {
        acceptor.accept((IAutoEditStrategy)this.partitionInsert.newInstance("'''", "'''"), "__dftl_partition_content_type");
        acceptor.accept((IAutoEditStrategy)this.richStringPartitionEndSkippingEditStrategy.get(), "__rich_string");
        acceptor.accept((IAutoEditStrategy)this.partitionInsert.newInstance("\"", "\""), "__rich_string");
        acceptor.accept((IAutoEditStrategy)this.partitionInsert.newInstance("\u00ab", "\u00bb"), "__rich_string");
        acceptor.accept((IAutoEditStrategy)this.partitionDeletion.newInstance("\u00ab", "\u00bb"), "__rich_string");
        acceptor.accept((IAutoEditStrategy)this.singleLineTerminals.newInstance("\u00ab", "\u00bb"), "__dftl_partition_content_type");
        super.configureStringLiteral(acceptor);
    }

    public static class MultiLineTerminalsEditStrategyInRichString
    extends MultiLineTerminalsEditStrategy {
        public MultiLineTerminalsEditStrategyInRichString(String leftTerminal, String indentationString, String rightTerminal) {
            super(leftTerminal, indentationString, rightTerminal);
        }

        protected IRegion findStartTerminal(IDocument document, int offset) throws BadLocationException {
            IRegion result = super.findStartTerminal(document, offset);
            if (result == null) {
                return result;
            }
            String textBetween = document.get(result.getOffset() + result.getLength(), offset - (result.getOffset() + result.getLength()));
            if (textBetween.trim().length() != 0) {
                return null;
            }
            return result;
        }

        protected boolean atEndOfLineInput(IDocument document, int offset) throws BadLocationException {
            IRegion line = document.getLineInformation(document.getLineOfOffset(offset));
            String trimmedSubsequentCharacters = document.get(offset, line.getOffset() + line.getLength() - offset).trim();
            if (trimmedSubsequentCharacters.length() == 0) {
                return true;
            }
            return trimmedSubsequentCharacters.startsWith("'''");
        }

        public static class Factory {
            @Inject
            private MembersInjector<MultiLineTerminalsEditStrategy> injector;
            @Inject
            private IIndentationInformation indentationInformation;

            public MultiLineTerminalsEditStrategy newInstance(String leftTerminal, String indentationString, String rightTerminal) {
                indentationString = indentationString == null ? this.indentationInformation.getIndentString() : indentationString;
                MultiLineTerminalsEditStrategyInRichString strategy = new MultiLineTerminalsEditStrategyInRichString(leftTerminal, indentationString, rightTerminal);
                this.injector.injectMembers((Object)strategy);
                return strategy;
            }
        }
    }
}

