/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.scoping.batch.ConstructorDescription;
import org.eclipse.xtext.xbase.scoping.batch.DelegatingScopes;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.SimpleIdentifiableElementDescription;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;

public class ConstructorScopes
extends DelegatingScopes {
    public static final int CONSTRUCTOR_BUCKET = 1;

    public IScope createConstructorScope(EObject context, EReference reference, IFeatureScopeSession session, IResolvedTypes resolvedTypes) {
        if (!(context instanceof XConstructorCall)) {
            return IScope.NULLSCOPE;
        }
        IScope result = this.doCreateConstructorScope(context, session);
        return result;
    }

    protected IScope doCreateConstructorScope(final EObject context, final IFeatureScopeSession session) {
        final IScope delegateScope = this.getDelegate().getScope(context, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE);
        return new IScope(){

            public Iterable<IEObjectDescription> getAllElements() {
                throw new UnsupportedOperationException();
            }

            protected Iterable<IEObjectDescription> createFeatureDescriptions(Iterable<IEObjectDescription> original) {
                ArrayList result = Lists.newArrayListWithCapacity((int)3);
                for (IEObjectDescription description : original) {
                    EObject proxy = description.getEObjectOrProxy();
                    if (proxy.eIsProxy()) {
                        proxy = EcoreUtil.resolve((EObject)proxy, (EObject)context);
                    }
                    if (!proxy.eIsProxy() && proxy instanceof JvmGenericType) {
                        JvmGenericType type = (JvmGenericType)proxy;
                        if (!type.isInterface()) {
                            for (JvmConstructor constructor : type.getDeclaredConstructors()) {
                                boolean visible = session.isVisible((JvmMember)constructor);
                                ConstructorDescription constructorDescription = new ConstructorDescription(description.getName(), constructor, 1, visible);
                                result.add(constructorDescription);
                            }
                            continue;
                        }
                        result.add(new SimpleIdentifiableElementDescription(description));
                        continue;
                    }
                    if (!(proxy instanceof JvmType)) continue;
                    result.add(new SimpleIdentifiableElementDescription(description));
                }
                return result;
            }

            public Iterable<IEObjectDescription> getElements(EObject object) {
                throw new UnsupportedOperationException();
            }

            public Iterable<IEObjectDescription> getElements(QualifiedName name) {
                Iterable original = delegateScope.getElements(name);
                return this.createFeatureDescriptions(original);
            }

            public IEObjectDescription getSingleElement(EObject object) {
                throw new UnsupportedOperationException();
            }

            public IEObjectDescription getSingleElement(QualifiedName name) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean isConstructorCallScope(EReference reference) {
        return reference == XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR;
    }
}

