/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.xtext.AbstractMetamodelDeclaration;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.GeneratedMetamodel;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.XtextFactory;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.diagnostics.AbstractDiagnosticProducerDecorator;
import org.eclipse.xtext.diagnostics.DiagnosticMessage;
import org.eclipse.xtext.diagnostics.ExceptionDiagnostic;
import org.eclipse.xtext.diagnostics.IDiagnosticConsumer;
import org.eclipse.xtext.diagnostics.IDiagnosticProducer;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.linking.impl.Linker;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.antlr.IReferableElementsUnloader;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.OnChangeEvictingCache;
import org.eclipse.xtext.xtext.XtextMetamodelReferenceHelper;
import org.eclipse.xtext.xtext.ecoreInference.IXtext2EcorePostProcessor;
import org.eclipse.xtext.xtext.ecoreInference.TransformationDiagnosticsProducer;
import org.eclipse.xtext.xtext.ecoreInference.Xtext2EcoreTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtextLinker
extends Linker {
    private static Logger log = Logger.getLogger(XtextLinker.class);
    @Inject
    private IScopeProvider scopeProvider;
    @Inject(optional=true)
    private IXtext2EcorePostProcessor postProcessor;
    @Inject(optional=true)
    private IReferableElementsUnloader unloader;
    @Inject
    private OnChangeEvictingCache cache;
    @Inject
    private PackageRemover packageRemover;

    public IScopeProvider getScopeProvider() {
        return this.scopeProvider;
    }

    public void setScopeProvider(IScopeProvider scopeProvider) {
        this.scopeProvider = scopeProvider;
    }

    public IXtext2EcorePostProcessor getPostProcessor() {
        return this.postProcessor;
    }

    public void setPostProcessor(IXtext2EcorePostProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }

    @Override
    protected IDiagnosticProducer createDiagnosticProducer(IDiagnosticConsumer consumer) {
        return new AbstractDiagnosticProducerDecorator(super.createDiagnosticProducer(consumer)){
            private boolean filter;
            {
                this.filter = false;
            }

            public void addDiagnostic(DiagnosticMessage message) {
                if (!this.filter) {
                    super.addDiagnostic(message);
                }
            }

            public void setTarget(EObject object, EStructuralFeature feature) {
                super.setTarget(object, feature);
                this.filter = this.isTypeRef(object, feature) || this.isGeneratedPackage(object, feature) || this.isEnumLiteral(object, feature);
            }

            private boolean isEnumLiteral(EObject object, EStructuralFeature feature) {
                if (feature == XtextPackage.eINSTANCE.getEnumLiteralDeclaration_EnumLiteral()) {
                    EnumRule rule = GrammarUtil.containingEnumRule(object);
                    return rule.getType() == null || rule.getType().getClassifier() == null;
                }
                return false;
            }

            private boolean isGeneratedPackage(EObject object, EStructuralFeature feature) {
                return feature == XtextPackage.eINSTANCE.getAbstractMetamodelDeclaration_EPackage() && object instanceof GeneratedMetamodel;
            }

            private boolean isTypeRef(EObject object, EStructuralFeature feature) {
                return feature == XtextPackage.eINSTANCE.getTypeRef_Classifier() && ((TypeRef)object).getMetamodel() instanceof GeneratedMetamodel;
            }
        };
    }

    @Override
    protected boolean canSetDefaultValues(EReference ref) {
        return super.canSetDefaultValues(ref) || ref == XtextPackage.Literals.CROSS_REFERENCE__TERMINAL;
    }

    @Override
    protected void setDefaultValueImpl(EObject obj, EReference ref, IDiagnosticProducer producer) {
        if (XtextPackage.eINSTANCE.getTypeRef_Metamodel() == ref) {
            TypeRef typeRef = (TypeRef)obj;
            String typeRefName = GrammarUtil.getTypeRefName(typeRef);
            List<EObject> metamodels = XtextMetamodelReferenceHelper.findBestMetamodelForType(typeRef, "", typeRefName, this.scopeProvider.getScope(typeRef, ref));
            if (metamodels.isEmpty() || metamodels.size() > 1) {
                producer.addDiagnostic(new DiagnosticMessage("Cannot find meta model for type '" + typeRefName + "'", Severity.ERROR, null, new String[0]));
            } else {
                typeRef.setMetamodel((AbstractMetamodelDeclaration)metamodels.get(0));
            }
        } else if (XtextPackage.eINSTANCE.getCrossReference_Terminal() == ref) {
            AbstractRule rule = GrammarUtil.findRuleForName(GrammarUtil.getGrammar(obj), "ID");
            if (rule == null) {
                producer.addDiagnostic(new DiagnosticMessage("Cannot resolve implicit reference to rule 'ID'", Severity.ERROR, null, new String[0]));
            } else {
                RuleCall call = XtextFactory.eINSTANCE.createRuleCall();
                call.setRule(rule);
                ((CrossReference)obj).setTerminal(call);
            }
        } else {
            super.setDefaultValueImpl(obj, ref, producer);
        }
    }

    @Override
    protected void beforeEnsureIsLinked(EObject obj, EReference ref, IDiagnosticProducer producer) {
        if (XtextPackage.eINSTANCE.getTypeRef_Classifier() == ref) {
            TypeRef typeRef = (TypeRef)obj;
            if (typeRef.getMetamodel() == null) {
                this.setDefaultValue(obj, XtextPackage.eINSTANCE.getTypeRef_Metamodel(), producer);
            }
        } else {
            super.beforeEnsureIsLinked(obj, ref, producer);
        }
    }

    protected Xtext2EcoreTransformer createTransformer(Grammar grammar, IDiagnosticConsumer consumer) {
        Xtext2EcoreTransformer transformer = new Xtext2EcoreTransformer(grammar);
        transformer.setErrorAcceptor(new TransformationDiagnosticsProducer(consumer));
        transformer.setPostProcessor(this.postProcessor);
        return transformer;
    }

    @Override
    protected void beforeModelLinked(EObject model, IDiagnosticConsumer diagnosticsConsumer) {
        this.discardGeneratedPackages(model);
        super.beforeModelLinked(model, diagnosticsConsumer);
        this.cache.getOrCreate(model.eResource()).ignoreNotifications();
    }

    void discardGeneratedPackages(EObject root) {
        if (root instanceof Grammar) {
            for (AbstractMetamodelDeclaration metamodelDeclaration : ((Grammar)root).getMetamodelDeclarations()) {
                Resource resource;
                EPackage ePackage;
                if (!(metamodelDeclaration instanceof GeneratedMetamodel) || (ePackage = ((GeneratedMetamodel)metamodelDeclaration).getEPackage()) == null || (resource = ePackage.eResource()) == null || resource.getResourceSet() == null) continue;
                if (this.unloader != null) {
                    for (EObject content : resource.getContents()) {
                        this.unloader.unloadRoot(content);
                    }
                }
                resource.getResourceSet().getResources().remove((Object)resource);
            }
        }
    }

    @Override
    protected void afterModelLinked(EObject model, IDiagnosticConsumer diagnosticsConsumer) {
        super.afterModelLinked(model, diagnosticsConsumer);
        this.cache.getOrCreate(model.eResource()).listenToNotifications();
    }

    @Override
    public void linkModel(EObject model, IDiagnosticConsumer consumer) {
        if (model instanceof Grammar) {
            Xtext2EcoreTransformer transformer = this.createTransformer((Grammar)model, consumer);
            transformer.removeGeneratedPackages();
            super.linkModel(model, consumer);
            this.updateOverriddenRules((Grammar)model);
            try {
                transformer.transform();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                consumer.consume(new ExceptionDiagnostic(e), Severity.ERROR);
            }
            if (!model.eResource().eAdapters().contains((Object)this.packageRemover)) {
                model.eResource().eAdapters().add((Object)this.packageRemover);
            }
        } else {
            super.linkModel(model, consumer);
        }
    }

    protected void updateOverriddenRules(Grammar grammar) {
        if (grammar.getUsedGrammars().isEmpty()) {
            return;
        }
        HashMap<String, AbstractRule> rulePerName = new HashMap<String, AbstractRule>(grammar.getRules().size());
        for (AbstractRule rule : grammar.getRules()) {
            rulePerName.put(rule.getName(), rule);
        }
        HashSet<Grammar> visitedGrammars = new HashSet<Grammar>();
        visitedGrammars.add(grammar);
        for (Grammar usedGrammar : grammar.getUsedGrammars()) {
            this.updateOverriddenRules(usedGrammar, rulePerName, visitedGrammars);
        }
    }

    protected void updateOverriddenRules(Grammar grammar, Map<String, AbstractRule> rulePerName, Set<Grammar> visitedGrammars) {
        if (!visitedGrammars.add(grammar)) {
            return;
        }
        this.updateOverriddenRules(grammar, rulePerName);
        for (Grammar usedGrammar : grammar.getUsedGrammars()) {
            this.updateOverriddenRules(usedGrammar, rulePerName, visitedGrammars);
        }
    }

    protected void updateOverriddenRules(Grammar grammar, Map<String, AbstractRule> rulePerName) {
        if (grammar.isDefinesHiddenTokens()) {
            this.updateHiddenTokens((List<AbstractRule>)grammar.getHiddenTokens(), rulePerName);
        }
        for (AbstractRule rule : grammar.getRules()) {
            if (!(rule instanceof ParserRule) || !((ParserRule)rule).isDefinesHiddenTokens()) continue;
            this.updateHiddenTokens((List<AbstractRule>)((ParserRule)rule).getHiddenTokens(), rulePerName);
        }
        List<RuleCall> allRuleCalls = EcoreUtil2.getAllContentsOfType(grammar, RuleCall.class);
        for (RuleCall call : allRuleCalls) {
            AbstractRule rule;
            if (call.getRule() == null || (rule = rulePerName.get(call.getRule().getName())) == null) continue;
            call.setRule(rule);
        }
    }

    private void updateHiddenTokens(List<AbstractRule> hiddenTokens, Map<String, AbstractRule> rulePerName) {
        int i = 0;
        while (i < hiddenTokens.size()) {
            AbstractRule hidden = hiddenTokens.get(i);
            AbstractRule overridden = rulePerName.get(hidden.getName());
            if (overridden != null) {
                hiddenTokens.set(i, overridden);
            }
            ++i;
        }
    }

    @Override
    protected void clearReference(EObject obj, EReference ref) {
        ICompositeNode node;
        super.clearReference(obj, ref);
        if (obj.eIsSet((EStructuralFeature)ref) && ref.getEType().equals(XtextPackage.Literals.TYPE_REF) && (node = NodeModelUtils.getNode((EObject)obj.eGet((EStructuralFeature)ref))) == null) {
            obj.eUnset((EStructuralFeature)ref);
        }
        if (obj.eIsSet((EStructuralFeature)ref) && ref == XtextPackage.Literals.CROSS_REFERENCE__TERMINAL && (node = NodeModelUtils.getNode((EObject)obj.eGet((EStructuralFeature)ref))) == null) {
            obj.eUnset((EStructuralFeature)ref);
        }
    }

    public void setPackageRemover(PackageRemover packageRemover) {
        this.packageRemover = packageRemover;
    }

    public PackageRemover getPackageRemover() {
        return this.packageRemover;
    }

    public void setCache(OnChangeEvictingCache cache) {
        this.cache = cache;
    }

    public OnChangeEvictingCache getCache() {
        return this.cache;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PackageRemover
    extends EContentAdapter {
        @Inject
        private IReferableElementsUnloader unloader;

        public void notifyChanged(Notification msg) {
            super.notifyChanged(msg);
            if (!msg.isTouch() && msg.getOldValue() != null) {
                Resource notifyingResource;
                if (!(msg.getNotifier() instanceof Resource)) {
                    Object feature = msg.getFeature();
                    if (!(feature instanceof EReference)) {
                        return;
                    }
                    EReference ref = (EReference)feature;
                    if (!ref.isContainment()) {
                        return;
                    }
                    notifyingResource = ((EObject)msg.getNotifier()).eResource();
                } else {
                    notifyingResource = (Resource)msg.getNotifier();
                }
                if (notifyingResource == null) {
                    return;
                }
                ResourceSet set = notifyingResource.getResourceSet();
                if (set == null) {
                    return;
                }
                switch (msg.getEventType()) {
                    case 1: 
                    case 4: 
                    case 6: {
                        Object oldValue = msg.getOldValue();
                        HashSet referencedResources = Sets.newHashSet((Object[])new Resource[]{notifyingResource});
                        HashSet<Resource> resourcesToRemove = new HashSet<Resource>();
                        if (oldValue instanceof Grammar) {
                            for (AbstractMetamodelDeclaration declaration : ((Grammar)oldValue).getMetamodelDeclarations()) {
                                EPackage pack = declaration.getEPackage();
                                if (pack == null || pack.eResource() == null) continue;
                                resourcesToRemove.add(pack.eResource());
                                if (!this.isPackageReferenced(set, pack, (Collection<AbstractMetamodelDeclaration>)((Grammar)oldValue).getMetamodelDeclarations())) continue;
                                referencedResources.add(pack.eResource());
                            }
                        } else if (oldValue instanceof AbstractMetamodelDeclaration) {
                            EPackage pack = ((AbstractMetamodelDeclaration)oldValue).getEPackage();
                            if (pack != null && pack.eResource() != null) {
                                resourcesToRemove.add(pack.eResource());
                                if (this.isPackageReferenced(set, pack, Collections.singletonList((AbstractMetamodelDeclaration)oldValue))) {
                                    referencedResources.add(pack.eResource());
                                }
                            }
                        } else if (oldValue instanceof Collection && XtextPackage.Literals.GRAMMAR__METAMODEL_DECLARATIONS == msg.getFeature()) {
                            Collection metamodelDeclarations = (Collection)oldValue;
                            for (AbstractMetamodelDeclaration declaration : metamodelDeclarations) {
                                EPackage pack = declaration.getEPackage();
                                if (pack == null || pack.eResource() == null) continue;
                                resourcesToRemove.add(pack.eResource());
                                if (!this.isPackageReferenced(set, pack, metamodelDeclarations)) continue;
                                referencedResources.add(pack.eResource());
                            }
                        }
                        resourcesToRemove.removeAll(referencedResources);
                        if (this.unloader != null) {
                            for (Resource resource : resourcesToRemove) {
                                for (EObject content : resource.getContents()) {
                                    this.unloader.unloadRoot(content);
                                }
                            }
                        }
                        set.getResources().removeAll(resourcesToRemove);
                        break;
                    }
                }
            }
        }

        public boolean isPackageReferenced(ResourceSet set, EPackage pack, Collection<AbstractMetamodelDeclaration> knownReferences) {
            int i = 0;
            while (i < set.getResources().size()) {
                Resource resource = (Resource)set.getResources().get(i);
                if (resource != null) {
                    for (EObject content : resource.getContents()) {
                        if (!(content instanceof Grammar)) continue;
                        for (AbstractMetamodelDeclaration decl : ((Grammar)content).getMetamodelDeclarations()) {
                            if (!pack.equals(decl.getEPackage()) || knownReferences.contains(decl)) continue;
                            return true;
                        }
                    }
                }
                ++i;
            }
            return false;
        }

        public void setUnloader(IReferableElementsUnloader unloader) {
            this.unloader = unloader;
        }

        public IReferableElementsUnloader getUnloader() {
            return this.unloader;
        }
    }
}

