/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.resource;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.xtext.resource.IClasspathUriResolver;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.ui.resource.IStorage2UriMapperJdtExtensions;
import org.eclipse.xtext.ui.util.JdtClasspathUriResolver;
import org.eclipse.xtext.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtextResourceSetProvider
implements IResourceSetProvider {
    private static final Logger LOG = Logger.getLogger(XtextResourceSetProvider.class);
    @Inject
    private Provider<XtextResourceSet> resourceSetProvider;
    @Inject
    private IStorage2UriMapperJdtExtensions storage2UriMapper;

    @Override
    public ResourceSet get(IProject project) {
        XtextResourceSet set = (XtextResourceSet)this.resourceSetProvider.get();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null && javaProject.exists()) {
            set.getURIConverter().getURIMap().putAll(this.computePlatformURIMap(javaProject));
            set.setClasspathURIContext((Object)javaProject);
            set.setClasspathUriResolver((IClasspathUriResolver)new JdtClasspathUriResolver());
        }
        return set;
    }

    protected Map<URI, URI> computePlatformURIMap(IJavaProject javaProject) {
        HashMap hashMap = Maps.newHashMap();
        try {
            hashMap.putAll(EcorePlugin.computePlatformURIMap());
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        if (!javaProject.exists()) {
            return hashMap;
        }
        try {
            IPackageFragmentRoot[] roots;
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots = javaProject.getAllPackageFragmentRoots();
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                try {
                    Pair<URI, URI> mapping = this.storage2UriMapper.getURIMapping(root);
                    if (mapping != null) {
                        hashMap.put((URI)mapping.getFirst(), (URI)mapping.getSecond());
                    }
                }
                catch (JavaModelException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
                ++n2;
            }
            IProject project = javaProject.getProject();
            IProject[] iProjectArray = project.getWorkspace().getRoot().getProjects();
            int n3 = iProjectArray.length;
            n = 0;
            while (n < n3) {
                IPath location;
                IProject iProject = iProjectArray[n];
                if (iProject.isAccessible() && (location = iProject.getLocation()) != null) {
                    hashMap.put(URI.createPlatformResourceURI((String)iProject.getName(), (boolean)true), URI.createFileURI((String)location.toFile().getPath()));
                }
                ++n;
            }
        }
        catch (JavaModelException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return hashMap;
    }
}

