/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.AbstractTypeReferencePairWalker;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentSource;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.UnboundTypeParameterPreservingSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.UnboundTypeReferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class DeferredTypeParameterHintCollector
extends AbstractTypeReferencePairWalker {
    public DeferredTypeParameterHintCollector(ITypeReferenceOwner owner) {
        super(owner);
    }

    @Override
    protected TypeParameterSubstitutor<?> createTypeParameterSubstitutor(Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> mapping) {
        return new UnboundTypeParameterPreservingSubstitutor(mapping, this.getOwner());
    }

    protected LightweightTypeReference copy(UnboundTypeReference reference) {
        return reference.copyInto(this.getOwner());
    }

    @Override
    protected AbstractTypeReferencePairWalker.UnboundTypeReferenceTraverser createUnboundTypeReferenceTraverser() {
        return new AbstractTypeReferencePairWalker.UnboundTypeReferenceTraverser(this){

            protected void doVisitTypeReference(LightweightTypeReference reference, UnboundTypeReference declaration) {
                if (declaration.internalIsResolved() || DeferredTypeParameterHintCollector.this.getOwner().isResolved(declaration.getHandle())) {
                    declaration.tryResolve();
                    DeferredTypeParameterHintCollector.this.outerVisit(declaration, reference, declaration, DeferredTypeParameterHintCollector.this.getExpectedVariance(), DeferredTypeParameterHintCollector.this.getActualVariance());
                } else if (reference.isValidHint()) {
                    DeferredTypeParameterHintCollector.this.addHint(declaration, reference);
                }
            }

            protected void doVisitCompoundTypeReference(CompoundTypeReference reference, UnboundTypeReference param) {
                this.doVisitTypeReference((LightweightTypeReference)reference, param);
            }
        };
    }

    @Override
    protected AbstractTypeReferencePairWalker.CompoundTypeReferenceTraverser createCompoundTypeReferenceTraverser() {
        return new AbstractTypeReferencePairWalker.CompoundTypeReferenceTraverser(this){

            protected void doVisitUnboundTypeReference(UnboundTypeReference reference, CompoundTypeReference declaration) {
                if (declaration.isSynonym()) {
                    super.doVisitUnboundTypeReference(reference, declaration);
                } else {
                    DeferredTypeParameterHintCollector.this.addHint(reference, declaration);
                }
            }
        };
    }

    @Override
    protected AbstractTypeReferencePairWalker.ParameterizedTypeReferenceTraverser createParameterizedTypeReferenceTraverser() {
        return new AbstractTypeReferencePairWalker.ParameterizedTypeReferenceTraverser(this){

            @Override
            public void doVisitUnboundTypeReference(UnboundTypeReference reference, ParameterizedTypeReference declaration) {
                DeferredTypeParameterHintCollector.this.addHint(reference, declaration);
            }

            @Override
            protected boolean shouldProcessInContextOf(JvmTypeParameter declaredTypeParameter, Set<JvmTypeParameter> boundParameters, Set<JvmTypeParameter> visited) {
                return !boundParameters.contains(declaredTypeParameter) || visited.add(declaredTypeParameter);
            }
        };
    }

    @Override
    protected JvmTypeParameter findMappedParameter(JvmTypeParameter parameter, Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> mapping, Collection<JvmTypeParameter> visited) {
        return UnboundTypeReferences.findMappedParameter(parameter, mapping, visited);
    }

    protected void addHint(UnboundTypeReference typeParameter, LightweightTypeReference reference) {
        LightweightTypeReference wrapped = reference.getWrapperTypeIfPrimitive();
        typeParameter.acceptHint(wrapped, BoundTypeArgumentSource.INFERRED_LATER, this.getOrigin(), this.getExpectedVariance(), this.getActualVariance());
    }
}

