/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.conversion.impl;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.util.Map;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractValueConverter;
import org.eclipse.xtext.parser.antlr.ITokenDefProvider;
import org.eclipse.xtext.parser.antlr.Lexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLexerBasedConverter<T>
extends AbstractValueConverter<T>
implements IValueConverter.RuleSpecific {
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.parser.antlr.Lexer.RUNTIME")
    private Provider<Lexer> lexerProvider;
    @Inject
    private ITokenDefProvider tokenDefProvider;
    private AbstractRule rule;

    @Override
    public String toString(T value) {
        this.assertValidValue(value);
        String result = this.toEscapedString(value);
        TokenSource tokenSource = this.getTokenSource(result);
        this.assertTokens(value, tokenSource, result);
        return result;
    }

    protected void assertTokens(T value, TokenSource tokenSource, String escapedString) {
        if (tokenSource == null) {
            return;
        }
        Token token = tokenSource.nextToken();
        if (!escapedString.equals(token.getText())) {
            throw this.createTokenContentMismatchException(value, escapedString, token);
        }
        if (!this.getRuleName().toUpperCase().equals(this.getRuleName(token))) {
            throw this.createTokenTypeMismatchException(value, escapedString, token);
        }
        Object reparsedValue = this.toValue(token.getText(), null);
        if (value != reparsedValue && !value.equals(reparsedValue)) {
            throw this.createTokenContentMismatchException(value, escapedString, token);
        }
    }

    protected ValueConverterException createTokenTypeMismatchException(T value, String escapedString, Token token) {
        return new ValueConverterException("The value '" + value + "' is an invalid " + this.getRuleName(), null, null);
    }

    protected ValueConverterException createTokenContentMismatchException(T value, String escapedString, Token token) {
        return new ValueConverterException("The value '" + value + "' is an invalid " + this.getRuleName(), null, null);
    }

    protected TokenSource getTokenSource(String escapedValue) {
        Lexer result = this.getLexer();
        if (result == null) {
            return null;
        }
        result.setCharStream((CharStream)new ANTLRStringStream(escapedValue));
        return result;
    }

    protected void assertValidValue(T value) {
        if (value == null) {
            throw new ValueConverterException(String.valueOf(this.getRuleName()) + " may not be null.", null, null);
        }
    }

    protected String getRuleName() {
        return this.getRule().getName();
    }

    protected String toEscapedString(T value) {
        return value.toString();
    }

    protected Lexer getLexer() {
        if (this.lexerProvider != null) {
            return (Lexer)((Object)this.lexerProvider.get());
        }
        return null;
    }

    protected String getRuleName(Token token) {
        String result = this.getTokenDefMap().get(token.getType());
        return result.substring("RULE_".length());
    }

    protected Map<Integer, String> getTokenDefMap() {
        return this.tokenDefProvider.getTokenDefMap();
    }

    protected AbstractRule getRule() {
        return this.rule;
    }

    @Override
    public void setRule(AbstractRule rule) {
        this.rule = rule;
    }

    public void setLexerProvider(Provider<Lexer> lexerProvider) {
        this.lexerProvider = lexerProvider;
    }

    public void setTokenDefProvider(ITokenDefProvider tokenDefProvider) {
        this.tokenDefProvider = tokenDefProvider;
    }

    protected ITokenDefProvider getTokenDefProvider() {
        return this.tokenDefProvider;
    }

    protected Provider<Lexer> getLexerProvider() {
        return this.lexerProvider;
    }
}

