/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.imports;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.core.search.BasicSearchEngine;
import org.eclipse.jdt.internal.core.search.IRestrictedAccessTypeRequestor;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.access.jdt.IJavaProjectProvider;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.common.types.util.VisibilityService;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.conversion.XbaseQualifiedNameValueConverter;
import org.eclipse.xtext.xbase.imports.IUnresolvedTypeResolver;
import org.eclipse.xtext.xbase.imports.TypeUsage;
import org.eclipse.xtext.xbase.imports.TypeUsages;
import org.eclipse.xtext.xbase.ui.imports.TypeChooser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractiveUnresolvedTypeResolver
implements IUnresolvedTypeResolver {
    private static final Logger LOG = Logger.getLogger(InteractiveUnresolvedTypeResolver.class);
    @Inject
    private TypeReferences typeRefs;
    @Inject
    private IJavaProjectProvider projectProvider;
    @Inject
    private VisibilityService visibilityService;
    @Inject
    private TypeChooser typeChooser;
    @Inject
    private XbaseQualifiedNameValueConverter nameValueConverter;

    public void resolve(TypeUsages typeUsages, XtextResource resource) {
        if (typeUsages.getUnresolvedTypeUsages().isEmpty() || resource == null) {
            return;
        }
        LinkedHashMultimap name2usage = LinkedHashMultimap.create();
        for (TypeUsage unresolved : typeUsages.getUnresolvedTypeUsages()) {
            String text = unresolved.getUsedTypeName();
            text = this.nameValueConverter.toValue(text, null);
            name2usage.put((Object)text, (Object)unresolved);
        }
        for (String name : name2usage.keySet()) {
            Collection usages;
            JvmDeclaredType resolvedType = this.resolve(name, usages = name2usage.get((Object)name), resource);
            if (resolvedType == null) continue;
            for (TypeUsage usage : usages) {
                typeUsages.addTypeUsage(resolvedType, usage.getSuffix(), usage.getTextRegion(), usage.getContext());
            }
        }
    }

    protected JvmDeclaredType resolve(String name, Iterable<TypeUsage> usages, XtextResource resource) {
        ArrayList candidateTypes;
        block5: {
            try {
                IJavaSearchScope javaSearchScope = this.getJavaSearchScope(resource);
                candidateTypes = Lists.newArrayList();
                JvmMember context = usages.iterator().next().getContext();
                JvmDeclaredType contextType = (JvmDeclaredType)EcoreUtil2.getContainerOfType((EObject)context, JvmDeclaredType.class);
                if (contextType != null) {
                    this.findCandidateTypes(contextType, name, javaSearchScope, new IAcceptor<JvmDeclaredType>(){

                        public void accept(JvmDeclaredType t) {
                            candidateTypes.add(t);
                        }
                    });
                }
                if (!candidateTypes.isEmpty()) break block5;
                return null;
            }
            catch (JavaModelException e) {
                LOG.error((Object)("Error searching for type named '" + Strings.notNull((Object)name) + "'"), (Throwable)e);
                return null;
            }
        }
        if (candidateTypes.size() == 1) {
            return (JvmDeclaredType)candidateTypes.get(0);
        }
        return this.typeChooser.choose(candidateTypes, usages, resource);
    }

    protected IJavaSearchScope getJavaSearchScope(XtextResource resource) {
        IJavaProject javaProject = this.projectProvider.getJavaProject(resource.getResourceSet());
        IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProject});
        return searchScope;
    }

    protected String getQualifiedTypeName(char[] packageName, char[][] enclosingTypeNames, char[] simpleTypeName) {
        StringBuilder fqName = new StringBuilder(packageName.length + simpleTypeName.length + 1);
        if (packageName.length != 0) {
            fqName.append(packageName);
            fqName.append('.');
        }
        char[][] cArray = enclosingTypeNames;
        int n = enclosingTypeNames.length;
        int n2 = 0;
        while (n2 < n) {
            char[] enclosingType = cArray[n2];
            fqName.append(enclosingType);
            fqName.append('.');
            ++n2;
        }
        fqName.append(simpleTypeName);
        String fqNameAsString = fqName.toString();
        return fqNameAsString;
    }

    protected void findCandidateTypes(final JvmDeclaredType contextType, String typeSimpleName, IJavaSearchScope searchScope, final IAcceptor<JvmDeclaredType> acceptor) throws JavaModelException {
        BasicSearchEngine searchEngine = new BasicSearchEngine();
        searchEngine.searchAllTypeNames(null, 0, typeSimpleName.toCharArray(), 0, 0, searchScope, new IRestrictedAccessTypeRequestor(){

            public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path, AccessRestriction access) {
                JvmType importType;
                String qualifiedTypeName = InteractiveUnresolvedTypeResolver.this.getQualifiedTypeName(packageName, enclosingTypeNames, simpleTypeName);
                if ((access == null || access.getProblemId() != 0x1000133 && !access.ignoreIfBetter()) && (importType = InteractiveUnresolvedTypeResolver.this.typeRefs.findDeclaredType(qualifiedTypeName, (Notifier)contextType.eResource())) instanceof JvmDeclaredType && InteractiveUnresolvedTypeResolver.this.visibilityService.isVisible((JvmMember)((JvmDeclaredType)importType), contextType)) {
                    acceptor.accept((Object)((JvmDeclaredType)importType));
                }
            }
        }, 3, (IProgressMonitor)new NullProgressMonitor());
    }
}

