/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.util;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.xtext.ui.util.JavaProjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginProjectFactory
extends JavaProjectFactory {
    protected List<String> requiredBundles;
    protected List<String> exportedPackages;
    protected List<String> importedPackages;
    protected String activatorClassName;

    public PluginProjectFactory addRequiredBundles(List<String> requiredBundles) {
        if (this.requiredBundles == null) {
            this.requiredBundles = Lists.newArrayList();
        }
        this.requiredBundles.addAll(requiredBundles);
        return this;
    }

    public PluginProjectFactory addExportedPackages(List<String> exportedPackages) {
        if (this.exportedPackages == null) {
            this.exportedPackages = Lists.newArrayList();
        }
        this.exportedPackages.addAll(exportedPackages);
        return this;
    }

    public PluginProjectFactory addImportedPackages(List<String> importedPackages) {
        if (this.importedPackages == null) {
            this.importedPackages = Lists.newArrayList();
        }
        this.importedPackages.addAll(importedPackages);
        return this;
    }

    public PluginProjectFactory setActivatorClassName(String activatorClassName) {
        this.activatorClassName = activatorClassName;
        return this;
    }

    @Override
    protected void enhanceProject(IProject project, SubMonitor subMonitor, Shell shell) throws CoreException {
        super.enhanceProject(project, subMonitor, shell);
        if (this.projectNatures.contains("org.eclipse.pde.PluginNature")) {
            this.createManifest(project, (IProgressMonitor)subMonitor.newChild(1));
            this.createBuildProperties(project, (IProgressMonitor)subMonitor.newChild(1));
        }
    }

    @Override
    protected void addMoreClasspathEntriesTo(List<IClasspathEntry> classpathEntries) {
        super.addMoreClasspathEntriesTo(classpathEntries);
        classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.pde.core.requiredPlugins")));
    }

    protected void createBuildProperties(IProject project, IProgressMonitor progressMonitor) {
        StringBuilder content = new StringBuilder("source.. = ");
        Iterator iterator = this.folders.iterator();
        while (iterator.hasNext()) {
            content.append((String)iterator.next()).append('/');
            if (!iterator.hasNext()) continue;
            content.append(",\\\n");
            content.append("          ");
        }
        content.append("\n");
        content.append("bin.includes = META-INF/,\\\n");
        content.append("               .,\\\n");
        content.append("               plugin.xml");
        this.createFile("build.properties", (IContainer)project, content.toString(), progressMonitor);
    }

    protected void createManifest(IProject project, IProgressMonitor progressMonitor) throws CoreException {
        StringBuilder content = new StringBuilder("Manifest-Version: 1.0\n");
        content.append("Bundle-ManifestVersion: 2\n");
        content.append("Bundle-Name: " + this.projectName + "\n");
        content.append("Bundle-Vendor: My Company\n");
        content.append("Bundle-Version: 1.0.0.qualifier\n");
        content.append("Bundle-SymbolicName: " + this.projectName + "; singleton:=true\n");
        if (this.activatorClassName != null) {
            content.append("Bundle-Activator: " + this.activatorClassName + "\n");
        }
        content.append("Bundle-ActivationPolicy: lazy\n");
        this.addToContent(content, this.requiredBundles, "Require-Bundle");
        this.addToContent(content, this.exportedPackages, "Export-Package");
        this.addToContent(content, this.importedPackages, "Import-Package");
        content.append("Bundle-RequiredExecutionEnvironment: J2SE-1.5\n");
        IFolder metaInf = project.getFolder("META-INF");
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)2);
        try {
            if (metaInf.exists()) {
                metaInf.delete(false, progressMonitor);
            }
            metaInf.create(false, true, (IProgressMonitor)subMonitor.newChild(1));
            this.createFile("MANIFEST.MF", (IContainer)metaInf, content.toString(), (IProgressMonitor)subMonitor.newChild(1));
        }
        finally {
            subMonitor.done();
        }
    }

    protected void addToContent(StringBuilder content, List<String> entries, String prefix) {
        if (entries != null && !entries.isEmpty()) {
            content.append(prefix).append(": ").append(entries.get(0));
            int i = 1;
            int x = entries.size();
            while (i < x) {
                content.append(",\n ").append(entries.get(i));
                ++i;
            }
            content.append("\n");
        }
    }

    @Override
    public PluginProjectFactory addBuilderIds(String ... builderIds) {
        return (PluginProjectFactory)super.addBuilderIds(builderIds);
    }

    @Override
    public PluginProjectFactory addFolders(List<String> folders) {
        return (PluginProjectFactory)super.addFolders((List)folders);
    }

    @Override
    public PluginProjectFactory setProjectName(String projectName) {
        return (PluginProjectFactory)super.setProjectName(projectName);
    }

    @Override
    public PluginProjectFactory addProjectNatures(String ... projectNatures) {
        return (PluginProjectFactory)super.addProjectNatures(projectNatures);
    }

    @Override
    public PluginProjectFactory addReferencedProjects(List<IProject> referencedProjects) {
        return (PluginProjectFactory)super.addReferencedProjects((List)referencedProjects);
    }

    @Override
    public PluginProjectFactory setLocation(IPath location) {
        return (PluginProjectFactory)super.setLocation(location);
    }

    @Override
    public PluginProjectFactory addWorkingSets(List<IWorkingSet> workingSets) {
        return (PluginProjectFactory)super.addWorkingSets((List)workingSets);
    }
}

