/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.builder;

import com.google.common.collect.HashMultimap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.xtend.core.macro.declaration.ResourceChangeRegistry;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtext.builder.impl.BuildScheduler;
import org.eclipse.xtext.builder.impl.IBuildFlag;
import org.eclipse.xtext.builder.impl.QueuedBuildData;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class UIResourceChangeRegistry
implements IResourceChangeListener,
ResourceChangeRegistry,
IResourceDeltaVisitor {
    private static final Logger logger = Logger.getLogger(UIResourceChangeRegistry.class);
    @Inject
    private QueuedBuildData queue;
    @Inject
    private BuildScheduler scheduler;
    @Inject
    private AbstractUIPlugin uiPlugin;
    private IWorkspace workspace;
    private final HashMultimap<IPath, URI> listeners = HashMultimap.create();

    public synchronized void resourceChanged(IResourceChangeEvent event) {
        try {
            IResourceDelta _delta = event.getDelta();
            _delta.accept((IResourceDeltaVisitor)this);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public synchronized void register(IPath resourcePath, XtendFile interestedFile) {
        Resource _eResource = interestedFile.eResource();
        URI _uRI = _eResource.getURI();
        this.listeners.put((Object)resourcePath, (Object)_uRI);
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        boolean _not;
        boolean _xblockexpression = false;
        boolean _hasRelevantChange = this.hasRelevantChange(delta);
        boolean bl = _not = !_hasRelevantChange;
        if (_not) {
            return true;
        }
        IResource _resource = delta.getResource();
        IPath _fullPath = _resource.getFullPath();
        Set interestedFiles = this.listeners.removeAll((Object)_fullPath);
        this.queue.queueURIs((Collection)interestedFiles);
        _xblockexpression = true;
        return _xblockexpression;
    }

    private boolean hasRelevantChange(final IResourceDelta delta) {
        boolean _equals;
        boolean _xifexpression = false;
        int _kind = delta.getKind();
        boolean bl = _equals = _kind == 4;
        if (_equals) {
            Functions.Function1<Integer, Boolean> _function = new Functions.Function1<Integer, Boolean>(){

                public Boolean apply(Integer it) {
                    int _flags = delta.getFlags();
                    int _bitwiseAnd = _flags & it;
                    return _bitwiseAnd == 0;
                }
            };
            _xifexpression = IterableExtensions.exists(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Integer[]{256, 0x100000, 262144})), (Functions.Function1)_function);
        } else {
            _xifexpression = true;
        }
        return _xifexpression;
    }

    @Inject
    public void init(IWorkspace workspace) {
        try {
            this.workspace = workspace;
            this.load();
            workspace.addSaveParticipant((Plugin)this.uiPlugin, new ISaveParticipant(){

                public void saving(ISaveContext context) throws CoreException {
                    UIResourceChangeRegistry.this.save();
                }

                public void doneSaving(ISaveContext context) {
                }

                public void prepareToSave(ISaveContext context) throws CoreException {
                }

                public void rollback(ISaveContext context) {
                }
            });
            workspace.addResourceChangeListener((IResourceChangeListener)this, 1);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private synchronized void load() {
        block12: {
            try {
                boolean _not;
                File location = this.getRegistryStateLocation();
                boolean _exists = location.exists();
                boolean bl = _not = !_exists;
                if (_not) {
                    this.forgetBuildState();
                    return;
                }
                FileInputStream in = new FileInputStream(location);
                try {
                    DataInputStream reader = new DataInputStream(in);
                    try {
                        block7: while (true) {
                            String path = reader.readUTF();
                            int numberOfUris = reader.readInt();
                            int i = 0;
                            while (true) {
                                if (i >= numberOfUris) continue block7;
                                String uri = reader.readUTF();
                                Path _path = new Path(path);
                                URI _createURI = URI.createURI((String)uri);
                                this.listeners.put((Object)_path, (Object)_createURI);
                                ++i;
                            }
                            break;
                        }
                    }
                    catch (Throwable _t) {
                        if (_t instanceof EOFException) {
                            EOFException eOFException = (EOFException)_t;
                            break block12;
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                }
                finally {
                    in.close();
                }
            }
            catch (Throwable _t_1) {
                if (_t_1 instanceof Exception) {
                    Exception e = (Exception)_t_1;
                    logger.warn((Object)"Could not load resource listener registry, scheduling a full build", (Throwable)e);
                    this.forgetBuildState();
                }
                throw Exceptions.sneakyThrow((Throwable)_t_1);
            }
        }
    }

    private synchronized void save() {
        try {
            File location = this.getRegistryStateLocation();
            FileOutputStream out = new FileOutputStream(location);
            try {
                final DataOutputStream writer = new DataOutputStream(out);
                Map _asMap = this.listeners.asMap();
                Set _entrySet = _asMap.entrySet();
                Procedures.Procedure1<Map.Entry<IPath, Collection<URI>>> _function = new Procedures.Procedure1<Map.Entry<IPath, Collection<URI>>>(){

                    public void apply(Map.Entry<IPath, Collection<URI>> entry) {
                        try {
                            IPath _key = entry.getKey();
                            String _string = _key.toString();
                            writer.writeUTF(_string);
                            Collection<URI> _value = entry.getValue();
                            int _size = _value.size();
                            writer.writeInt(_size);
                            Collection<URI> _value_1 = entry.getValue();
                            Procedures.Procedure1<URI> _function = new Procedures.Procedure1<URI>(){

                                public void apply(URI uri) {
                                    try {
                                        String _string = uri.toString();
                                        writer.writeUTF(_string);
                                    }
                                    catch (Throwable _e) {
                                        throw Exceptions.sneakyThrow((Throwable)_e);
                                    }
                                }
                            };
                            IterableExtensions.forEach(_value_1, (Procedures.Procedure1)_function);
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                IterableExtensions.forEach(_entrySet, (Procedures.Procedure1)_function);
            }
            finally {
                out.close();
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                logger.warn((Object)"Could not save resource listener registry", (Throwable)e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private File getRegistryStateLocation() {
        IPath _stateLocation = this.uiPlugin.getStateLocation();
        IPath _append = _stateLocation.append("resource.change.registry");
        return _append.toFile();
    }

    private void forgetBuildState() {
        IWorkspaceRoot _root = this.workspace.getRoot();
        IProject[] _projects = _root.getProjects();
        Functions.Function1<IProject, Boolean> _function = new Functions.Function1<IProject, Boolean>(){

            public Boolean apply(IProject it) {
                try {
                    boolean _hasNature_1;
                    boolean _hasNature;
                    boolean _and = false;
                    boolean _and_1 = false;
                    boolean _isAccessible = it.isAccessible();
                    _and_1 = !_isAccessible ? false : (_hasNature = it.hasNature("org.eclipse.xtext.ui.shared.xtextNature"));
                    _and = !_and_1 ? false : (_hasNature_1 = it.hasNature("org.eclipse.jdt.core.javanature"));
                    return _and;
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        Iterable projects = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_projects)), (Functions.Function1)_function);
        this.scheduler.scheduleBuildIfNecessary(projects, new IBuildFlag[]{IBuildFlag.FORGET_BUILD_STATE_ONLY});
    }
}

