/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.builder;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.builder.JDTAwareEclipseResourceFileSystemAccess2;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.util.RuntimeIOException;
import org.eclipse.xtext.util.Strings;

public class SourceRelativeFileSystemAccess
extends JDTAwareEclipseResourceFileSystemAccess2 {
    protected boolean ensureOutputConfigurationDirectoryExists(OutputConfiguration outputConfig) {
        try {
            super.ensureOutputConfigurationDirectoryExists(outputConfig);
            IContainer container = this.getContainer(outputConfig);
            this.addToSourceFolders(container);
            return true;
        }
        catch (CoreException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    protected IContainer getContainer(OutputConfiguration outputConfig) {
        if (!outputConfig.isUseOutputPerSourceFolder() && this.getCurrentSource() != null) {
            String path = String.valueOf(this.getCurrentSource()) + "/../" + outputConfig.getOutputDirectory();
            IPath workspaceRelativePath = this.getProject().getFullPath().append((IPath)new Path(path));
            return this.getProject().getParent().getFolder(workspaceRelativePath);
        }
        return super.getContainer(outputConfig);
    }

    public void flushSourceTraces(String generatorName) throws CoreException {
        Multimap sourceTraces = this.getSourceTraces();
        if (sourceTraces != null) {
            Set keys = sourceTraces.keySet();
            String source = this.getCurrentSource();
            IProject container = Strings.isEmpty((String)source) ? this.getProject() : this.getProject().getFolder(source);
            for (URI uri : keys) {
                if (uri == null || source == null) continue;
                Collection paths = sourceTraces.get((Object)uri);
                IFile sourceFile = container.getFile((IPath)new Path(uri.toFileString()));
                if (!sourceFile.exists()) continue;
                IPath[] tracePathArray = paths.toArray(new IPath[paths.size()]);
                this.getTraceMarkers().installMarker(sourceFile, generatorName, tracePathArray);
            }
        }
        this.resetSourceTraces();
    }
}

