/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.refactoring;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.ide.refactoring.DispatchRenameSupport;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.JvmModelDependentElementsCalculator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendDependentElementsCalculator
extends JvmModelDependentElementsCalculator {
    @Inject
    private IXtendJvmAssociations associations;
    @Inject
    private DispatchRenameSupport dispatchRenameSupport;

    public List<URI> getDependentElementURIs(EObject baseElement, IProgressMonitor monitor) {
        if (baseElement instanceof XtendFunction && ((XtendFunction)baseElement).isDispatch()) {
            HashSet result = Sets.newHashSet();
            for (JvmOperation dispatchOperation : this.dispatchRenameSupport.getAllDispatchOperations((XtendFunction)baseElement)) {
                result.add(EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)dispatchOperation));
                XtendFunction xtendFunction = this.associations.getXtendFunction(dispatchOperation);
                if (xtendFunction == null) continue;
                result.add(EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)xtendFunction));
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            return Lists.newArrayList((Iterable)result);
        }
        return super.getDependentElementURIs(baseElement, monitor);
    }
}

