/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.view;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import org.eclipse.core.internal.utils.WrappedRuntimeException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.text.SimpleJavaSourceViewerConfiguration;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.xtend.ide.labeling.XtendImages;
import org.eclipse.xtend.ide.view.DerivedSourceDropDownAction;
import org.eclipse.xtend.ide.view.DerivedSourceSelection;
import org.eclipse.xtend.ide.view.Messages;
import org.eclipse.xtend.ide.view.OpenEditorAction;
import org.eclipse.xtext.generator.trace.ILocationInResource;
import org.eclipse.xtext.generator.trace.ITrace;
import org.eclipse.xtext.generator.trace.ITraceForStorageProvider;
import org.eclipse.xtext.ui.editor.SchedulingRuleFactory;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;
import org.eclipse.xtext.ui.views.AbstractSourceView;
import org.eclipse.xtext.ui.views.DefaultWorkbenchPartSelection;
import org.eclipse.xtext.ui.views.IWorkbenchPartSelection;
import org.eclipse.xtext.util.Files;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.TextRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerivedSourceView
extends AbstractSourceView
implements IResourceChangeListener {
    protected static final int VERTICAL_RULER_WIDTH = 12;
    protected static final int OVERVIEW_RULER_WIDTH = 12;
    private static final String SEARCH_ANNOTATION_TYPE = "org.eclipse.search.results";
    private static final ISchedulingRule SEQUENCE_RULE = SchedulingRuleFactory.INSTANCE.newSequence();
    @Inject
    private ITraceForStorageProvider traceInformation;
    @Inject
    private XtendImages xtendImages;
    @Inject
    private IPreferenceStoreAccess preferenceStoreAccess;
    @Inject
    private IWorkspace workspace;
    private DefaultMarkerAnnotationAccess defaultMarkerAnnotationAccess = new DefaultMarkerAnnotationAccess();
    private SourceViewerDecorationSupport sourceViewerDecorationSupport;
    private JavaSourceViewer javaSourceViewer;
    private SimpleJavaSourceViewerConfiguration javaSourceViewerConfiguration;
    private IStorage selectedSource;
    private Set<IStorage> derivedSources = Sets.newHashSet();
    private RefreshJob refreshJob = new RefreshJob(SEQUENCE_RULE);
    private MarkerAnnotationPreferences markerAnnotationPreferences = EditorsPlugin.getDefault().getMarkerAnnotationPreferences();
    private OpenEditorAction openEditorAction;
    private LineNumberRulerColumn lineNumberRulerColumn;

    IStorage getSelectedSource() {
        return this.selectedSource;
    }

    Set<IStorage> getDerivedSources() {
        return this.derivedSources;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.createActions();
    }

    private void createActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        this.openEditorAction = new OpenEditorAction(this);
        this.openEditorAction.setEnabled(false);
        toolBarManager.add((IAction)this.openEditorAction);
        toolBarManager.add((IAction)new DerivedSourceDropDownAction(this));
    }

    protected SourceViewer createSourceViewer(Composite parent) {
        IPreferenceStore store = JavaPlugin.getDefault().getCombinedPreferenceStore();
        OverviewRuler overviewRuler = new OverviewRuler((IAnnotationAccess)this.defaultMarkerAnnotationAccess, 12, EditorsUI.getSharedTextColors());
        AnnotationRulerColumn annotationRulerColumn = new AnnotationRulerColumn(12, (IAnnotationAccess)this.defaultMarkerAnnotationAccess);
        List annotationPreferences = this.markerAnnotationPreferences.getAnnotationPreferences();
        for (AnnotationPreference annotationPreference : annotationPreferences) {
            String key = annotationPreference.getVerticalRulerPreferenceKey();
            boolean showAnnotation = true;
            if (key != null && store.contains(key)) {
                showAnnotation = store.getBoolean(key);
            }
            if (!showAnnotation) continue;
            annotationRulerColumn.addAnnotationType(annotationPreference.getAnnotationType());
        }
        annotationRulerColumn.addAnnotationType((Object)"org.eclipse.text.annotation.unknown");
        this.lineNumberRulerColumn = new LineNumberRulerColumn();
        CompositeRuler compositeRuler = new CompositeRuler();
        compositeRuler.addDecorator(0, (IVerticalRulerColumn)annotationRulerColumn);
        compositeRuler.addDecorator(1, (IVerticalRulerColumn)this.lineNumberRulerColumn);
        this.javaSourceViewer = new JavaSourceViewer(parent, (IVerticalRuler)compositeRuler, (IOverviewRuler)overviewRuler, true, 768, store);
        this.javaSourceViewerConfiguration = new SimpleJavaSourceViewerConfiguration(JavaPlugin.getDefault().getJavaTextTools().getColorManager(), store, null, "___java_partitioning", true);
        this.javaSourceViewer.configure((SourceViewerConfiguration)this.javaSourceViewerConfiguration);
        this.javaSourceViewer.setEditable(false);
        this.sourceViewerDecorationSupport = new SourceViewerDecorationSupport((ISourceViewer)this.javaSourceViewer, (IOverviewRuler)overviewRuler, (IAnnotationAccess)this.defaultMarkerAnnotationAccess, EditorsUI.getSharedTextColors());
        for (AnnotationPreference annotationPreference : annotationPreferences) {
            this.sourceViewerDecorationSupport.setAnnotationPreference(annotationPreference);
        }
        this.sourceViewerDecorationSupport.install(this.preferenceStoreAccess.getPreferenceStore());
        return this.javaSourceViewer;
    }

    protected void inititalizeColors() {
        IPreferenceStore store = this.preferenceStoreAccess.getPreferenceStore();
        JFaceResources.getColorRegistry().addListener((IPropertyChangeListener)this);
        StyledText textWidget = this.getSourceViewer().getTextWidget();
        textWidget.setForeground(this.getColorFromStore(store, "AbstractTextEditor.Color.Foreground.SystemDefault", 21, "AbstractTextEditor.Color.Foreground"));
        textWidget.setBackground(this.getColorFromStore(store, "AbstractTextEditor.Color.Background.SystemDefault", 29, "AbstractTextEditor.Color.Background"));
        this.lineNumberRulerColumn.setForeground(this.getColorFromStore(store, "lineNumberColor", 21, "lineNumberColor"));
        this.lineNumberRulerColumn.setBackground(this.getColorFromStore(store, "AbstractTextEditor.Color.Background.SystemDefault", 22, "AbstractTextEditor.Color.Background"));
        this.lineNumberRulerColumn.setFont(JFaceResources.getFont((String)this.getViewerFontName()));
    }

    private Color getColorFromStore(IPreferenceStore store, String isDefaultKey, int systemDefault, String key) {
        String isDefault = store.getString(isDefaultKey);
        if (Strings.isEmpty((String)isDefault) || Strings.equal((String)"true", (String)isDefault)) {
            return this.getDisplay().getSystemColor(systemDefault);
        }
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
        return EditorsPlugin.getDefault().getSharedTextColors().getColor(rgb);
    }

    protected boolean isValidSelection(IWorkbenchPartSelection workbenchPartSelection) {
        return super.isValidSelection(workbenchPartSelection) && this.traceInformation.getTraceToTarget(this.getEditorResource(workbenchPartSelection)) != null;
    }

    protected String getBackgroundColorKey() {
        return String.valueOf(this.getLanguageName()) + ".ui.DerivedSourceView.backgroundColor";
    }

    protected String getViewerFontName() {
        return String.valueOf(this.getLanguageName()) + ".ui.editors.textfont";
    }

    protected String computeInput(IWorkbenchPartSelection workbenchPartSelection) {
        IFile file;
        this.openEditorAction.setInputFile(null);
        this.openEditorAction.setSelectedRegion(null);
        ITrace trace = this.traceInformation.getTraceToTarget(this.getEditorResource(workbenchPartSelection));
        if (trace != null) {
            if (workbenchPartSelection instanceof DerivedSourceSelection) {
                DerivedSourceSelection derivedSourceSelection = (DerivedSourceSelection)workbenchPartSelection;
                this.selectedSource = derivedSourceSelection.getStorage();
            } else {
                this.derivedSources = Sets.newHashSet();
                TextRegion localRegion = this.mapTextRegion(workbenchPartSelection);
                Iterable transform = Iterables.transform((Iterable)trace.getAllAssociatedLocations((ITextRegion)localRegion), (Function)new Function<ILocationInResource, IStorage>(){

                    public IStorage apply(ILocationInResource input) {
                        return input.getStorage();
                    }
                });
                Iterables.addAll(this.derivedSources, (Iterable)transform);
                ILocationInResource bestAssociatedLocation = trace.getBestAssociatedLocation((ITextRegion)localRegion);
                if (bestAssociatedLocation != null) {
                    this.selectedSource = bestAssociatedLocation.getStorage();
                } else if (!this.derivedSources.isEmpty()) {
                    this.selectedSource = this.derivedSources.iterator().next();
                }
            }
        }
        if ((file = this.getSelectedFile()) != null && file.exists() && file.isSynchronized(1)) {
            this.openEditorAction.setInputFile(file);
            try {
                return Files.readStreamIntoString((InputStream)file.getContents());
            }
            catch (CoreException e) {
                throw new WrappedRuntimeException((Throwable)e);
            }
        }
        return null;
    }

    protected XtendImages getXtendImages() {
        return this.xtendImages;
    }

    protected IFile getSelectedFile() {
        return this.selectedSource != null ? this.workspace.getRoot().getFile(this.selectedSource.getFullPath()) : null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (this.javaSourceViewerConfiguration.affectsTextPresentation(event)) {
            this.javaSourceViewerConfiguration.handlePropertyChangeEvent(event);
            this.javaSourceViewer.invalidateTextPresentation();
        }
    }

    public void partVisible(IWorkbenchPartReference ref) {
        super.partVisible(ref);
        if (ref.getId().equals(this.getSite().getId())) {
            this.workspace.addResourceChangeListener((IResourceChangeListener)this);
        }
    }

    public void partHidden(IWorkbenchPartReference workbenchPartReference) {
        super.partHidden(workbenchPartReference);
        if (workbenchPartReference.getId().equals(this.getSite().getId())) {
            this.workspace.removeResourceChangeListener((IResourceChangeListener)this);
        }
        if (this.getWorkbenchPartSelection() != null && workbenchPartReference.getPart(false) == this.getWorkbenchPartSelection().getWorkbenchPart()) {
            this.selectedSource = null;
            this.openEditorAction.setInputFile(null);
            this.openEditorAction.setSelectedRegion(null);
            this.setWorkbenchPartSelection(null);
            this.setContentDescription("");
            this.setInput("");
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta child;
        if (this.selectedSource == null || this.getWorkbenchPartSelection() == null) {
            return;
        }
        IResourceDelta delta = event.getDelta();
        if (delta != null && (child = delta.findMember(this.selectedSource.getFullPath())) != null) {
            this.refreshJob.reschedule();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.sourceViewerDecorationSupport != null) {
            this.sourceViewerDecorationSupport.dispose();
        }
        this.workspace.removeResourceChangeListener((IResourceChangeListener)this);
    }

    protected String computeDescription(IWorkbenchPartSelection workbenchPartSelection) {
        if (this.selectedSource == null) {
            return super.computeDescription(workbenchPartSelection);
        }
        XtextEditor xtextEditor = (XtextEditor)workbenchPartSelection.getWorkbenchPart();
        if (xtextEditor.isDirty()) {
            return Messages.DerivedSourceView_EditorDirty;
        }
        return this.selectedSource.getFullPath().toString();
    }

    protected IDocument createDocument(String input) {
        IDocument document = super.createDocument(input);
        JavaPlugin.getDefault().getJavaTextTools().setupJavaDocumentPartitioner(document, "___java_partitioning");
        return document;
    }

    protected AnnotationModel createAnnotationModel() {
        IFile file = this.getSelectedFile();
        return file != null ? new ResourceMarkerAnnotationModel((IResource)file) : super.createAnnotationModel();
    }

    protected void selectAndReveal(IWorkbenchPartSelection workbenchPartSelection) {
        if (this.selectedSource != null) {
            IAnnotationModel annotationModel = this.getSourceViewer().getAnnotationModel();
            TextRegion localRegion = this.mapTextRegion(workbenchPartSelection);
            ITrace trace = this.traceInformation.getTraceToTarget(this.getEditorResource(workbenchPartSelection));
            if (trace != null) {
                ITextRegionWithLineInformation textRegion;
                Iterable allAssociatedLocations = trace.getAllAssociatedLocations((ITextRegion)localRegion, this.selectedSource);
                ILocationInResource firstLocationInResource = (ILocationInResource)Iterables.getFirst((Iterable)allAssociatedLocations, null);
                if (firstLocationInResource != null && (textRegion = firstLocationInResource.getTextRegion()) != null) {
                    this.openEditorAction.setSelectedRegion((ITextRegion)textRegion);
                    this.getSourceViewer().revealRange(textRegion.getOffset(), textRegion.getLength());
                }
                for (ILocationInResource locationInResource : allAssociatedLocations) {
                    ITextRegionWithLineInformation textRegion2 = locationInResource.getTextRegion();
                    if (textRegion2 == null) continue;
                    annotationModel.addAnnotation(new Annotation(SEARCH_ANNOTATION_TYPE, true, null), new Position(textRegion2.getOffset(), textRegion2.getLength()));
                }
            }
        }
    }

    private TextRegion mapTextRegion(IWorkbenchPartSelection workbenchPartSelection) {
        ITextSelection textSelection = (ITextSelection)workbenchPartSelection.getSelection();
        TextRegion localRegion = new TextRegion(textSelection.getOffset(), textSelection.getLength());
        return localRegion;
    }

    protected class RefreshJob
    extends UIJob {
        public RefreshJob(ISchedulingRule schedulingRule) {
            super(Messages.DerivedSourceView_RefreshJobTitle);
            this.setRule(schedulingRule);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            DerivedSourceView.this.computeAndSetInput((IWorkbenchPartSelection)new DefaultWorkbenchPartSelection(DerivedSourceView.this.getSite().getPage().getActivePart(), DerivedSourceView.this.getSite().getPage().getSelection()), true);
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }

        protected void reschedule() {
            this.cancel();
            this.schedule();
        }
    }
}

