/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Strings {
    public static final String[] EMPTY_ARRAY = new String[0];
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final char SEPARATOR = ':';
    private static final char[] separator = System.getProperty("line.separator").toCharArray();

    public static boolean equalsIgnoreWhitespace(String left, String right) {
        String l = left == null ? "" : left.replaceAll("\\s", "");
        String r = right == null ? "" : right.replaceAll("\\s", "");
        return l.equals(r);
    }

    public static boolean equal(String literal, String name) {
        return Strings.isEmpty(literal) ? Strings.isEmpty(name) : literal.equals(name);
    }

    public static String notNull(Object o) {
        return String.valueOf(o);
    }

    public static String emptyIfNull(String s) {
        return s == null ? "" : s;
    }

    public static String concat(String separator, List<String> list) {
        return Strings.concat(separator, list, 0);
    }

    public static <T> String toString(Collection<T> list, Function<T, String> toString, String delim) {
        StringBuffer buffer = new StringBuffer();
        Iterator<T> iterator = list.iterator();
        while (iterator.hasNext()) {
            T t = iterator.next();
            buffer.append((String)toString.apply(t));
            if (!iterator.hasNext()) continue;
            buffer.append(delim);
        }
        return buffer.toString();
    }

    public static String concat(String separator, List<String> list, int skip) {
        StringBuffer buff = new StringBuffer();
        int lastIndex = list.size() - skip;
        int i = 0;
        while (i < lastIndex) {
            buff.append(list.get(i));
            if (i + 1 < lastIndex) {
                buff.append(separator);
            }
            ++i;
        }
        String string = buff.toString();
        return string.trim().length() == 0 ? null : string;
    }

    public static String skipLastToken(String value, String separator) {
        int endIndex = value.lastIndexOf(separator);
        if (endIndex > 0) {
            return value.substring(0, endIndex);
        }
        return value;
    }

    public static String lastToken(String value, String separator) {
        int index = value.lastIndexOf(separator) + separator.length();
        if (index < value.length()) {
            return value.substring(index, value.length());
        }
        return "";
    }

    public static String toFirstUpper(String s) {
        if (s == null || s.length() == 0 || Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1);
    }

    public static boolean isEmpty(String s) {
        return s == null || s.equals("");
    }

    public static String newLine() {
        return System.getProperty("line.separator");
    }

    public static String toFirstLower(String s) {
        if (s == null || s.length() == 0 || Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        if (s.length() == 1) {
            return s.toLowerCase();
        }
        return String.valueOf(s.substring(0, 1).toLowerCase()) + s.substring(1);
    }

    public static String convertFromJavaString(String javaString, boolean useUnicode) {
        char[] convtBuf;
        char[] in = javaString.toCharArray();
        int off = 0;
        int len = javaString.length();
        char[] out = convtBuf = new char[len];
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            char aChar;
            if ((aChar = in[off++]) == '\\') {
                aChar = in[off++];
                if (useUnicode && aChar == 'u') {
                    int value = 0;
                    if (off + 4 > end) {
                        throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                    }
                    int i = 0;
                    while (i < 4) {
                        aChar = in[off++];
                        switch (aChar) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                value = (value << 4) + aChar - 48;
                                break;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                value = (value << 4) + 10 + aChar - 97;
                                break;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                value = (value << 4) + 10 + aChar - 65;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                        ++i;
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (aChar == 't') {
                    aChar = '\t';
                } else if (aChar == 'r') {
                    aChar = '\r';
                } else if (aChar == 'n') {
                    aChar = '\n';
                } else if (aChar == 'f') {
                    aChar = '\f';
                } else if (aChar == 'b') {
                    aChar = '\b';
                } else if (aChar == '\"') {
                    aChar = '\"';
                } else if (aChar == '\'') {
                    aChar = '\'';
                } else if (aChar == '\\') {
                    aChar = '\\';
                } else {
                    throw new IllegalArgumentException("Illegal escape character \\" + aChar);
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    public static String convertToJavaString(String theString) {
        return Strings.convertToJavaString(theString, true);
    }

    public static String convertToJavaString(String theString, boolean useUnicode) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuilder outBuffer = new StringBuilder(bufLen);
        int x = 0;
        while (x < len) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                } else {
                    outBuffer.append(aChar);
                }
            } else {
                switch (aChar) {
                    case ' ': {
                        outBuffer.append(' ');
                        break;
                    }
                    case '\t': {
                        outBuffer.append('\\');
                        outBuffer.append('t');
                        break;
                    }
                    case '\n': {
                        outBuffer.append('\\');
                        outBuffer.append('n');
                        break;
                    }
                    case '\r': {
                        outBuffer.append('\\');
                        outBuffer.append('r');
                        break;
                    }
                    case '\f': {
                        outBuffer.append('\\');
                        outBuffer.append('f');
                        break;
                    }
                    case '\b': {
                        outBuffer.append('\\');
                        outBuffer.append('b');
                        break;
                    }
                    case '\'': {
                        outBuffer.append('\\');
                        outBuffer.append('\'');
                        break;
                    }
                    case '\"': {
                        outBuffer.append('\\');
                        outBuffer.append('\"');
                        break;
                    }
                    default: {
                        if (useUnicode && (aChar < ' ' || aChar > '~')) {
                            outBuffer.append('\\');
                            outBuffer.append('u');
                            outBuffer.append(Strings.toHex(aChar >> 12 & 0xF));
                            outBuffer.append(Strings.toHex(aChar >> 8 & 0xF));
                            outBuffer.append(Strings.toHex(aChar >> 4 & 0xF));
                            outBuffer.append(Strings.toHex(aChar & 0xF));
                            break;
                        }
                        outBuffer.append(aChar);
                    }
                }
            }
            ++x;
        }
        return outBuffer.toString();
    }

    public static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    /*
     * Unable to fully structure code
     */
    public static List<String> split(String value, String delimiter) {
        result = new ArrayList<String>();
        lastIndex = 0;
        index = value.indexOf(delimiter, lastIndex);
        pendingEmptyStrings = 0;
        while (index != -1) {
            block4: {
                addMe = value.substring(lastIndex, index);
                if (addMe.length() != 0) ** GOTO lbl13
                ++pendingEmptyStrings;
                break block4;
lbl-1000:
                // 1 sources

                {
                    result.add("");
                    --pendingEmptyStrings;
lbl13:
                    // 2 sources

                    ** while (pendingEmptyStrings > 0)
                }
lbl14:
                // 1 sources

                result.add(addMe);
            }
            lastIndex = index + delimiter.length();
            index = value.indexOf(delimiter, lastIndex);
        }
        if (lastIndex != value.length()) {
            while (pendingEmptyStrings > 0) {
                result.add("");
                --pendingEmptyStrings;
            }
            result.add(value.substring(lastIndex));
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static List<String> split(String value, char delimiter) {
        result = new ArrayList<String>();
        lastIndex = 0;
        index = value.indexOf(delimiter, lastIndex);
        pendingEmptyStrings = 0;
        while (index != -1) {
            block4: {
                addMe = value.substring(lastIndex, index);
                if (addMe.length() != 0) ** GOTO lbl13
                ++pendingEmptyStrings;
                break block4;
lbl-1000:
                // 1 sources

                {
                    result.add("");
                    --pendingEmptyStrings;
lbl13:
                    // 2 sources

                    ** while (pendingEmptyStrings > 0)
                }
lbl14:
                // 1 sources

                result.add(addMe);
            }
            lastIndex = index + 1;
            index = value.indexOf(delimiter, lastIndex);
        }
        if (lastIndex != value.length()) {
            while (pendingEmptyStrings > 0) {
                result.add("");
                --pendingEmptyStrings;
            }
            result.add(value.substring(lastIndex));
        }
        return result;
    }

    public static String pack(String[] strings) {
        if (strings != null && strings.length > 0) {
            StringBuffer buffer = new StringBuffer();
            String[] stringArray = strings;
            int n = strings.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                buffer.append(s.length());
                buffer.append(':');
                buffer.append(s);
                ++n2;
            }
            return buffer.toString();
        }
        return null;
    }

    public static String[] unpack(String packed) {
        if (Strings.isEmpty(packed)) {
            return null;
        }
        ArrayList strings = Lists.newArrayList();
        Strings.unpack(strings, packed);
        return strings.toArray(new String[strings.size()]);
    }

    private static void unpack(List<String> strings, String packed) {
        int delimiterIndex = packed.indexOf(":");
        int size = Integer.parseInt(packed.substring(0, delimiterIndex));
        int endIndex = delimiterIndex + 1 + size;
        strings.add(packed.substring(delimiterIndex + 1, endIndex));
        if (endIndex < packed.length()) {
            Strings.unpack(strings, packed.substring(endIndex));
        }
    }

    public static String removeLeadingWhitespace(String indentationString) {
        int i = 0;
        while (i < indentationString.length() && Character.isWhitespace(indentationString.charAt(i))) {
            ++i;
        }
        return indentationString.substring(i);
    }

    public static int countLineBreaks(CharSequence text) {
        int result = 0;
        int length = text.length();
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            if (ch == '\r') {
                ++result;
                if (i + 1 < length && text.charAt(i + 1) == '\n') {
                    ++i;
                }
            } else if (ch == '\n') {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public static CharSequence trimTrailingLineBreak(CharSequence s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        if (s.charAt(s.length() - 1) == '\n') {
            if (s.length() > 1 && s.charAt(s.length() - 2) == '\r') {
                return s.subSequence(0, s.length() - 2);
            }
            return s.subSequence(0, s.length() - 1);
        }
        if (s.charAt(s.length() - 1) == '\r') {
            return s.subSequence(0, s.length() - 1);
        }
        return s;
    }

    public static int countLines(String text) {
        return Strings.countLines(text, separator);
    }

    public static int countLines(String text, char[] separator) {
        int line = 0;
        if (separator.length == 1) {
            char c = separator[0];
            int i = 0;
            while (i < text.length()) {
                if (text.charAt(i) == c) {
                    ++line;
                }
                ++i;
            }
        } else if (separator.length == 2) {
            char c1 = separator[0];
            char c2 = separator[1];
            int i = 0;
            while (i < text.length()) {
                if (text.charAt(i) == c1 && text.length() > i + 1 && text.charAt(i + 1) == c2) {
                    ++line;
                    ++i;
                } else if (text.charAt(i) == c2) {
                    ++line;
                }
                ++i;
            }
        } else {
            throw new IllegalArgumentException("Separators with more than two characters are unexpected");
        }
        return line;
    }

    public static String getLeadingWhiteSpace(String original) {
        int i = 0;
        while (i < original.length()) {
            if (!Character.isWhitespace(original.charAt(i))) {
                return original.substring(0, i);
            }
            ++i;
        }
        return original;
    }

    public static String wordWrap(String string, int maxCharsPerLine) {
        StringBuilder document = new StringBuilder();
        StringBuilder line = new StringBuilder();
        StringBuilder word = new StringBuilder();
        StringBuilder ws = new StringBuilder();
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (c == '\n') {
                line.append((CharSequence)ws);
                line.append((CharSequence)word);
                line.append("\n");
                document.append((CharSequence)line);
                line = new StringBuilder();
                word = new StringBuilder();
                ws = new StringBuilder();
            } else if (Character.isWhitespace(c)) {
                if (line.length() + word.length() + 1 > maxCharsPerLine) {
                    line.append("\n");
                    document.append((CharSequence)line);
                    line = new StringBuilder();
                    line.append((CharSequence)word);
                    word = new StringBuilder();
                    ws = new StringBuilder();
                    ws.append(c);
                } else if (word.length() == 0) {
                    ws.append(c);
                } else {
                    line.append((CharSequence)ws);
                    line.append((CharSequence)word);
                    word = new StringBuilder();
                    ws = new StringBuilder();
                    ws.append(c);
                }
            } else {
                word.append(c);
            }
            ++i;
        }
        if (line.length() + word.length() + 1 > maxCharsPerLine) {
            document.append((CharSequence)line);
            document.append("\n");
            document.append((CharSequence)word);
        } else {
            document.append((CharSequence)line);
            document.append((CharSequence)ws);
            document.append((CharSequence)word);
        }
        return document.toString();
    }
}

